/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc;

import com.google.bc.common.base.Joiner;
import com.google.bc.common.base.Preconditions;
import com.google.bc.common.base.Strings;
import com.google.bc.common.collect.Lists;
import com.google.bc.common.io.ByteStreams;
import com.google.bc.common.io.FileWriteMode;
import com.google.bc.common.io.Files;
import com.google.bc.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.renjin.gcc.GccException;
import org.renjin.gcc.PlatformUtils;
import org.renjin.gcc.gimple.CallingConventions;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleParser;

public class Gcc {
    private File workingDirectory;
    private File pluginLibrary;
    private List<File> includeDirectories = Lists.newArrayList();
    private static final Logger LOGGER = Logger.getLogger(Gcc.class.getName());
    private boolean debug;
    private File gimpleOutputDir;

    public Gcc() {
        this.gimpleOutputDir = this.workingDirectory = Files.createTempDir();
    }

    public Gcc(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.gimpleOutputDir = workingDirectory;
    }

    public void setPluginLibrary(File pluginLibrary) {
        this.pluginLibrary = pluginLibrary;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setGimpleOutputDir(File gimpleOutputDir) {
        this.gimpleOutputDir = gimpleOutputDir;
        this.gimpleOutputDir.mkdirs();
    }

    public File getGimpleOutputDir() {
        return this.gimpleOutputDir;
    }

    public GimpleCompilationUnit compileToGimple(File source, String ... compilerFlags) throws IOException {
        this.checkEnvironment();
        ArrayList arguments = Lists.newArrayList();
        arguments.add("-m32");
        arguments.add("-c");
        arguments.add("-S");
        arguments.addAll(Arrays.asList(compilerFlags));
        arguments.add("-fdump-tree-gimple-verbose-raw-vops");
        arguments.add("-save-temps");
        arguments.add("-fplugin=" + this.pluginLibrary.getAbsolutePath());
        File gimpleFile = new File(this.gimpleOutputDir, source.getName() + ".gimple");
        arguments.add("-fplugin-arg-bridge-json-output-file=" + gimpleFile.getAbsolutePath());
        for (File includeDir : this.includeDirectories) {
            arguments.add("-I");
            arguments.add(includeDir.getAbsolutePath());
        }
        arguments.add(source.getAbsolutePath());
        LOGGER.fine("Executing " + Joiner.on((String)" ").join((Iterable)arguments));
        this.callGcc(arguments);
        GimpleParser parser = new GimpleParser();
        GimpleCompilationUnit unit = parser.parse(gimpleFile);
        unit.setSourceFile(gimpleFile);
        unit.setCallingConvention(CallingConventions.fromFile(source));
        for (GimpleFunction fn : unit.getFunctions()) {
            fn.setCallingConvention(CallingConventions.fromFile(source));
        }
        return unit;
    }

    private String callGcc(List<String> arguments) throws IOException {
        ArrayList command = Lists.newArrayList();
        command.add("gcc-4.6");
        command.addAll(arguments);
        Process gcc = new ProcessBuilder(new String[0]).command(command).directory(this.workingDirectory).redirectErrorStream(true).start();
        OutputCollector outputCollector = new OutputCollector(gcc);
        Thread collectorThread = new Thread(outputCollector);
        collectorThread.start();
        try {
            gcc.waitFor();
            collectorThread.join();
        }
        catch (InterruptedException e) {
            throw new GccException("Compiler interrupted");
        }
        if (gcc.exitValue() != 0) {
            if (outputCollector.getOutput().contains("error trying to exec 'f951': execvp: No such file or directory")) {
                throw new GccException("Compilation failed: Fortran compiler is missing:\n" + outputCollector.getOutput());
            }
            throw new GccException("Compilation failed:\n" + outputCollector.getOutput());
        }
        return outputCollector.getOutput();
    }

    private void checkEnvironment() {
        if (PlatformUtils.OS == PlatformUtils.OSType.WINDOWS) {
            throw new GccException("Sorry, gcc-bridge does not work on Windows/Cygwin because of problems building \nand linking the required gcc plugin. You can still compile on a *NIX platform and use the resulting pure-Java class files on any platform.");
        }
    }

    public void addIncludeDirectory(File path) {
        this.includeDirectories.add(path);
    }

    public void extractPlugin() throws IOException {
        if (!Strings.isNullOrEmpty((String)System.getProperty("gcc.bridge.plugin"))) {
            this.pluginLibrary = new File(System.getProperty("gcc.bridge.plugin"));
            if (this.pluginLibrary.exists()) {
                System.err.println("Using bridge.so at " + this.pluginLibrary.getAbsolutePath());
                return;
            }
            System.err.println("bridge.so does not exist at " + this.pluginLibrary.getAbsolutePath());
        }
        this.pluginLibrary = new File(this.workingDirectory, "bridge.so");
        Gcc.extractPluginTo(this.pluginLibrary);
        this.pluginLibrary.deleteOnExit();
    }

    public static void extractPluginTo(File pluginLibrary) throws IOException {
        URL pluginResource;
        Preconditions.checkArgument((boolean)pluginLibrary.getName().endsWith(".so"), (Object)"plugin name must end in .so");
        String libraryName = PlatformUtils.getPortableLibraryName("gcc-bridge");
        try {
            pluginResource = Resources.getResource((String)("org/renjin/gcc/" + libraryName));
        }
        catch (IllegalArgumentException e) {
            throw new GccException("Could not find a bundled version of the gcc plugin for your platform.\n(Was expecting: /org/renjin/gcc/" + libraryName + " on the classpath.)\n" + "You will need to build it yourself and specify the path to the binary. ");
        }
        Resources.asByteSource((URL)pluginResource).copyTo(Files.asByteSink((File)pluginLibrary, (FileWriteMode[])new FileWriteMode[0]));
    }

    public void checkVersion() {
        try {
            String versionOutput = this.callGcc(Arrays.asList("--version"));
            if (!versionOutput.contains("4.6.3")) {
                System.err.println("WARNING: gcc-bridge has been tested against 4.6.3, other versions may not work correctly.");
            }
        }
        catch (IOException e) {
            throw new GccException("Failed to start GCC: " + e.getMessage() + ".\n" + "Make sure gcc 4.6.3 is installed.");
        }
    }

    private static class OutputCollector
    implements Runnable {
        private Process process;
        private String output;

        private OutputCollector(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.output = new String(ByteStreams.toByteArray((InputStream)this.process.getInputStream()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String getOutput() {
            return this.output;
        }
    }
}

