/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc;

import com.google.bc.common.collect.Lists;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.renjin.gcc.Gcc;
import org.renjin.gcc.GccException;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.gimple.GimpleCompilationUnit;

@Command(name="compile", description="Compile C/Fortran files to a JVM class file")
public class CompileCommand
implements Runnable {
    @Option(name={"-o"}, description="Output directory for class files", required=true)
    public File outputDirectory;
    @Option(name={"--class-name"}, description="The class name of the output class", required=true)
    public String className;
    @Option(name={"--package-name"}, description="The package name of the output class", required=true)
    public String packageName;
    @Option(name={"--plugin-path"}, description="Path to the gcc-bridge.so binary")
    public File pluginPath;
    @Option(name={"-v"}, description="Verbose mode")
    public boolean verbose;
    @Option(name={"-I"}, description="Add include directory for GCC")
    public List<String> includeDirs = Lists.newArrayList();
    @Option(name={"-d"}, description="Compile all sources in the given directory")
    public List<String> directories = Lists.newArrayList();
    @Arguments(description="Sources files to compile")
    public List<String> sourceFiles = Lists.newArrayList();

    @Override
    public void run() {
        List<GimpleCompilationUnit> units = this.compileToGimple();
        if (units.isEmpty()) {
            System.err.println("Nothing to compile");
            return;
        }
        GimpleCompiler compiler = new GimpleCompiler();
        compiler.setOutputDirectory(this.outputDirectory);
        compiler.setVerbose(this.verbose);
        compiler.setPackageName(this.packageName);
        compiler.setClassName(this.className);
        try {
            compiler.compile(units);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to translate or compile gimple", e);
        }
    }

    private List<GimpleCompilationUnit> compileToGimple() {
        ArrayList units = Lists.newArrayList();
        try {
            Gcc gcc = new Gcc();
            gcc.checkVersion();
            if (this.pluginPath == null) {
                gcc.extractPlugin();
            } else {
                if (!this.pluginPath.exists()) {
                    throw new GccException("Plugin binary not found at: " + this.pluginPath.getAbsolutePath());
                }
                gcc.setPluginLibrary(this.pluginPath);
            }
            for (String includeDir : this.includeDirs) {
                gcc.addIncludeDirectory(new File(includeDir));
            }
            for (String sourceFile : this.sourceFiles) {
                if (this.verbose) {
                    System.out.println("Compiling " + sourceFile + " to gimple...");
                }
                units.add(gcc.compileToGimple(new File(sourceFile), new String[0]));
            }
            for (String dirName : this.directories) {
                File dir;
                if (this.verbose) {
                    System.out.println("Looking for sources in " + dirName);
                }
                if (!(dir = new File(dirName)).exists() || dir.listFiles() == null) continue;
                for (File file : dir.listFiles()) {
                    if (!file.getName().toLowerCase().endsWith(".f") && !file.getName().endsWith(".f77") && !file.getName().endsWith(".c")) continue;
                    if (this.verbose) {
                        System.out.println("Compiling " + file.getAbsolutePath() + " to gimple...");
                    }
                    units.add(gcc.compileToGimple(file, new String[0]));
                }
            }
        }
        catch (GccException e) {
            System.err.println("GCC Compilation FAILED:");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return units;
    }
}

