/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind.layers;

import com.bc.ceres.core.ProgressMonitor;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.eo.GeoUtils;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.worldwind.layers.BaseLayer;
import org.esa.snap.worldwind.layers.WWLayer;

public class DefaultProductLayer
extends BaseLayer
implements WWLayer {
    private boolean enableSurfaceImages;
    private final ConcurrentHashMap<String, Polyline[]> outlineTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SurfaceImage> imageTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, PointPlacemark> labelTable = new ConcurrentHashMap();
    public WorldWindowGLCanvas theWWD = null;

    public DefaultProductLayer() {
        this.setName("Products");
    }

    public void setEnableSurfaceImages(boolean enableSurfaceImages) {
        this.enableSurfaceImages = enableSurfaceImages;
    }

    public String[] getProductNames() {
        ArrayList list = new ArrayList(this.outlineTable.keySet());
        Collections.sort(list);
        return list.toArray(new String[this.outlineTable.size()]);
    }

    private static String getUniqueName(Product product) {
        return product.getProductRefString() + product.getName();
    }

    public void setOpacity(double opacity) {
        super.setOpacity(opacity);
        for (Map.Entry<String, SurfaceImage> entry : this.imageTable.entrySet()) {
            entry.getValue().setOpacity(opacity);
        }
    }

    public void setOpacity(String name, double opacity) {
        SurfaceImage img = this.imageTable.get(name);
        if (img != null) {
            img.setOpacity(opacity);
        }
    }

    public double getOpacity(String name) {
        SurfaceImage img = this.imageTable.get(name);
        if (img != null) {
            return img.getOpacity();
        }
        Polyline[] lineList = this.outlineTable.get(name);
        return lineList != null ? 1.0 : 0.0;
    }

    @Override
    public void updateInfoAnnotation(SelectEvent event) {
    }

    @Override
    public void setSelectedProduct(Product product) {
        super.setSelectedProduct(product);
        if (this.selectedProduct != null) {
            String selName = DefaultProductLayer.getUniqueName(this.selectedProduct);
            for (String name : this.outlineTable.keySet()) {
                Polyline[] lineList = this.outlineTable.get(name);
                boolean highlight = name.equals(selName);
                for (Polyline line : lineList) {
                    line.setHighlighted(highlight);
                    line.setHighlightColor(Color.RED);
                }
            }
        }
    }

    @Override
    public void addProduct(Product product, WorldWindowGLCanvas wwd) {
        this.theWWD = wwd;
        String name = DefaultProductLayer.getUniqueName(product);
        if (this.outlineTable.get(name) != null) {
            return;
        }
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            String productType = product.getProductType();
            if (productType.equals("ASA_WVW_2P") || productType.equals("ASA_WVS_1P") || productType.equals("ASA_WVI_1P")) {
                this.addWaveProduct(product);
            }
        } else {
            InputProductValidator validator;
            if (this.enableSurfaceImages && (validator = new InputProductValidator(product)).isMapProjected() && product.getSceneGeoCoding() != null) {
                this.addSurfaceImage(product);
            }
            this.addOutline(product);
        }
    }

    private void addSurfaceImage(final Product product) {
        final String name = DefaultProductLayer.getUniqueName(product);
        SwingWorker worker = new SwingWorker(){

            protected SurfaceImage doInBackground() throws Exception {
                try {
                    Product newProduct = DefaultProductLayer.createSubsampledProduct(product);
                    Band band = newProduct.getBandAt(0);
                    BufferedImage image = ProductUtils.createRgbImage((RasterDataNode[])new RasterDataNode[]{band}, (ImageInfo)band.getImageInfo(ProgressMonitor.NULL), (ProgressMonitor)ProgressMonitor.NULL);
                    GeoPos geoPos1 = product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, 0.0), null);
                    GeoPos geoPos2 = product.getSceneGeoCoding().getGeoPos(new PixelPos((double)(product.getSceneRasterWidth() - 1), (double)(product.getSceneRasterHeight() - 1)), null);
                    Sector sector = new Sector(Angle.fromDegreesLatitude((double)geoPos1.getLat()), Angle.fromDegreesLatitude((double)geoPos2.getLat()), Angle.fromDegreesLongitude((double)geoPos1.getLon()), Angle.fromDegreesLongitude((double)geoPos2.getLon()));
                    SurfaceImage si = new SurfaceImage((Object)image, sector);
                    si.setOpacity(DefaultProductLayer.this.getOpacity());
                    return si;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public void done() {
                try {
                    SurfaceImage si;
                    if (DefaultProductLayer.this.imageTable.contains(name)) {
                        DefaultProductLayer.this.removeImage(name);
                    }
                    if ((si = (SurfaceImage)this.get()) != null) {
                        DefaultProductLayer.this.addRenderable((Renderable)si);
                        DefaultProductLayer.this.imageTable.put(name, si);
                    }
                }
                catch (Exception e) {
                    Dialogs.showError((String)e.getMessage());
                }
            }
        };
        worker.execute();
    }

    private void addOutline(Product product) {
        int step = Math.max(16, (product.getSceneRasterWidth() + product.getSceneRasterHeight()) / 250);
        GeneralPath[] boundaryPaths = ProductUtils.createGeoBoundaryPaths((Product)product, null, (int)step);
        Polyline[] polyLineList = new Polyline[boundaryPaths.length];
        int i = 0;
        int numPoints = 0;
        float centreLat = 0.0f;
        float centreLon = 0.0f;
        for (GeneralPath boundaryPath : boundaryPaths) {
            PathIterator it = boundaryPath.getPathIterator(null);
            float[] floats = new float[2];
            ArrayList<Position> positions = new ArrayList<Position>(4);
            it.currentSegment(floats);
            Position firstPosition = new Position(Angle.fromDegreesLatitude((double)floats[1]), Angle.fromDegreesLongitude((double)floats[0]), 0.0);
            positions.add(firstPosition);
            centreLat += floats[1];
            centreLon += floats[0];
            it.next();
            ++numPoints;
            while (!it.isDone()) {
                it.currentSegment(floats);
                positions.add(new Position(Angle.fromDegreesLatitude((double)floats[1]), Angle.fromDegreesLongitude((double)floats[0]), 0.0));
                centreLat += floats[1];
                centreLon += floats[0];
                it.next();
                ++numPoints;
            }
            positions.add(firstPosition);
            centreLat /= (float)numPoints;
            centreLon /= (float)numPoints;
            polyLineList[i] = new Polyline();
            polyLineList[i].setFollowTerrain(true);
            polyLineList[i].setPositions(positions);
            this.addRenderable((Renderable)polyLineList[i]);
            ++i;
        }
        Position centrePos = new Position(Angle.fromDegreesLatitude((double)centreLat), Angle.fromDegreesLongitude((double)centreLon), 0.0);
        PointPlacemark ppm = this.getLabelPlacemark(centrePos, String.valueOf(product.getRefNo()));
        ppm.setAltitudeMode(1);
        ppm.setEnableDecluttering(true);
        this.addRenderable((Renderable)ppm);
        this.outlineTable.put(DefaultProductLayer.getUniqueName(product), polyLineList);
        this.labelTable.put(DefaultProductLayer.getUniqueName(product), ppm);
    }

    private void addWaveProduct(Product product) {
        MetadataElement root = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement ggADS = root.getElement("GEOLOCATION_GRID_ADS");
        if (ggADS == null) {
            return;
        }
        MetadataElement[] geoElemList = ggADS.getElements();
        Polyline[] lineList = new Polyline[geoElemList.length];
        int cnt = 0;
        int numPoints = 0;
        float centreLat = 0.0f;
        float centreLon = 0.0f;
        for (MetadataElement geoElem : geoElemList) {
            double lat = geoElem.getAttributeDouble("center_lat", 0.0) / 1000000.0;
            double lon = geoElem.getAttributeDouble("center_long", 0.0) / 1000000.0;
            double heading = geoElem.getAttributeDouble("heading", 0.0);
            GeoUtils.LatLonHeading r1 = GeoUtils.vincenty_direct((double)lon, (double)lat, (double)5000.0, (double)heading);
            GeoUtils.LatLonHeading corner1 = GeoUtils.vincenty_direct((double)r1.lon, (double)r1.lat, (double)2500.0, (double)(heading - 90.0));
            GeoUtils.LatLonHeading corner2 = GeoUtils.vincenty_direct((double)r1.lon, (double)r1.lat, (double)2500.0, (double)(heading + 90.0));
            GeoUtils.LatLonHeading r2 = GeoUtils.vincenty_direct((double)lon, (double)lat, (double)5000.0, (double)(heading + 180.0));
            GeoUtils.LatLonHeading corner3 = GeoUtils.vincenty_direct((double)r2.lon, (double)r2.lat, (double)2500.0, (double)(heading - 90.0));
            GeoUtils.LatLonHeading corner4 = GeoUtils.vincenty_direct((double)r2.lon, (double)r2.lat, (double)2500.0, (double)(heading + 90.0));
            ArrayList<Position> positions = new ArrayList<Position>(4);
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner1.lat), Angle.fromDegreesLongitude((double)corner1.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner2.lat), Angle.fromDegreesLongitude((double)corner2.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner4.lat), Angle.fromDegreesLongitude((double)corner4.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner3.lat), Angle.fromDegreesLongitude((double)corner3.lon), 0.0));
            positions.add(new Position(Angle.fromDegreesLatitude((double)corner1.lat), Angle.fromDegreesLongitude((double)corner1.lon), 0.0));
            centreLat = (float)((double)centreLat + corner1.lat);
            centreLon = (float)((double)centreLon + corner1.lon);
            centreLat = (float)((double)centreLat + corner2.lat);
            centreLon = (float)((double)centreLon + corner2.lon);
            centreLat = (float)((double)centreLat + corner3.lat);
            centreLon = (float)((double)centreLon + corner3.lon);
            centreLat = (float)((double)centreLat + corner4.lat);
            centreLon = (float)((double)centreLon + corner4.lon);
            numPoints += 4;
            Polyline line = new Polyline();
            line.setFollowTerrain(true);
            line.setPositions(positions);
            this.addRenderable((Renderable)line);
            lineList[cnt++] = line;
        }
        Position centrePos = new Position(Angle.fromDegreesLatitude((double)(centreLat /= (float)numPoints)), Angle.fromDegreesLongitude((double)(centreLon /= (float)numPoints)), 0.0);
        PointPlacemark ppm = this.getLabelPlacemark(centrePos, String.valueOf(product.getRefNo()));
        ppm.setAltitudeMode(1);
        ppm.setEnableDecluttering(true);
        this.addRenderable((Renderable)ppm);
        this.outlineTable.put(DefaultProductLayer.getUniqueName(product), lineList);
        this.labelTable.put(DefaultProductLayer.getUniqueName(product), ppm);
    }

    private PointPlacemark getLabelPlacemark(Position pos, String label) {
        PointPlacemarkAttributes ppmAtttrs = new PointPlacemarkAttributes();
        ppmAtttrs.setLabelOffset(new Offset(Double.valueOf(0.0), Double.valueOf(0.0), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels"));
        ppmAtttrs.setScale(Double.valueOf(0.0));
        PointPlacemark ppm = new PointPlacemark(pos);
        ppm.setAttributes(ppmAtttrs);
        ppm.setLabelText(label);
        return ppm;
    }

    @Override
    public void removeProduct(Product product) {
        this.removeOutline(DefaultProductLayer.getUniqueName(product));
        this.removeImage(DefaultProductLayer.getUniqueName(product));
        this.removeLabel(DefaultProductLayer.getUniqueName(product));
    }

    private void removeOutline(String imagePath) {
        Polyline[] lineList = this.outlineTable.get(imagePath);
        if (lineList != null) {
            for (Polyline line : lineList) {
                this.removeRenderable((Renderable)line);
            }
            this.outlineTable.remove(imagePath);
        }
    }

    private void removeImage(String imagePath) {
        SurfaceImage si = this.imageTable.get(imagePath);
        if (si != null) {
            this.removeRenderable((Renderable)si);
            this.imageTable.remove(imagePath);
        }
    }

    private void removeLabel(String imagePath) {
        PointPlacemark ppm = this.labelTable.get(imagePath);
        if (ppm != null) {
            this.removeRenderable((Renderable)ppm);
            this.labelTable.remove(ppm);
        }
    }

    private static Product createSubsampledProduct(Product product) throws IOException {
        String quicklookBandName = ProductUtils.findSuitableQuicklookBandName((Product)product);
        ProductSubsetDef productSubsetDef = new ProductSubsetDef("subset");
        int scaleFactor = product.getSceneRasterWidth() / 1000;
        if (scaleFactor < 1) {
            scaleFactor = 1;
        }
        productSubsetDef.setSubSampling(scaleFactor, scaleFactor);
        productSubsetDef.setTreatVirtualBandsAsRealBands(true);
        productSubsetDef.setNodeNames(new String[]{quicklookBandName});
        Product productSubset = product.createSubset(productSubsetDef, quicklookBandName, null);
        InputProductValidator validator = new InputProductValidator(product);
        if (!validator.isMapProjected() && productSubset.getSceneGeoCoding() != null) {
            try {
                HashMap<String, String> projParameters = new HashMap<String, String>();
                HashMap<String, Product> projProducts = new HashMap<String, Product>();
                projProducts.put("source", productSubset);
                projParameters.put("crs", "WGS84(DD)");
                productSubset = GPF.createProduct((String)"Reproject", projParameters, projProducts);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return productSubset;
    }

    @Override
    public JPanel getControlPanel(final WorldWindowGLCanvas wwd) {
        final JSlider opacitySlider = new JSlider();
        opacitySlider.setMaximum(100);
        opacitySlider.setValue((int)(this.getOpacity() * 100.0));
        opacitySlider.setEnabled(true);
        opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = opacitySlider.getValue();
                DefaultProductLayer.this.setOpacity((double)value / 100.0);
                wwd.repaint();
            }
        });
        JPanel opacityPanel = new JPanel(new BorderLayout(5, 5));
        opacityPanel.add((Component)new JLabel("Opacity"), "West");
        opacityPanel.add((Component)opacitySlider, "Center");
        return opacityPanel;
    }
}

