/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.spectrum;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.ui.DecimalTableCellRenderer;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.LoadSaveRasterDataNodesConfigurationsComponent;
import org.esa.snap.ui.product.LoadSaveRasterDataNodesConfigurationsProvider;
import org.esa.snap.ui.product.spectrum.DisplayableSpectrum;
import org.esa.snap.ui.product.spectrum.SpectrumSelectionAdmin;
import org.esa.snap.ui.product.spectrum.SpectrumShapeProvider;
import org.esa.snap.ui.product.spectrum.SpectrumStrokeProvider;
import org.esa.snap.ui.tool.ToolButtonFactory;

public class SpectrumChooser
extends ModalDialog
implements LoadSaveRasterDataNodesConfigurationsComponent {
    private static final int band_selected_index = 0;
    private static final int band_name_index = 1;
    private static final int band_description_index = 2;
    private static final int band_wavelength_index = 3;
    private static final int band_bandwidth_ndex = 4;
    private static final int band_unit_index = 5;
    private final String[] band_columns = new String[]{"", "Band name", "Band description", "Spectral wavelength (nm)", "Spectral bandwidth (nm)", "Unit"};
    private static final ImageIcon[] icons = new ImageIcon[]{UIUtils.loadImageIcon("icons/PanelDown12.png"), UIUtils.loadImageIcon("icons/PanelUp12.png")};
    private static final ImageIcon[] roll_over_icons = new ImageIcon[]{ToolButtonFactory.createRolloverIcon(icons[0]), ToolButtonFactory.createRolloverIcon(icons[1])};
    private final DisplayableSpectrum[] originalSpectra;
    private DisplayableSpectrum[] spectra;
    private static SpectrumSelectionAdmin selectionAdmin;
    private static boolean selectionChangeLock;
    private JPanel spectraPanel;
    private final JPanel[] bandTablePanels;
    private final JTable[] bandTables;
    private final TristateCheckBox[] tristateCheckBoxes;
    private boolean[] collapsed;
    private TableLayout spectraPanelLayout;

    public SpectrumChooser(Window parent, DisplayableSpectrum[] originalSpectra) {
        super(parent, "Available Spectra", 161, "spectrumChooser");
        if (originalSpectra != null) {
            this.originalSpectra = originalSpectra;
            ArrayList<DisplayableSpectrum> spectraWithBands = new ArrayList<DisplayableSpectrum>();
            for (DisplayableSpectrum spectrum : originalSpectra) {
                if (!spectrum.hasBands()) continue;
                spectraWithBands.add(spectrum);
            }
            this.spectra = spectraWithBands.toArray(new DisplayableSpectrum[spectraWithBands.size()]);
        } else {
            this.originalSpectra = new DisplayableSpectrum[0];
            this.spectra = new DisplayableSpectrum[0];
        }
        selectionAdmin = new SpectrumSelectionAdmin();
        selectionChangeLock = false;
        this.bandTables = new JTable[this.spectra.length];
        this.collapsed = new boolean[this.spectra.length];
        Arrays.fill(this.collapsed, true);
        this.bandTablePanels = new JPanel[this.spectra.length];
        this.tristateCheckBoxes = new TristateCheckBox[this.spectra.length];
        this.initUI();
    }

    private void initUI() {
        JPanel content = new JPanel(new BorderLayout());
        this.initSpectraPanel();
        JScrollPane spectraScrollPane = new JScrollPane(this.spectraPanel);
        spectraScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        spectraScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        spectraScrollPane.setPreferredSize(new Dimension(spectraScrollPane.getPreferredSize().width, 180));
        content.add((Component)spectraScrollPane, "Center");
        LoadSaveRasterDataNodesConfigurationsProvider provider = new LoadSaveRasterDataNodesConfigurationsProvider(this);
        AbstractButton loadButton = provider.getLoadButton();
        AbstractButton saveButton = provider.getSaveButton();
        TableLayout layout = new TableLayout(1);
        layout.setTablePadding(4, 4);
        JPanel buttonPanel = new JPanel((LayoutManager)layout);
        buttonPanel.add(loadButton);
        buttonPanel.add(saveButton);
        buttonPanel.add(layout.createVerticalSpacer());
        content.add((Component)buttonPanel, "East");
        this.setContent(content);
    }

    private void initSpectraPanel() {
        this.spectraPanelLayout = new TableLayout(7);
        this.spectraPanelLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        this.spectraPanelLayout.setTableWeightY(Double.valueOf(0.0));
        this.spectraPanelLayout.setTableWeightX(Double.valueOf(1.0));
        this.spectraPanelLayout.setColumnWeightX(0, Double.valueOf(0.0));
        this.spectraPanelLayout.setColumnWeightX(1, Double.valueOf(0.0));
        this.spectraPanelLayout.setTablePadding(3, 3);
        this.spectraPanel = new JPanel((LayoutManager)this.spectraPanelLayout);
        this.spectraPanel.add(new JLabel(""));
        this.spectraPanel.add(new JLabel(""));
        this.spectraPanel.add(new JLabel("Spectrum Name"));
        this.spectraPanel.add(new JLabel("Unit"));
        this.spectraPanel.add(new JLabel("Line Style"));
        this.spectraPanel.add(new JLabel("Symbol"));
        this.spectraPanel.add(new JLabel("Symbol Size"));
        for (int i = 0; i < this.spectra.length; ++i) {
            selectionAdmin.evaluateSpectrumSelections(this.spectra[i]);
            this.addSpectrumComponentsToSpectraPanel(i);
            this.spectraPanelLayout.setCellColspan(i * 2 + 2, 1, Integer.valueOf(6));
            this.spectraPanel.add(new JLabel());
            this.bandTablePanels[i] = new JPanel(new BorderLayout());
            this.bandTablePanels[i].setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.spectraPanel.add(this.bandTablePanels[i]);
            this.bandTables[i] = this.createBandsTable(i);
        }
        this.spectraPanel.add(this.spectraPanelLayout.createVerticalSpacer());
        this.spectraPanel.updateUI();
    }

    private void addSpectrumComponentsToSpectraPanel(int index) {
        JComboBox<ImageIcon> strokeComboBox;
        DisplayableSpectrum spectrum = this.spectra[index];
        ImageIcon strokeIcon = spectrum.isDefaultOrRemainingBandsSpectrum() ? new ImageIcon() : SpectrumStrokeProvider.getStrokeIcon(spectrum.getLineStyle());
        AbstractButton collapseButton = ToolButtonFactory.createButton(icons[0], false);
        collapseButton.addActionListener(new CollapseListener(index));
        ImageIcon shapeIcon = SpectrumShapeProvider.getShapeIcon(spectrum.getSymbolIndex());
        this.spectraPanel.add(collapseButton);
        TristateCheckBox tristateCheckBox = new TristateCheckBox();
        tristateCheckBox.setState(selectionAdmin.getState(index));
        tristateCheckBox.addActionListener((ActionListener)new TristateCheckboxListener(index));
        this.tristateCheckBoxes[index] = tristateCheckBox;
        this.spectraPanel.add((Component)tristateCheckBox);
        JLabel spectrumNameLabel = new JLabel(spectrum.getName());
        Font font = spectrumNameLabel.getFont();
        font = new Font(font.getName(), 1, font.getSize());
        spectrumNameLabel.setFont(font);
        this.spectraPanel.add(spectrumNameLabel);
        this.spectraPanel.add(new JLabel(spectrum.getUnit()));
        if (spectrum.isDefaultOrRemainingBandsSpectrum()) {
            strokeComboBox = new JComboBox<ImageIcon>(new ImageIcon[]{strokeIcon});
            strokeComboBox.setEnabled(false);
        } else {
            strokeComboBox = new JComboBox<ImageIcon>(SpectrumStrokeProvider.getStrokeIcons());
            strokeComboBox.addActionListener(e -> spectrum.setLineStyle(SpectrumStrokeProvider.getStroke((ImageIcon)strokeComboBox.getSelectedItem())));
        }
        strokeComboBox.setPreferredSize(new Dimension(100, 20));
        strokeComboBox.setSelectedItem(strokeIcon);
        this.spectraPanel.add(strokeComboBox);
        JComboBox<ImageIcon> shapeComboBox = new JComboBox<ImageIcon>(SpectrumShapeProvider.getShapeIcons());
        JComboBox<Integer> shapeSizeComboBox = new JComboBox<Integer>(SpectrumShapeProvider.getScaleGrades());
        shapeComboBox.setPreferredSize(new Dimension(100, 20));
        shapeSizeComboBox.setPreferredSize(new Dimension(100, 20));
        shapeComboBox.setSelectedItem(shapeIcon);
        shapeComboBox.addActionListener(e -> {
            int shapeIndex = SpectrumShapeProvider.getShape((ImageIcon)shapeComboBox.getSelectedItem());
            spectrum.setSymbolIndex(shapeIndex);
            if (shapeIndex == 0) {
                shapeSizeComboBox.setSelectedItem("");
            } else {
                shapeSizeComboBox.setSelectedItem(spectrum.getSymbolSize());
            }
        });
        this.spectraPanel.add(shapeComboBox);
        shapeSizeComboBox.setSelectedItem(spectrum.getSymbolSize());
        shapeSizeComboBox.addActionListener(e -> {
            String selectedItem = shapeSizeComboBox.getSelectedItem().toString();
            if (!selectedItem.equals("")) {
                spectrum.setSymbolSize(Integer.parseInt(selectedItem));
            }
        });
        this.spectraPanel.add(shapeSizeComboBox);
    }

    private void toggleCollapsed(int index) {
        boolean isCollapsed;
        this.collapsed[index] = isCollapsed = !this.collapsed[index];
        int rowIndex = index * 2 + 2;
        if (isCollapsed) {
            this.spectraPanelLayout.setRowFill(rowIndex, TableLayout.Fill.HORIZONTAL);
            this.spectraPanelLayout.setRowWeightY(rowIndex, Double.valueOf(0.0));
            this.bandTablePanels[index].removeAll();
        } else {
            this.spectraPanelLayout.setRowFill(rowIndex, TableLayout.Fill.BOTH);
            this.spectraPanelLayout.setRowWeightY(rowIndex, Double.valueOf(1.0));
            this.bandTablePanels[index].add((Component)this.bandTables[index].getTableHeader(), "North");
            this.bandTablePanels[index].add((Component)this.bandTables[index], "Center");
        }
        this.bandTablePanels[index].updateUI();
        this.spectraPanel.updateUI();
    }

    private JTable createBandsTable(int index) {
        DisplayableSpectrum spectrum = this.spectra[index];
        Band[] spectralBands = spectrum.getSpectralBands();
        Object[][] spectrumData = new Object[spectralBands.length][this.band_columns.length];
        for (int i = 0; i < spectralBands.length; ++i) {
            Band spectralBand = spectralBands[i];
            boolean selected = spectrum.isBandSelected(i) && spectrum.isSelected();
            spectrumData[i][0] = selected;
            spectrumData[i][1] = spectralBand.getName();
            spectrumData[i][2] = spectralBand.getDescription();
            spectrumData[i][3] = Float.valueOf(spectralBand.getSpectralWavelength());
            spectrumData[i][4] = Float.valueOf(spectralBand.getSpectralBandwidth());
            spectrumData[i][5] = spectralBand.getUnit();
        }
        BandTableModel bandTableModel = new BandTableModel(spectrumData, this.band_columns);
        bandTableModel.addTableModelListener(e -> {
            e.getSource();
            if (e.getColumn() == 0) {
                DisplayableSpectrum spectrum1 = this.spectra[index];
                int bandRow = e.getFirstRow();
                Boolean selected = (Boolean)bandTableModel.getValueAt(bandRow, e.getColumn());
                spectrum1.setBandSelected(bandRow, selected);
                if (!selectionChangeLock) {
                    selectionChangeLock = true;
                    selectionAdmin.setBandSelected(index, bandRow, selected);
                    selectionAdmin.updateSpectrumSelectionState(index, selectionAdmin.getState(index));
                    this.tristateCheckBoxes[index].setState(selectionAdmin.getState(index));
                    spectrum1.setSelected(selectionAdmin.isSpectrumSelected(index));
                    selectionChangeLock = false;
                }
            }
        });
        JTable bandsTable = new JTable(bandTableModel);
        bandsTable.setRowSorter(new TableRowSorter<BandTableModel>(bandTableModel));
        TableColumn selectionColumn = bandsTable.getColumnModel().getColumn(0);
        JCheckBox selectionCheckBox = new JCheckBox();
        selectionColumn.setCellEditor(new DefaultCellEditor(selectionCheckBox));
        selectionColumn.setMinWidth(20);
        selectionColumn.setMaxWidth(20);
        BooleanRenderer booleanRenderer = new BooleanRenderer();
        selectionColumn.setCellRenderer(booleanRenderer);
        TableColumn wavelengthColumn = bandsTable.getColumnModel().getColumn(3);
        wavelengthColumn.setCellRenderer(new DecimalTableCellRenderer(new DecimalFormat("###0.0##")));
        TableColumn bandwidthColumn = bandsTable.getColumnModel().getColumn(4);
        bandwidthColumn.setCellRenderer(new DecimalTableCellRenderer(new DecimalFormat("###0.0##")));
        return bandsTable;
    }

    private void updateBandsTable(int index) {
        TableModel tableModel = this.bandTables[index].getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            tableModel.setValueAt(selectionAdmin.isBandSelected(index, i), i, 0);
        }
    }

    public DisplayableSpectrum[] getSpectra() {
        return this.originalSpectra;
    }

    @Override
    public void setReadRasterDataNodeNames(String[] readRasterDataNodeNames) {
        for (JTable bandTable : this.bandTables) {
            BandTableModel bandTableModel = (BandTableModel)bandTable.getModel();
            for (int j = 0; j < bandTableModel.getRowCount(); ++j) {
                String bandName = bandTableModel.getValueAt(j, 1).toString();
                boolean selected = ArrayUtils.isMemberOf((Object)bandName, (Object[])readRasterDataNodeNames);
                bandTableModel.setValueAt(selected, j, 0);
            }
        }
    }

    @Override
    public String[] getRasterDataNodeNamesToWrite() {
        ArrayList<String> bandNames = new ArrayList<String>();
        for (JTable bandTable : this.bandTables) {
            BandTableModel bandTableModel = (BandTableModel)bandTable.getModel();
            for (int j = 0; j < bandTableModel.getRowCount(); ++j) {
                if (!((Boolean)bandTableModel.getValueAt(j, 0)).booleanValue()) continue;
                bandNames.add(bandTableModel.getValueAt(j, 1).toString());
            }
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private class TristateCheckboxListener
    implements ActionListener {
        private final int index;

        TristateCheckboxListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!selectionChangeLock) {
                selectionChangeLock = true;
                selectionAdmin.updateSpectrumSelectionState(this.index, SpectrumChooser.this.tristateCheckBoxes[this.index].getState());
                SpectrumChooser.this.tristateCheckBoxes[this.index].setState(selectionAdmin.getState(this.index));
                SpectrumChooser.this.updateBandsTable(this.index);
                SpectrumChooser.this.spectra[this.index].setSelected(selectionAdmin.isSpectrumSelected(this.index));
                selectionChangeLock = false;
            }
        }
    }

    private class CollapseListener
    implements ActionListener {
        private final int index;

        CollapseListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof AbstractButton) {
                AbstractButton collapseButton = (AbstractButton)source;
                SpectrumChooser.this.toggleCollapsed(this.index);
                if (SpectrumChooser.this.collapsed[this.index]) {
                    collapseButton.setIcon(icons[0]);
                    collapseButton.setRolloverIcon(roll_over_icons[0]);
                } else {
                    collapseButton.setIcon(icons[1]);
                    collapseButton.setRolloverIcon(roll_over_icons[1]);
                }
            }
        }
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private BooleanRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            boolean selected = (Boolean)value;
            this.setSelected(selected);
            return this;
        }
    }

    private static class BandTableModel
    extends DefaultTableModel {
        private BandTableModel(Object[][] spectrumData, String[] bandColumns) {
            super(spectrumData, bandColumns);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }
    }
}

