/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.metadata;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.ui.product.metadata.MetadataElementInnerNode;
import org.esa.snap.ui.product.metadata.MetadataTableElement;
import org.esa.snap.ui.product.metadata.MetadataTableLeaf;
import org.openide.nodes.AbstractNode;

public class MetadataTableInnerElement
implements MetadataTableElement {
    private final MetadataElement metadataElement;
    private final MetadataTableElement[] metadataTableElements;

    public MetadataTableInnerElement(MetadataElement metadataElement) {
        this.metadataElement = metadataElement;
        this.metadataTableElements = MetadataTableInnerElement.getChildrenElementsFromElement(metadataElement);
    }

    @Override
    public MetadataTableElement[] getMetadataTableElements() {
        return this.metadataTableElements;
    }

    @Override
    public String getName() {
        return this.metadataElement.getName();
    }

    @Override
    public AbstractNode createNode() {
        return new MetadataElementInnerNode(this);
    }

    private static MetadataTableElement[] getChildrenElementsFromElement(MetadataElement metadataElement) {
        MetadataElement[] elements = metadataElement.getElements();
        MetadataAttribute[] attributes = metadataElement.getAttributes();
        ArrayList<MetadataTableElement> metadataTableElementList = new ArrayList<MetadataTableElement>();
        for (MetadataElement metadataElement2 : elements) {
            metadataTableElementList.add(new MetadataTableInnerElement(metadataElement2));
        }
        for (MetadataElement metadataElement3 : attributes) {
            long dataElemSize = metadataElement3.getNumDataElems();
            if (dataElemSize > 1L) {
                int dataType = metadataElement3.getDataType();
                ProductData data = metadataElement3.getData();
                if ((ProductData.isFloatingPointType((int)dataType) || ProductData.isIntType((int)dataType)) && !(data instanceof ProductData.UTC)) {
                    MetadataTableInnerElement.addMetadataAttributes((MetadataAttribute)metadataElement3, data, metadataTableElementList);
                    continue;
                }
                metadataTableElementList.add(new MetadataTableLeaf((MetadataAttribute)metadataElement3));
                continue;
            }
            metadataTableElementList.add(new MetadataTableLeaf((MetadataAttribute)metadataElement3));
        }
        return metadataTableElementList.toArray(new MetadataTableElement[metadataTableElementList.size()]);
    }

    private static void addMetadataAttributes(MetadataAttribute attribute, ProductData data, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        int dataType = attribute.getDataType();
        String unit = attribute.getUnit();
        String description = attribute.getDescription();
        for (int j = 0; j < data.getNumElems(); ++j) {
            MetadataAttribute partAttribute = new MetadataAttribute(name + "." + (j + 1), dataType);
            try {
                partAttribute.setDataElems(MetadataTableInnerElement.getDataElemArray(data, j));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            partAttribute.setUnit(unit);
            partAttribute.setDescription(description);
            metadataTableElementList.add(new MetadataTableLeaf(partAttribute));
        }
    }

    private static Object getDataElemArray(ProductData data, int index) {
        switch (data.getType()) {
            case 10: {
                return new byte[]{(byte)data.getElemIntAt(index)};
            }
            case 11: {
                return new short[]{(short)data.getElemIntAt(index)};
            }
            case 12: {
                return new int[]{data.getElemIntAt(index)};
            }
            case 20: {
                return new byte[]{(byte)data.getElemUIntAt(index)};
            }
            case 21: {
                return new short[]{(short)data.getElemUIntAt(index)};
            }
            case 22: {
                return new int[]{(int)data.getElemUIntAt(index)};
            }
            case 13: {
                return new long[]{data.getElemLongAt(index)};
            }
            case 30: {
                return new float[]{data.getElemFloatAt(index)};
            }
            case 31: {
                return new double[]{data.getElemDoubleAt(index)};
            }
        }
        return null;
    }
}

