/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.esa.snap.ui.product.SimpleFeatureFigureFactory;
import org.esa.snap.ui.product.VectorDataLayerType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class VectorDataLayer
extends Layer {
    private static final VectorDataLayerType TYPE = (VectorDataLayerType)LayerTypeRegistry.getLayerType(VectorDataLayerType.class);
    private VectorDataNode vectorDataNode;
    private final SimpleFeatureFigureFactory figureFactory;
    private FigureCollection figureCollection;
    private VectorDataChangeHandler vectorDataChangeHandler;
    private boolean reactingAgainstFigureChange;
    private static int id;

    public VectorDataLayer(LayerContext ctx, VectorDataNode vectorDataNode, SceneTransformProvider provider) {
        this(TYPE, vectorDataNode, provider, TYPE.createLayerConfig(ctx));
        this.getConfiguration().setValue("vectorData", (Object)vectorDataNode.getName());
    }

    protected VectorDataLayer(VectorDataLayerType vectorDataLayerType, VectorDataNode vectorDataNode, SceneTransformProvider provider, PropertySet configuration) {
        super((LayerType)vectorDataLayerType, configuration);
        this.setUniqueId();
        this.vectorDataNode = vectorDataNode;
        this.setName(vectorDataNode.getName());
        this.figureFactory = new SimpleFeatureFigureFactory(vectorDataNode.getFeatureType(), provider);
        this.figureCollection = new DefaultFigureCollection();
        this.updateFigureCollection();
        this.vectorDataChangeHandler = new VectorDataChangeHandler();
        vectorDataNode.getProduct().addProductNodeListener((ProductNodeListener)this.vectorDataChangeHandler);
        this.figureCollection.addChangeListener((FigureChangeListener)new FigureChangeHandler());
    }

    private void setUniqueId() {
        this.setId("org.esa.snap.layers.vectorData" + ++id);
    }

    public VectorDataNode getVectorDataNode() {
        return this.vectorDataNode;
    }

    protected void disposeLayer() {
        Product product = this.vectorDataNode.getProduct();
        if (product != null) {
            product.removeProductNodeListener((ProductNodeListener)this.vectorDataChangeHandler);
        }
        this.vectorDataNode = null;
        super.disposeLayer();
    }

    private void updateFigureCollection() {
        FeatureCollection featureCollection = this.vectorDataNode.getFeatureCollection();
        Figure[] figures = this.figureCollection.getFigures();
        HashMap<SimpleFeature, SimpleFeatureFigure> figureMap = new HashMap<SimpleFeature, SimpleFeatureFigure>();
        for (Figure figure : figures) {
            if (!(figure instanceof SimpleFeatureFigure)) continue;
            SimpleFeatureFigure simpleFeatureFigure = (SimpleFeatureFigure)figure;
            figureMap.put(simpleFeatureFigure.getSimpleFeature(), simpleFeatureFigure);
        }
        FeatureIterator featureIterator = featureCollection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
            SimpleFeatureFigure featureFigure = (SimpleFeatureFigure)figureMap.get(simpleFeature);
            if (featureFigure != null) {
                figureMap.remove(simpleFeature);
                Placemark placemark = this.vectorDataNode.getPlacemarkGroup().getPlacemark(simpleFeature);
                if (placemark != null) {
                    String css = placemark.getStyleCss();
                    FigureStyle normalStyle = DefaultFigureStyle.createFromCss((String)css);
                    FigureStyle selectedStyle = this.getFigureFactory().deriveSelectedStyle(normalStyle);
                    featureFigure.setNormalStyle(normalStyle);
                    featureFigure.setSelectedStyle(selectedStyle);
                }
            } else {
                featureFigure = this.getFigureFactory().createSimpleFeatureFigure(simpleFeature, this.vectorDataNode.getDefaultStyleCss());
                this.figureCollection.addFigure((Figure)featureFigure);
            }
            featureFigure.forceRegeneration();
        }
        Collection remainingFigures = figureMap.values();
        this.figureCollection.removeFigures(remainingFigures.toArray(new Figure[remainingFigures.size()]));
    }

    private void setLayerStyle(String styleCss) {
        Debug.trace((String)("VectorDataLayer.setLayerStyle: styleCss = " + styleCss));
    }

    public SimpleFeatureFigureFactory getFigureFactory() {
        return this.figureFactory;
    }

    public FigureCollection getFigureCollection() {
        return this.figureCollection;
    }

    protected Rectangle2D getLayerModelBounds() {
        if (this.figureCollection.getFigureCount() == 0) {
            return null;
        }
        return this.figureCollection.getBounds();
    }

    protected void renderLayer(Rendering rendering) {
        this.figureCollection.draw(rendering);
    }

    private class FigureChangeHandler
    implements FigureChangeListener {
        private FigureChangeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void figureChanged(FigureChangeEvent event) {
            Figure sourceFigure = event.getSourceFigure();
            if (sourceFigure instanceof SimpleFeatureFigure) {
                SimpleFeatureFigure featureFigure = (SimpleFeatureFigure)sourceFigure;
                try {
                    VectorDataNode vectorDataNode = VectorDataLayer.this.getVectorDataNode();
                    SimpleFeature simpleFeature = featureFigure.getSimpleFeature();
                    Debug.trace((String)("VectorDataLayer$FigureChangeHandler: vectorDataNode=" + vectorDataNode.getName() + ", featureType=" + simpleFeature.getFeatureType().getTypeName()));
                    VectorDataLayer.this.reactingAgainstFigureChange = true;
                    vectorDataNode.fireFeaturesChanged(new SimpleFeature[]{simpleFeature});
                    VectorDataLayer.this.fireLayerDataChanged(null);
                }
                finally {
                    VectorDataLayer.this.reactingAgainstFigureChange = false;
                }
            }
        }
    }

    private class VectorDataChangeHandler
    extends ProductNodeListenerAdapter {
        private VectorDataChangeHandler() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            if (event.getSourceNode() == VectorDataLayer.this.getVectorDataNode()) {
                Debug.trace((String)("VectorDataLayer$VectorDataChangeHandler.nodeChanged: event = " + event));
                if ("name".equals(event.getPropertyName())) {
                    VectorDataLayer.this.setName(VectorDataLayer.this.getVectorDataNode().getName());
                } else if ("styleCss".equals(event.getPropertyName())) {
                    if (event.getNewValue() != null) {
                        VectorDataLayer.this.setLayerStyle(event.getNewValue().toString());
                    }
                } else if ("featureCollection".equals(event.getPropertyName()) && !VectorDataLayer.this.reactingAgainstFigureChange) {
                    VectorDataLayer.this.updateFigureCollection();
                    VectorDataLayer.this.fireLayerDataChanged(null);
                }
            } else if (event.getSourceNode() instanceof Placemark) {
                Placemark sourceNode = (Placemark)event.getSourceNode();
                if (VectorDataLayer.this.getVectorDataNode().getPlacemarkGroup().contains((ProductNode)sourceNode)) {
                    if (event.getPropertyName().equals("style_css")) {
                        VectorDataLayer.this.updateFigureCollection();
                    } else if (event.getPropertyName().equals("geometry")) {
                        VectorDataLayer.this.updateFigureCollection();
                    } else if (event.getPropertyName().equals("geoPos")) {
                        VectorDataLayer.this.updateFigureCollection();
                    } else if (event.getPropertyName().equals("pixelPos")) {
                        VectorDataLayer.this.updateFigureCollection();
                    }
                }
            }
        }
    }
}

