/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.ValidationException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.util.Debug;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.InputListModel;
import org.esa.snap.ui.product.ProductChooser;

class AddProductAction
extends AbstractAction {
    private final AppContext appContext;
    private final InputListModel listModel;
    private ProductFilter productFilter;

    AddProductAction(AppContext appContext, InputListModel listModel) {
        super("Add product(s)...");
        this.appContext = appContext;
        this.listModel = listModel;
        this.productFilter = product -> true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProductChooser productChooser = new ProductChooser(this.appContext.getApplicationWindow(), "Add product", 33, null, this.filterProducts());
        if (productChooser.show() != 1) {
            return;
        }
        try {
            if (productChooser.getSelectedProducts().size() > 0) {
                this.listModel.addElements(productChooser.getSelectedProducts().toArray());
            }
        }
        catch (ValidationException ve) {
            Debug.trace((Throwable)ve);
        }
    }

    private Product[] filterProducts() {
        List<Product> currentlyOpenedProducts = Arrays.asList(this.listModel.getSourceProducts());
        List<Product> productManagerProducts = Arrays.asList(this.appContext.getProductManager().getProducts());
        ArrayList<Product> result = new ArrayList<Product>();
        for (Product product : productManagerProducts) {
            if (currentlyOpenedProducts.contains(product) || !this.productFilter.accept(product)) continue;
            result.add(product);
        }
        return result.toArray(new Product[result.size()]);
    }

    public void setProductFilter(ProductFilter productFilter) {
        this.productFilter = productFilter;
    }
}

