/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.ui.PopupMenuFactory;
import org.esa.snap.ui.UIUtils;

public class PopupMenuHandler
implements MouseListener,
KeyListener {
    private PopupMenuFactory popupMenuFactory;

    public PopupMenuHandler(PopupMenuFactory popupMenuFactory) {
        Guardian.assertNotNull((String)"popupMenuFactory", (Object)popupMenuFactory);
        this.popupMenuFactory = popupMenuFactory;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    private void maybeShowPopupMenu(MouseEvent event) {
        if (event.isPopupTrigger() && event.getComponent().isVisible()) {
            this.showPopupMenu(event);
        }
    }

    private void showPopupMenu(MouseEvent event) {
        JPopupMenu popupMenu = this.popupMenuFactory.createPopupMenu(event.getComponent());
        if (popupMenu == null) {
            popupMenu = this.popupMenuFactory.createPopupMenu(event);
        }
        if (popupMenu != null) {
            this.rearrangeMenuItems(popupMenu);
            UIUtils.showPopup(popupMenu, event);
        }
    }

    private void rearrangeMenuItems(JPopupMenu popupMenu) {
        Component[] components = popupMenu.getComponents();
        Arrays.sort(components, (o1, o2) -> this.getGroupName((Component)o1).compareToIgnoreCase(this.getGroupName((Component)o2)));
        popupMenu.removeAll();
        Component lastComponent = null;
        String lastGroupName = null;
        for (Component component : components) {
            String groupName = this.getGroupName(component);
            if (lastGroupName != null && !lastGroupName.equals(groupName) && !(lastComponent instanceof JSeparator)) {
                popupMenu.addSeparator();
            }
            lastGroupName = groupName;
            lastComponent = component;
            if (component instanceof JMenuItem) {
                popupMenu.add((JMenuItem)component);
                continue;
            }
            if (component instanceof Action) {
                popupMenu.add((Action)((Object)component));
                continue;
            }
            popupMenu.add(component);
        }
    }

    private String getGroupName(Component component) {
        Object parent;
        Action action = null;
        if (component instanceof AbstractButton) {
            action = ((AbstractButton)component).getAction();
        } else if (component instanceof Action) {
            action = (Action)((Object)component);
        }
        if (action != null && (parent = action.getValue("parent")) != null) {
            return parent.toString();
        }
        return "";
    }
}

