/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.spectrum;

import junit.framework.TestCase;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.ui.product.spectrum.DisplayableSpectrum;
import org.esa.beam.framework.ui.product.spectrum.SpectrumBand;
import org.esa.beam.framework.ui.product.spectrum.SpectrumShapeProvider;

public class DisplayableSpectrumTest
extends TestCase {
    public void testNewDisplayableSpectrumIsSetupCorrectly() {
        String spectrumName = "name";
        DisplayableSpectrum displayableSpectrum = new DisplayableSpectrum(spectrumName, 1);
        DisplayableSpectrumTest.assertEquals((String)spectrumName, (String)displayableSpectrum.getName());
        DisplayableSpectrumTest.assertEquals((String)"", (String)displayableSpectrum.getUnit());
        DisplayableSpectrumTest.assertEquals(null, (Object)displayableSpectrum.getLineStyle());
        DisplayableSpectrumTest.assertEquals((int)3, (int)displayableSpectrum.getSymbolSize());
        DisplayableSpectrumTest.assertEquals((Object)SpectrumShapeProvider.getScaledShape((int)1, (int)3), (Object)displayableSpectrum.getScaledShape());
        DisplayableSpectrumTest.assertEquals((int)1, (int)displayableSpectrum.getSymbolIndex());
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.isSelected());
        DisplayableSpectrumTest.assertEquals((boolean)false, (boolean)displayableSpectrum.isRemainingBandsSpectrum());
        DisplayableSpectrumTest.assertEquals((boolean)false, (boolean)displayableSpectrum.hasBands());
        DisplayableSpectrumTest.assertEquals((int)0, (int)displayableSpectrum.getSpectralBands().length);
        DisplayableSpectrumTest.assertEquals((int)0, (int)displayableSpectrum.getSelectedBands().length);
    }

    public void testNewDisplayableSpectrumIsSetUpCorrectlyWithBands() {
        String spectrumName = "name";
        SpectrumBand[] spectralBands = new SpectrumBand[2];
        for (int i = 0; i < spectralBands.length; ++i) {
            Band band = this.createBand(i);
            band.setUnit("unit");
            spectralBands[i] = new SpectrumBand(band, true);
        }
        DisplayableSpectrum displayableSpectrum = new DisplayableSpectrum(spectrumName, spectralBands, 1);
        DisplayableSpectrumTest.assertEquals((String)spectrumName, (String)displayableSpectrum.getName());
        DisplayableSpectrumTest.assertEquals((String)"unit", (String)displayableSpectrum.getUnit());
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.hasBands());
        DisplayableSpectrumTest.assertEquals((int)2, (int)displayableSpectrum.getSpectralBands().length);
        DisplayableSpectrumTest.assertEquals((int)2, (int)displayableSpectrum.getSelectedBands().length);
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.isBandSelected(0));
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.isBandSelected(1));
    }

    public void testBandsAreAddedCorrectlyToDisplayableSpectrum() {
        String spectrumName = "name";
        DisplayableSpectrum displayableSpectrum = new DisplayableSpectrum(spectrumName, 1);
        SpectrumBand[] bands = new SpectrumBand[3];
        for (int i = 0; i < bands.length; ++i) {
            Band band = this.createBand(i);
            band.setUnit("unit" + i);
            bands[i] = new SpectrumBand(band, i % 2 == 0);
            displayableSpectrum.addBand(bands[i]);
        }
        DisplayableSpectrumTest.assertEquals((String)spectrumName, (String)displayableSpectrum.getName());
        DisplayableSpectrumTest.assertEquals((String)"mixed units", (String)displayableSpectrum.getUnit());
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.hasBands());
        DisplayableSpectrumTest.assertEquals((int)3, (int)displayableSpectrum.getSpectralBands().length);
        DisplayableSpectrumTest.assertEquals((Object)bands[0].getOriginalBand(), (Object)displayableSpectrum.getSpectralBands()[0]);
        DisplayableSpectrumTest.assertEquals((Object)bands[1].getOriginalBand(), (Object)displayableSpectrum.getSpectralBands()[1]);
        DisplayableSpectrumTest.assertEquals((Object)bands[2].getOriginalBand(), (Object)displayableSpectrum.getSpectralBands()[2]);
        DisplayableSpectrumTest.assertEquals((int)2, (int)displayableSpectrum.getSelectedBands().length);
        DisplayableSpectrumTest.assertEquals((Object)bands[0].getOriginalBand(), (Object)displayableSpectrum.getSpectralBands()[0]);
        DisplayableSpectrumTest.assertEquals((Object)bands[2].getOriginalBand(), (Object)displayableSpectrum.getSpectralBands()[2]);
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.isBandSelected(0));
        DisplayableSpectrumTest.assertEquals((boolean)false, (boolean)displayableSpectrum.isBandSelected(1));
        DisplayableSpectrumTest.assertEquals((boolean)true, (boolean)displayableSpectrum.isBandSelected(2));
    }

    private Band createBand(int number) {
        return new Band("name" + number, 10, 1, 1);
    }
}

