/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.layer;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import org.esa.beam.framework.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.beam.framework.ui.layer.DefaultLayerSourceDescriptor;
import org.esa.beam.framework.ui.layer.LayerSource;
import org.esa.beam.framework.ui.layer.LayerSourcePageContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultLayerSourceDescriptorTest {
    private static SimpleTestLayerType layerType = new SimpleTestLayerType();

    @BeforeClass
    public static void setUp() {
        ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
        ServiceRegistry registry = serviceRegistryManager.getServiceRegistry(LayerType.class);
        registry.addService((Object)layerType);
    }

    @AfterClass
    public static void tearDown() {
        ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
        ServiceRegistry registry = serviceRegistryManager.getServiceRegistry(LayerType.class);
        registry.removeService((Object)layerType);
    }

    @Test
    public void testWithLayerSource() {
        String id = "wms-layer-source";
        String name = "Image from Web Mapping Server (WMS)";
        String description = "Retrieves images from a Web Mapping Server (WMS)";
        DefaultLayerSourceDescriptor descriptor = new DefaultLayerSourceDescriptor("wms-layer-source", "Image from Web Mapping Server (WMS)", "Retrieves images from a Web Mapping Server (WMS)", DummyLayerSource.class);
        Assert.assertEquals((Object)"wms-layer-source", (Object)descriptor.getId());
        Assert.assertEquals((Object)"Image from Web Mapping Server (WMS)", (Object)descriptor.getName());
        Assert.assertEquals((Object)"Retrieves images from a Web Mapping Server (WMS)", (Object)descriptor.getDescription());
        Assert.assertNull((Object)descriptor.getLayerType());
        LayerSource layerSource = descriptor.createLayerSource();
        Assert.assertNotNull((Object)layerSource);
        Assert.assertTrue((boolean)(layerSource instanceof DummyLayerSource));
    }

    @Test
    public void testWithLayerType() {
        String id = "type-layer-source";
        String name = "Some simple layer";
        String description = "A simple layer without configuration.";
        DefaultLayerSourceDescriptor descriptor = new DefaultLayerSourceDescriptor("type-layer-source", "Some simple layer", "A simple layer without configuration.", SimpleTestLayerType.class.getName());
        Assert.assertEquals((Object)"type-layer-source", (Object)descriptor.getId());
        Assert.assertEquals((Object)"Some simple layer", (Object)descriptor.getName());
        Assert.assertEquals((Object)"A simple layer without configuration.", (Object)descriptor.getDescription());
        Assert.assertNotNull((Object)descriptor.getLayerType());
        Assert.assertNotNull((Object)(descriptor.getLayerType() instanceof SimpleTestLayerType));
        LayerSource layerSource = descriptor.createLayerSource();
        Assert.assertNotNull((Object)layerSource);
    }

    private static class DummyLayerSource
    implements LayerSource {
        public boolean isApplicable(LayerSourcePageContext pageContext) {
            return false;
        }

        public boolean hasFirstPage() {
            return false;
        }

        public AbstractLayerSourceAssistantPage getFirstPage(LayerSourcePageContext pageContext) {
            return null;
        }

        public boolean canFinish(LayerSourcePageContext pageContext) {
            return false;
        }

        public boolean performFinish(LayerSourcePageContext pageContext) {
            return false;
        }

        public void cancel(LayerSourcePageContext pageContext) {
        }
    }

    @LayerTypeMetadata(name="SimpleTestLayerType")
    private static class SimpleTestLayerType
    extends LayerType {
        private SimpleTestLayerType() {
        }

        public boolean isValidFor(LayerContext ctx) {
            return true;
        }

        public Layer createLayer(LayerContext ctx, PropertySet configuration) {
            return new CollectionLayer();
        }

        public PropertySet createLayerConfig(LayerContext ctx) {
            return new PropertyContainer();
        }
    }
}

