/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.DefaultCommandMenuInserter;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.junit.Assert;
import org.junit.Test;

public class DefaultCommandMenuInserterTest {
    @Test
    public void testSortByAnchor_FirstOnly_3() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("c", Anchor.FIRST));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_LastOnly_3() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.LAST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.LAST), DefaultCommandMenuInserterTest.createCommand("c", Anchor.LAST));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_FirstAndLast_6() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("c", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("d", Anchor.LAST), DefaultCommandMenuInserterTest.createCommand("e", Anchor.LAST), DefaultCommandMenuInserterTest.createCommand("f", Anchor.LAST));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"d", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"e", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"f", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_FirstAndLast_2() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.LAST));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_BeforeAndLast_2() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.BEFORE, "b"), DefaultCommandMenuInserterTest.createCommand("b", Anchor.LAST, null));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_BeforeAndLast_3() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.BEFORE, "c"), DefaultCommandMenuInserterTest.createCommand("b", Anchor.BEFORE, "c"), DefaultCommandMenuInserterTest.createCommand("c", Anchor.LAST));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_FirstAndAfter_3() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.AFTER, "a"), DefaultCommandMenuInserterTest.createCommand("c", Anchor.AFTER, "a"));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_NoneAndAfter_2() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a"), DefaultCommandMenuInserterTest.createCommand("b", Anchor.AFTER, "a"));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_NoneAndAfter_3() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a"), DefaultCommandMenuInserterTest.createCommand("b", Anchor.AFTER, "a"), DefaultCommandMenuInserterTest.createCommand("c", Anchor.AFTER, "b"));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_NoneAndAfter_5() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a"), DefaultCommandMenuInserterTest.createCommand("b", Anchor.AFTER, "a"), DefaultCommandMenuInserterTest.createCommand("c", Anchor.AFTER, "b"), DefaultCommandMenuInserterTest.createCommand("d", Anchor.AFTER, "c"), DefaultCommandMenuInserterTest.createCommand("e", Anchor.AFTER, "d"));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"d", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"e", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_AllKinds_4() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.AFTER, "a"), DefaultCommandMenuInserterTest.createCommand("c", Anchor.BEFORE, "d"), DefaultCommandMenuInserterTest.createCommand("d", Anchor.LAST, null));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"d", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByAnchor_AllKinds_12() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("b", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("c", Anchor.FIRST), DefaultCommandMenuInserterTest.createCommand("d", Anchor.AFTER, "c"), DefaultCommandMenuInserterTest.createCommand("e", Anchor.AFTER, "c"), DefaultCommandMenuInserterTest.createCommand("f", Anchor.AFTER, "c"), DefaultCommandMenuInserterTest.createCommand("g", Anchor.BEFORE, "j"), DefaultCommandMenuInserterTest.createCommand("h", Anchor.BEFORE, "j"), DefaultCommandMenuInserterTest.createCommand("i", Anchor.BEFORE, "j"), DefaultCommandMenuInserterTest.createCommand("j", Anchor.LAST), DefaultCommandMenuInserterTest.createCommand("k", Anchor.LAST), DefaultCommandMenuInserterTest.createCommand("l", Anchor.LAST));
        DefaultCommandMenuInserterTest.reverseList(commands);
        DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        int index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"d", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"e", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"f", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"g", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"h", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"i", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"j", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"k", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"l", (Object)commands.get(index++).getCommandID());
    }

    @Test
    public void testSortByName() {
        List<Command> commands = DefaultCommandMenuInserterTest.toList(DefaultCommandMenuInserterTest.createCommand("a"), DefaultCommandMenuInserterTest.createCommand("b"), DefaultCommandMenuInserterTest.createCommand("c"), DefaultCommandMenuInserterTest.createCommand("d"));
        DefaultCommandMenuInserterTest.reverseList(commands);
        int index = 0;
        Assert.assertEquals((Object)"d", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        DefaultCommandMenuInserter.sortCommandsByName(commands);
        index = 0;
        Assert.assertEquals((Object)"a", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"b", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"c", (Object)commands.get(index++).getCommandID());
        Assert.assertEquals((Object)"d", (Object)commands.get(index++).getCommandID());
    }

    private static void reverseList(List<Command> commands) {
        for (int i1 = 0; i1 < commands.size() / 2; ++i1) {
            int i2 = commands.size() - i1 - 1;
            Command command1 = commands.get(i1);
            Command command2 = commands.get(i2);
            commands.set(i1, command2);
            commands.set(i2, command1);
        }
    }

    static List<Command> toList(Command ... commands) {
        return new ArrayList<Command>(Arrays.asList(commands));
    }

    static Command createCommand(String name) {
        return DefaultCommandMenuInserterTest.createCommand(name, null, null);
    }

    static Command createCommand(String name, Anchor anchor) {
        return DefaultCommandMenuInserterTest.createCommand(name, anchor, null);
    }

    static Command createCommand(String name, Anchor anchor, String relativeId) {
        ExecCommand command = new ExecCommand(name);
        command.setText(name);
        if (anchor != null) {
            if (anchor == Anchor.FIRST) {
                command.setPlaceFirst(true);
            }
            if (anchor == Anchor.LAST) {
                command.setPlaceLast(true);
            }
            if (anchor == Anchor.BEFORE) {
                command.setPlaceBefore(relativeId);
            }
            if (anchor == Anchor.AFTER) {
                command.setPlaceAfter(relativeId);
            }
        }
        return command;
    }

    public static enum Anchor {
        FIRST,
        LAST,
        BEFORE,
        AFTER;

    }
}

