/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import junit.framework.TestCase;
import org.esa.beam.framework.ui.UserInputHistory;
import org.esa.beam.util.PropertyMap;

public class UserInputHistoryTest
extends TestCase {
    public UserInputHistoryTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testFail() {
        String propertyKey = "test.prop";
        PropertyMap properties = new PropertyMap();
        properties.setPropertyInt("test.prop.length", 4);
        properties.setPropertyString("test.prop.0", "0");
        properties.setPropertyString("test.prop.1", "1");
        properties.setPropertyString("test.prop.2", "2");
        properties.setPropertyString("test.prop.3", "3");
        properties.setPropertyString("test.prop.4", "4");
        UserInputHistory history = new UserInputHistory(9, "test.prop");
        UserInputHistoryTest.assertEquals((int)9, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)0, (int)history.getNumEntries());
        UserInputHistoryTest.assertNull((Object)history.getEntries());
        history.initBy(properties);
        UserInputHistoryTest.assertEquals((int)4, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)4, (int)history.getNumEntries());
        String[] entries = history.getEntries();
        UserInputHistoryTest.assertEquals((int)4, (int)entries.length);
        UserInputHistoryTest.assertEquals((String)"0", (String)entries[0]);
        UserInputHistoryTest.assertEquals((String)"1", (String)entries[1]);
        UserInputHistoryTest.assertEquals((String)"2", (String)entries[2]);
        UserInputHistoryTest.assertEquals((String)"3", (String)entries[3]);
        history.push("4");
        UserInputHistoryTest.assertEquals((int)4, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)4, (int)history.getNumEntries());
        entries = history.getEntries();
        UserInputHistoryTest.assertEquals((int)4, (int)entries.length);
        UserInputHistoryTest.assertEquals((String)"4", (String)entries[0]);
        UserInputHistoryTest.assertEquals((String)"0", (String)entries[1]);
        UserInputHistoryTest.assertEquals((String)"1", (String)entries[2]);
        UserInputHistoryTest.assertEquals((String)"2", (String)entries[3]);
        history.setMaxNumEntries(2);
        UserInputHistoryTest.assertEquals((int)2, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)2, (int)history.getNumEntries());
        entries = history.getEntries();
        UserInputHistoryTest.assertEquals((int)2, (int)entries.length);
        UserInputHistoryTest.assertEquals((String)"4", (String)entries[0]);
        UserInputHistoryTest.assertEquals((String)"0", (String)entries[1]);
        history.copyInto(properties);
        UserInputHistoryTest.assertEquals((String)"4", (String)properties.getPropertyString("test.prop.0"));
        UserInputHistoryTest.assertEquals((String)"0", (String)properties.getPropertyString("test.prop.1"));
        UserInputHistoryTest.assertNull((Object)properties.getPropertyString("test.prop.2", null));
        UserInputHistoryTest.assertNull((Object)properties.getPropertyString("test.prop.3", null));
        UserInputHistoryTest.assertNull((Object)properties.getPropertyString("test.prop.4", null));
    }
}

