/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import org.esa.beam.framework.ui.RegionSelectableWorldMapPane;
import org.junit.Assert;
import org.junit.Test;

public class RegionSelectableWorldMapPane_BoundingValuesValidation {
    private final double validNorthBound = 75.0;
    private final double validEastBound = 30.0;
    private final double validSouthBound = 20.0;
    private final double validWestBound = 10.0;

    @Test
    public void testValidBounds() {
        Assert.assertTrue((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)20.0, (Double)10.0));
    }

    @Test
    public void testThatReturnValueIsFalseIfAllBoundingValuesAreNull() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid(null, null, null, null));
    }

    @Test
    public void testThatEachValueMustBeNotNull() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid(null, (Double)30.0, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, null, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, null, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)20.0, null));
    }

    @Test
    public void testThatNorthValueMustBeBiggerThanSouthValue() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)10.0, (Double)30.0, (Double)10.0, (Double)10.0));
    }

    @Test
    public void testThatEastValueMustBeBiggerThanWestValue() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)10.0, (Double)20.0, (Double)10.0));
    }

    @Test
    public void testThatValuesAreInsideValidBounds() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)91.0, (Double)30.0, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)181.0, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)-91.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)20.0, (Double)-181.0));
    }
}

