/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.interpolators;

import org.esa.snap.interpolators.InterpolatingFunction;
import org.esa.snap.interpolators.LinearInterpolator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinearInterpolatorTest {
    private LinearInterpolator linearInterpolator;

    @Before
    public void setUp() throws Exception {
        this.linearInterpolator = new LinearInterpolator();
    }

    @Test
    public void testInterpolationOfStraightLine() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        InterpolatingFunction function = this.linearInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        this.assertUnknownValuesAreGuessedCorrectly(y, function);
    }

    @Test
    public void testInterpolationOfFunctionWithPositiveAndNegativeSlope() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{1.0, 3.0, 5.0, 3.0, 1.0};
        InterpolatingFunction function = this.linearInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        this.assertUnknownValuesAreGuessedCorrectly(y, function);
    }

    @Test
    public void testInterpolationOfQuadraticFunction() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{Math.pow(0.0, 2.0), Math.pow(2.0, 2.0), Math.pow(4.0, 2.0), Math.pow(6.0, 2.0), Math.pow(8.0, 2.0)};
        InterpolatingFunction function = this.linearInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        this.assertUnknownValuesAreGuessedCorrectly(y, function);
    }

    @Test
    public void testInterpolationOfSinusFunction() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{Math.sin(0.0), Math.sin(2.0), Math.sin(4.0), Math.sin(6.0), Math.sin(8.0)};
        InterpolatingFunction function = this.linearInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        this.assertUnknownValuesAreGuessedCorrectly(y, function);
    }

    @Test
    public void testInterpolationOfRandomValues() {
        double[] x = new double[]{0.0, 4.0, 7.0, 8.0, 10.0, 14.0, 16.0};
        double[] y = new double[]{2.0, 1.0, 8.0, 5.0, 4.0, 1.0, 7.0};
        double[] testValues = new double[]{2.0, 5.5, 7.5, 9.0, 12.0, 15.0};
        InterpolatingFunction function = this.linearInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        this.assertUnknownValuesAreGuessedCorrectly(y, function, testValues);
    }

    private void assertKnownValuesAreAssignedCorrectly(double[] x, double[] y, InterpolatingFunction function) {
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)y[i], (double)function.value(x[i]), (double)1.0E-10);
        }
    }

    private void assertUnknownValuesAreGuessedCorrectly(double[] y, InterpolatingFunction function) {
        double[] testValues = new double[]{1.0, 3.0, 5.0, 7.0};
        this.assertUnknownValuesAreGuessedCorrectly(y, function, testValues);
    }

    private void assertUnknownValuesAreGuessedCorrectly(double[] y, InterpolatingFunction function, double[] testValues) {
        for (int i = 0; i < testValues.length; ++i) {
            double middleBetweenTwoValues = (y[i + 1] + y[i]) / 2.0;
            Assert.assertEquals((double)middleBetweenTwoValues, (double)function.value(testValues[i]), (double)1.0E-10);
        }
    }
}

