/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.statistics.output.UtilTest;
import org.esa.snap.statistics.tools.DatabaseRecord;
import org.esa.snap.statistics.tools.FilenameDateExtractor;
import org.esa.snap.statistics.tools.GeometryID;
import org.esa.snap.statistics.tools.ObservationYear;
import org.esa.snap.statistics.tools.ParameterName;
import org.esa.snap.statistics.tools.StatisticsDatabase;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;

public class StatisticsDatabaseTest {
    private StatisticsDatabase statisticsDatabase;

    @Before
    public void setUp() throws Exception {
        this.statisticsDatabase = new StatisticsDatabase("NAME");
    }

    @Test
    public void testDatabaseWithRealData() throws IOException {
        File shapeFile = new File(this.getClass().getResource("20070504_out_cwbody_desh_gk3.shp").getFile());
        File mappingFile = new File(this.getClass().getResource("20070504_out_cwbody_desh_gk3_band_mapping.txt").getFile());
        FeatureCollection featureCollection = FeatureUtils.loadFeatureCollectionFromShapefile((File)shapeFile);
        Properties mapping = new Properties();
        mapping.load(new FileReader(mappingFile));
        FilenameDateExtractor filenameDateExtractor = new FilenameDateExtractor();
        ProductData.UTC utc = filenameDateExtractor.getDate(shapeFile);
        this.statisticsDatabase.append(utc, featureCollection, mapping);
        ObservationYear year = new ObservationYear(2007);
        Assert.assertArrayEquals((Object[])new ObservationYear[]{year}, (Object[])this.statisticsDatabase.getYears());
        ParameterName algal_1 = new ParameterName("algal_1");
        ParameterName yellow_subs = new ParameterName("yellow_subs");
        Assert.assertArrayEquals((Object[])new ParameterName[]{algal_1, yellow_subs}, (Object[])this.statisticsDatabase.getParameterNames(year));
        DatabaseRecord[] algal_1_records = this.statisticsDatabase.getData(year, new ParameterName("algal_1"));
        Assert.assertEquals((long)21L, (long)algal_1_records.length);
        Assert.assertEquals((Object)new GeometryID("1"), (Object)algal_1_records[0].geomId);
        Assert.assertEquals((Object)"Hever Tidebecken", (Object)algal_1_records[0].geomName);
        Set dataDates = algal_1_records[0].getDataDates();
        Assert.assertEquals((long)1L, (long)dataDates.size());
        Date date = (Date)dataDates.iterator().next();
        Assert.assertEquals((long)9L, (long)algal_1_records[0].getStatDataColumns(date).size());
        Assert.assertArrayEquals((Object[])new String[]{"average", "max_error", "maximum", "median", "minimum", "p90_threshold", "p95_threshold", "sigma", "total"}, (Object[])algal_1_records[0].getStatDataColumns(date).toArray());
        Assert.assertEquals((Object)"14.929766660899315", (Object)algal_1_records[0].getValue(date, "average"));
        Assert.assertEquals((Object)"0.030201509529724717", (Object)algal_1_records[0].getValue(date, "max_error"));
        Assert.assertEquals((Object)"30.221426010131836", (Object)algal_1_records[0].getValue(date, "maximum"));
        Assert.assertEquals((Object)"16.29853011692874", (Object)algal_1_records[0].getValue(date, "median"));
        Assert.assertEquals((Object)"0.019916480407118797", (Object)algal_1_records[0].getValue(date, "minimum"));
        Assert.assertEquals((Object)"24.301930142305793", (Object)algal_1_records[0].getValue(date, "p90_threshold"));
        Assert.assertEquals((Object)"28.077118833521382", (Object)algal_1_records[0].getValue(date, "p95_threshold"));
        Assert.assertEquals((Object)"8.967569722301686", (Object)algal_1_records[0].getValue(date, "sigma"));
        Assert.assertEquals((Object)"76.0", (Object)algal_1_records[0].getValue(date, "total"));
    }

    @Test
    public void testGetGeomName() throws Exception {
        Assert.assertEquals((Object)"theName", (Object)StatisticsDatabase.getGeomName((String)"ColumnName", (SimpleFeature)UtilTest.createFeature("ColumnName", "theName"), (String)"12"));
        Assert.assertEquals((Object)"12", (Object)StatisticsDatabase.getGeomName(null, (SimpleFeature)UtilTest.createFeature("ColumnName", "theName"), (String)"12"));
    }

    @Test
    public void testDatabaseFilledWithDateForDifferentDates() throws Exception {
        ProductData.UTC utc1 = ProductData.UTC.parse((String)"2002-03-02", (String)"yyyy-MM-dd");
        ProductData.UTC utc2 = ProductData.UTC.parse((String)"2002-03-03", (String)"yyyy-MM-dd");
        SimpleFeature feature1 = UtilTest.createFeature("Param1", "Value1");
        SimpleFeature feature2 = UtilTest.createFeature("Param1", "Value2");
        Properties mapping = new Properties();
        mapping.setProperty("Param1", "max_error_Param1_LongName");
        this.statisticsDatabase.append(utc1, (FeatureCollection)this.createCollection(feature1), mapping);
        this.statisticsDatabase.append(utc2, (FeatureCollection)this.createCollection(feature2), mapping);
        Object[] years = this.statisticsDatabase.getYears();
        ObservationYear year = new ObservationYear(2002);
        Assert.assertArrayEquals((Object[])new ObservationYear[]{year}, (Object[])years);
        Object[] parameterNames = this.statisticsDatabase.getParameterNames((ObservationYear)years[0]);
        Assert.assertArrayEquals((Object[])new ParameterName[]{new ParameterName("Param1_LongName")}, (Object[])parameterNames);
        DatabaseRecord[] databaseRecords = this.statisticsDatabase.getData((ObservationYear)years[0], (ParameterName)parameterNames[0]);
        Assert.assertEquals((long)1L, (long)databaseRecords.length);
        Set dataDates = databaseRecords[0].getDataDates();
        Assert.assertEquals((long)2L, (long)dataDates.size());
    }

    private DefaultFeatureCollection createCollection(SimpleFeature feature1) {
        DefaultFeatureCollection fc1 = new DefaultFeatureCollection("id", feature1.getFeatureType());
        fc1.add(feature1);
        return fc1;
    }
}

