/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import com.vividsolutions.jts.geom.Geometry;
import javax.media.jai.Histogram;
import org.esa.snap.statistics.output.Util;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;

public class UtilTest {
    @Test
    public void testGetFeatureName() throws Exception {
        Assert.assertEquals((Object)"myName", (Object)Util.getFeatureName((SimpleFeature)UtilTest.createFeature("name", "myName")));
        Assert.assertEquals((Object)"myOtherName", (Object)Util.getFeatureName((SimpleFeature)UtilTest.createFeature("NAME", "myOtherName")));
        Assert.assertEquals((Object)"someThirdName", (Object)Util.getFeatureName((SimpleFeature)UtilTest.createFeature("NAME", "someThirdName")));
        Assert.assertEquals((Object)"id", (Object)Util.getFeatureName((SimpleFeature)UtilTest.createFeature("noName", "myName")));
    }

    public static SimpleFeature createFeature(String nameAttribute, String nameValue) {
        SimpleFeatureBuilder featureBuilder = UtilTest.createSimpleFeatureBuilder(nameAttribute);
        featureBuilder.set(nameAttribute, (Object)nameValue);
        return featureBuilder.buildFeature("id");
    }

    private static SimpleFeatureBuilder createSimpleFeatureBuilder(String nameAttribute) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.add(nameAttribute, String.class);
        typeBuilder.add("geom", Geometry.class);
        typeBuilder.setName("someFeatureType");
        return new SimpleFeatureBuilder(typeBuilder.buildFeatureType());
    }

    @Test
    public void testGetBinWidth() throws Exception {
        Assert.assertEquals((double)0.01, (double)Util.getBinWidth((Histogram)new Histogram(100, 0.0, 1.0, 1)), (double)1.0E-4);
        Assert.assertEquals((double)0.001, (double)Util.getBinWidth((Histogram)new Histogram(1000, 0.0, 1.0, 1)), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)Util.getBinWidth((Histogram)new Histogram(100, -25.0, 25.0, 1)), (double)1.0E-4);
        Assert.assertEquals((double)0.01, (double)Util.getBinWidth((Histogram)new Histogram(100, -1.0, 0.0, 1)), (double)1.0E-4);
    }

    @Test
    public void testComputeBinCount() throws Exception {
        Assert.assertEquals((long)1000L, (long)Util.computeBinCount((int)3));
        Assert.assertEquals((long)10000L, (long)Util.computeBinCount((int)4));
        Assert.assertEquals((long)1000000L, (long)Util.computeBinCount((int)6));
    }

    @Test
    public void testComputeBinCount_IllegalArgumentCases() {
        this.tryIllegalArgument(7);
        this.tryIllegalArgument(700);
        this.tryIllegalArgument(-1);
    }

    private void tryIllegalArgument(int accuracy) {
        try {
            Util.computeBinCount((int)accuracy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

