/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.output.MetadataWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataWriterTest {
    private ByteArrayOutputStream outputStream;
    private MetadataWriter metadataWriter;

    @Before
    public void setUp() throws Exception {
        this.outputStream = new ByteArrayOutputStream();
        this.metadataWriter = new MetadataWriter(new PrintStream(this.outputStream));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testWriteMetadata() throws ParseException {
        Product[] sourceProducts = new Product[]{new Product("MER_RR__2PBCMsomething", "type", 10, 10)};
        ProductData.UTC startDate = ProductData.UTC.parse((String)"2010-01-01", (String)"yyyy-MM-dd");
        ProductData.UTC endDate = ProductData.UTC.parse((String)"2011-01-01", (String)"yyyy-MM-dd");
        String[] regionIds = new String[]{"bullerbue", "bielefeld"};
        this.metadataWriter.initialiseOutput(StatisticsOutputContext.create((Product[])sourceProducts, null, null, (ProductData.UTC)startDate, (ProductData.UTC)endDate, (String[])regionIds));
        Assert.assertEquals((Object)"# BEAM Statistics export\n#\n# Products:\n#              MER_RR__2PBCMsomething\n#\n# Start Date: 01-JAN-2010 00:00:00.000000\n#\n# End Date: 01-JAN-2011 00:00:00.000000\n#\n# Regions:\n#              bullerbue\n#              bielefeld\n", (Object)this.outputStream.toString());
    }
}

