/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.CsvStatisticsWriterTest;
import org.junit.Assert;
import org.junit.Test;

public class BandNameCreatorTest {
    @Test
    public void testCreateAttributeName() throws Exception {
        final int[] warningCount = new int[1];
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                Assert.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
                Assert.assertTrue((boolean)record.getMessage().contains("exceeds 10 characters in length. Shortened to"));
                warningCount[0] = warningCount[0] + 1;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        Level level = SystemUtils.LOG.getLevel();
        SystemUtils.LOG.setLevel(Level.WARNING);
        SystemUtils.LOG.addHandler(handler);
        BandNameCreator bandNameCreator = new BandNameCreator();
        String attributeName1 = bandNameCreator.createUniqueAttributeName("median", "radiance_12");
        String attributeName2 = bandNameCreator.createUniqueAttributeName("median", "radiance_13");
        String attributeName3 = bandNameCreator.createUniqueAttributeName("p90_threshold", "radiance_12");
        String attributeName4 = bandNameCreator.createUniqueAttributeName("p90_threshold", "radiance_13");
        String attributeName5 = bandNameCreator.createUniqueAttributeName("p90_threshold", "algal2");
        String attributeName6 = bandNameCreator.createUniqueAttributeName("p90_threshold", "algal1");
        String attributeName7 = bandNameCreator.createUniqueAttributeName("maximum", "algal1");
        String attributeName8 = bandNameCreator.createUniqueAttributeName("minimum", "algal1");
        String attributeName9 = bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index");
        String attributeName10 = bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_normalized");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_a");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_b");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_c");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_d");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_e");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_f");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_g");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_h");
        String attributeName11 = bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_xyz");
        Assert.assertEquals((Object)"mdn_rdnc12", (Object)attributeName1);
        Assert.assertEquals((Object)"mdn_rdnc13", (Object)attributeName2);
        Assert.assertEquals((Object)"p90_thrs_0", (Object)attributeName3);
        Assert.assertEquals((Object)"p90_thrs_1", (Object)attributeName4);
        Assert.assertEquals((Object)"p90_thrs_2", (Object)attributeName5);
        Assert.assertEquals((Object)"p90_thrs_3", (Object)attributeName6);
        Assert.assertEquals((Object)"mx_lgl1", (Object)attributeName7);
        Assert.assertEquals((Object)"mn_lgl1", (Object)attributeName8);
        Assert.assertEquals((Object)"mdn_0", (Object)attributeName9);
        Assert.assertEquals((Object)"mdn_1", (Object)attributeName10);
        Assert.assertEquals((Object)"mdn_10", (Object)attributeName11);
        Assert.assertEquals((long)19L, (long)warningCount[0]);
        SystemUtils.LOG.removeHandler(handler);
        SystemUtils.LOG.setLevel(level);
    }

    @Test
    public void testMapping() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        PrintStream stream = new PrintStream(new CsvStatisticsWriterTest.StringOutputStream(stringBuilder));
        BandNameCreator bandNameCreator = new BandNameCreator(stream);
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_a");
        bandNameCreator.createUniqueAttributeName("median", "saharan_dust_index_b");
        bandNameCreator.createUniqueAttributeName("maximum", "far_too_long_band_name");
        bandNameCreator.createUniqueAttributeName("minimum", "far_too_long_band_name");
        bandNameCreator.createUniqueAttributeName("total", "CHL");
        Assert.assertEquals((Object)"mdn_0=median_saharan_dust_index_a\nmdn_1=median_saharan_dust_index_b\nmx_0=maximum_far_too_long_band_name\nmn_0=minimum_far_too_long_band_name\ntotal_CHL=total_CHL\n", (Object)stringBuilder.toString());
    }
}

