/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs.components;

import java.util.function.Function;
import java.util.function.Predicate;

public class FieldChangeTrigger<S, T>
implements Function<S, T> {
    private String targetFieldName;
    private Predicate<S> condition;
    private Function<S, T> action;

    public static <K, V> FieldChangeTrigger<K, V> create(String fieldName, Function<K, V> action) {
        return FieldChangeTrigger.create(fieldName, action, null);
    }

    public static <K, V> FieldChangeTrigger<K, V> create(String fieldName, Function<K, V> action, Predicate<K> condition) {
        return new FieldChangeTrigger<K, V>(fieldName, action, condition);
    }

    private FieldChangeTrigger(String fieldName, Function<S, T> action, Predicate<S> condition) {
        this.targetFieldName = fieldName;
        this.action = action;
        this.condition = condition;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public boolean canApply(S input) {
        return this.condition == null || this.condition.test(input);
    }

    @Override
    public T apply(S input) {
        return this.canApply(input) ? (this.action != null ? this.action.apply(input) : null) : null;
    }
}

