/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.validators;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.validators.NotEmptyValidator;
import javax.swing.JLabel;
import org.esa.snap.tango.TangoIcons;

public class DecoratedNotEmptyValidator
implements Validator {
    private String[] excludedChars;
    private JLabel label;
    private NotEmptyValidator validator = new NotEmptyValidator();

    public DecoratedNotEmptyValidator(JLabel componentLabel, String[] excludedChars) {
        this.label = componentLabel;
        this.excludedChars = excludedChars;
        this.label.setText("<html><font color=\"#" + Integer.toHexString(this.label.getForeground().getRGB()).substring(2, 8) + "\">" + this.label.getText() + "</font><font color=\"RED\">*</font></html>");
    }

    public void validateValue(Property property, Object value) throws ValidationException {
        try {
            if (value != null) {
                String stringValue = value.toString();
                if (this.excludedChars != null) {
                    for (String exclChar : this.excludedChars) {
                        if (!stringValue.contains(exclChar)) continue;
                        throw new ValidationException(String.format("Character '%s' not allowed", exclChar));
                    }
                }
            }
            this.validator.validateValue(property, value);
            this.label.setIcon(null);
            this.label.setToolTipText(null);
        }
        catch (ValidationException vex) {
            this.label.setIcon(TangoIcons.status_dialog_error((TangoIcons.Res)TangoIcons.Res.R16));
            throw vex;
        }
    }
}

