/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.esa.snap.core.gpf.descriptor.OSFamily;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.dependency.Bundle;
import org.esa.snap.core.gpf.descriptor.dependency.BundleLocation;
import org.esa.snap.core.gpf.descriptor.dependency.BundleType;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.tooladapter.dialogs.TemplateParameterEditorDialog;

public class BundleForm
extends JPanel {
    private Map<OSFamily, Bundle> original;
    private Map<OSFamily, Bundle> modified;
    private final Map<OSFamily, PropertyContainer> propertyContainers;
    private final Map<OSFamily, BindingContext> bindingContexts;
    private final Map<OSFamily, List<JComponent>> controls;
    private List<SystemVariable> variables;
    private PropertyChangeListener listener;
    private AppContext appContext;
    private JTabbedPane bundleTabPane;
    private JComponent variablesCombo;

    public BundleForm(AppContext appContext, final Bundle windowsBundle, final Bundle linuxBundle, final Bundle macosxBundle, List<SystemVariable> variables) {
        this.original = new HashMap<OSFamily, Bundle>(){
            {
                this.put(OSFamily.windows, windowsBundle);
                this.put(OSFamily.linux, linuxBundle);
                this.put(OSFamily.macosx, macosxBundle);
            }
        };
        this.appContext = appContext;
        try {
            this.modified = this.copy(this.original);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.variables = variables;
        this.propertyContainers = new HashMap<OSFamily, PropertyContainer>();
        this.bindingContexts = new HashMap<OSFamily, BindingContext>();
        this.bundleTabPane = new JTabbedPane(1);
        this.bundleTabPane.setBorder(BorderFactory.createEmptyBorder());
        this.controls = new HashMap<OSFamily, List<JComponent>>();
        Bundle bundle = this.modified.get(OSFamily.windows);
        PropertyContainer propertyContainer = PropertyContainer.createObjectBacked((Object)bundle);
        this.propertyContainers.put(OSFamily.windows, propertyContainer);
        this.bindingContexts.put(OSFamily.windows, new BindingContext((PropertySet)propertyContainer));
        this.controls.put(OSFamily.windows, new ArrayList());
        bundle = this.modified.get(OSFamily.linux);
        propertyContainer = PropertyContainer.createObjectBacked((Object)bundle);
        this.propertyContainers.put(OSFamily.linux, propertyContainer);
        this.bindingContexts.put(OSFamily.linux, new BindingContext((PropertySet)propertyContainer));
        this.controls.put(OSFamily.linux, new ArrayList());
        bundle = this.modified.get(OSFamily.macosx);
        propertyContainer = PropertyContainer.createObjectBacked((Object)bundle);
        this.propertyContainers.put(OSFamily.macosx, propertyContainer);
        this.bindingContexts.put(OSFamily.macosx, new BindingContext((PropertySet)propertyContainer));
        this.controls.put(OSFamily.macosx, new ArrayList());
        this.buildUI();
        this.addChangeListeners();
        this.toggleControls(OSFamily.windows);
        this.toggleControls(OSFamily.linux);
        this.toggleControls(OSFamily.macosx);
    }

    public Map<OSFamily, Bundle> applyChanges() {
        try {
            this.original = this.copy(this.modified);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.original;
    }

    public void setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weighty = 0.01;
        this.addTab("Windows Bundle", this.createTab(OSFamily.windows));
        this.addTab("Linux Bundle", this.createTab(OSFamily.linux));
        this.addTab("MacOSX Bundle", this.createTab(OSFamily.macosx));
        GridBagUtils.addToPanel((JPanel)this, (Component)this.bundleTabPane, (GridBagConstraints)gbc, (String)"gridx=0, gridy=0, gridwidth=11, weightx=1");
        GridBagUtils.addToPanel((JPanel)this, (Component)new JLabel("Reflect in Variable:"), (GridBagConstraints)gbc, (String)"gridx=0, gridy=1, gridwidth=1, weightx=0");
        this.variablesCombo = this.getEditorComponent(OSFamily.all, "updateVariable", this.variables.stream().map(SystemVariable::getKey).toArray());
        GridBagUtils.addToPanel((JPanel)this, (Component)this.variablesCombo, (GridBagConstraints)gbc, (String)"gridx=1, gridy=1, gridwidth=10, weightx=0");
        GridBagUtils.addToPanel((JPanel)this, (Component)new JLabel(" "), (GridBagConstraints)gbc, (String)"gridx=0, gridy=2, gridwidth=11, weighty=1");
        int selected = 0;
        switch (Bundle.getCurrentOS()) {
            case windows: {
                selected = 0;
                break;
            }
            case linux: {
                selected = 1;
                break;
            }
            case macosx: {
                selected = 2;
            }
        }
        this.bundleTabPane.setSelectedIndex(selected);
        this.bundleTabPane.setUI(new BasicTabbedPaneUI());
    }

    public void setVariables(List<SystemVariable> variables) {
        this.variables = variables;
        PropertyContainer propertyContainer = this.propertyContainers.get(OSFamily.windows);
        BindingContext bindingContext = this.bindingContexts.get(OSFamily.windows);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("updateVariable");
        propertyDescriptor.setValueSet(new ValueSet(this.variables.stream().map(SystemVariable::getKey).toArray()));
        PropertyEditor propertyEditor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        this.variablesCombo = propertyEditor.createEditorComponent(propertyDescriptor, bindingContext);
        this.repaint();
    }

    private JPanel createTab(OSFamily osFamily) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 0.01;
        List<JComponent> controlGroup = this.controls.get(osFamily);
        final Bundle bundle = this.modified.get(osFamily);
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Type:"), (GridBagConstraints)c, (String)"gridx=0, gridy=0, gridwidth=1, weightx=0");
        JComponent type = this.getEditorComponent(osFamily, "bundleType");
        GridBagUtils.addToPanel((JPanel)panel, (Component)type, (GridBagConstraints)c, (String)"gridx=1, gridy=0, gridwidth=10, weightx=1");
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Location:"), (GridBagConstraints)c, (String)"gridx=0, gridy=1, gridwidth=1, weightx=0");
        ButtonGroup rbGroup = new ButtonGroup();
        JRadioButton rbLocal = new JRadioButton(BundleLocation.LOCAL.toString());
        rbGroup.add(rbLocal);
        JRadioButton rbRemote = new JRadioButton(BundleLocation.REMOTE.toString());
        rbGroup.add(rbRemote);
        if (BundleLocation.LOCAL.equals((Object)bundle.getLocation())) {
            rbLocal.setSelected(true);
        } else if (BundleLocation.REMOTE.equals((Object)bundle.getLocation())) {
            rbRemote.setSelected(true);
        }
        rbLocal.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.propertyContainers.get(osFamily).setValue("downloadURL", (Object)"");
                bundle.setLocation(BundleLocation.LOCAL);
                this.propertyContainers.get(osFamily).setValue("bundleLocation", (Object)BundleLocation.LOCAL);
                this.toggleControls(osFamily);
                this.firePropertyChange(new PropertyChangeEvent(bundle, "bundleLocation", null, BundleLocation.LOCAL));
            }
        });
        rbRemote.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.propertyContainers.get(osFamily).setValue("source", null);
                bundle.setLocation(BundleLocation.REMOTE);
                this.propertyContainers.get(osFamily).setValue("bundleLocation", (Object)BundleLocation.REMOTE);
                this.toggleControls(osFamily);
                this.firePropertyChange(new PropertyChangeEvent(bundle, "bundleLocation", null, BundleLocation.REMOTE));
            }
        });
        GridBagUtils.addToPanel((JPanel)panel, (Component)rbLocal, (GridBagConstraints)c, (String)"gridx=1, gridy=1, gridwidth=4, weightx=1");
        GridBagUtils.addToPanel((JPanel)panel, (Component)rbRemote, (GridBagConstraints)c, (String)"gridx=5, gridy=1, gridwidth=5, weightx=1");
        controlGroup.add(rbLocal);
        controlGroup.add(rbRemote);
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Source File:"), (GridBagConstraints)c, (String)"gridx=0, gridy=2, gridwidth=1, weightx=0");
        JComponent component = this.getEditorComponent(osFamily, "source");
        GridBagUtils.addToPanel((JPanel)panel, (Component)component, (GridBagConstraints)c, (String)"gridx=1, gridy=2, gridwidth=10, weightx=1");
        controlGroup.add(component);
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("URL:"), (GridBagConstraints)c, (String)"gridx=0, gridy=3, gridwidth=1, weightx=0");
        final JComponent downloadURL = this.getEditorComponent(osFamily, "downloadURL", "url");
        ((JTextField)downloadURL).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    String url = ((JTextField)downloadURL).getText();
                    URL checkedURL = new URL(url);
                    bundle.setDownloadURL(checkedURL.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String url = ((JTextField)downloadURL).getText();
                    URL checkedURL = new URL(url);
                    bundle.setDownloadURL(checkedURL.toString());
                    super.focusLost(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        GridBagUtils.addToPanel((JPanel)panel, (Component)downloadURL, (GridBagConstraints)c, (String)"gridx=1, gridy=3, gridwidth=10, weightx=1");
        controlGroup.add(downloadURL);
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Arguments:"), (GridBagConstraints)c, (String)"gridx=0, gridy=4, gridwidth=1, weightx=0");
        JTextField argumentsParam = new JTextField(bundle.getCommandLine());
        GridBagUtils.addToPanel((JPanel)panel, (Component)argumentsParam, (GridBagConstraints)c, (String)"gridx=1, gridy=4, gridwidth=9, weightx=0");
        controlGroup.add(argumentsParam);
        argumentsParam.setEditable(false);
        JButton argumentDetailsButton = new JButton("...");
        argumentDetailsButton.setMaximumSize(new Dimension(32, argumentDetailsButton.getHeight()));
        argumentDetailsButton.addActionListener(e -> {
            TemplateParameterEditorDialog parameterEditorDialog = new TemplateParameterEditorDialog(this.appContext, bundle.getArgumentsParameter(), bundle.getParent());
            int returnCode = parameterEditorDialog.show();
            if (returnCode == 1) {
                argumentsParam.setText(bundle.getCommandLine());
            }
        });
        GridBagUtils.addToPanel((JPanel)panel, (Component)argumentDetailsButton, (GridBagConstraints)c, (String)"gridx=10, gridy=4, gridwidth=1, weightx=0");
        controlGroup.add(argumentDetailsButton);
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Target Folder:"), (GridBagConstraints)c, (String)"gridx=0, gridy=5, gridwidth=1, weightx=0");
        component = this.getEditorComponent(osFamily, "targetLocation", true);
        GridBagUtils.addToPanel((JPanel)panel, (Component)component, (GridBagConstraints)c, (String)"gridx=1, gridy=5, gridwidth=10, weightx=1");
        controlGroup.add(component);
        this.toggleControls(osFamily);
        return panel;
    }

    private void addTab(String text, JPanel contents) {
        JLabel tabText = new JLabel(text, 2);
        Border titledBorder = BorderFactory.createEmptyBorder();
        contents.setBorder(titledBorder);
        this.bundleTabPane.addTab(null, contents);
        this.bundleTabPane.setTabComponentAt(this.bundleTabPane.getTabCount() - 1, tabText);
    }

    private void addChangeListeners() {
        this.propertyContainers.entrySet().forEach(entry -> {
            OSFamily osFamily = (OSFamily)entry.getKey();
            Bundle bundle = this.modified.get(osFamily);
            PropertyContainer propertyContainer = (PropertyContainer)entry.getValue();
            Property property = propertyContainer.getProperty("bundleType");
            property.addPropertyChangeListener(evt -> {
                bundle.setBundleType((BundleType)evt.getNewValue());
                this.toggleControls(osFamily);
            });
            property = propertyContainer.getProperty("updateVariable");
            property.addPropertyChangeListener(evt -> {
                Object value = evt.getNewValue();
                if (value != null) {
                    this.modified.values().forEach(b -> b.setUpdateVariable(value.toString()));
                }
            });
            property = propertyContainer.getProperty("bundleLocation");
            property.addPropertyChangeListener(evt -> {
                bundle.setLocation(Enum.valueOf(BundleLocation.class, (String)evt.getNewValue()));
                this.toggleControls(osFamily);
            });
            property = propertyContainer.getProperty("source");
            property.addPropertyChangeListener(evt -> {
                bundle.setSource((File)evt.getNewValue());
                this.firePropertyChange(new PropertyChangeEvent(bundle, "source", evt.getOldValue(), evt.getNewValue()));
            });
            property = propertyContainer.getProperty("downloadURL");
            property.addPropertyChangeListener(evt -> {
                try {
                    String url = String.valueOf(evt.getNewValue());
                    if (url != null && url.length() > 0) {
                        URL checkedURL = new URL(url);
                        bundle.setDownloadURL(checkedURL.toString());
                    } else {
                        bundle.setDownloadURL(null);
                    }
                    this.firePropertyChange(new PropertyChangeEvent(bundle, "source", evt.getOldValue(), evt.getNewValue()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            property = propertyContainer.getProperty("targetLocation");
            property.addPropertyChangeListener(evt -> {
                bundle.setTargetLocation(String.valueOf(evt.getNewValue()));
                this.firePropertyChange(new PropertyChangeEvent(bundle, "source", evt.getOldValue(), evt.getNewValue()));
            });
            property = propertyContainer.getProperty("templateparameter");
            property.addPropertyChangeListener(evt -> bundle.setArgumentsParameter((TemplateParameterDescriptor)evt.getNewValue()));
        });
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        if (this.listener != null) {
            this.listener.propertyChange(event);
        }
    }

    private void toggleControls(OSFamily osFamily) {
        Bundle bundle = this.modified.get(osFamily);
        boolean canSelect = bundle.getBundleType() != BundleType.NONE;
        BundleLocation location = bundle.getLocation();
        boolean remoteCondition = canSelect && location == BundleLocation.REMOTE;
        boolean localCondition = canSelect && location == BundleLocation.LOCAL;
        for (JComponent component : this.controls.get(osFamily)) {
            if ("url".equals(component.getName())) {
                component.setEnabled(remoteCondition);
                continue;
            }
            component.setEnabled(canSelect);
        }
        BindingContext bindingContext = this.bindingContexts.get(osFamily);
        JComponent[] components = bindingContext.getBinding("source").getComponents();
        for (JComponent jComponent : components) {
            jComponent.setEnabled(localCondition);
        }
        for (Component component : components[0].getParent().getComponents()) {
            component.setEnabled(localCondition);
        }
        components = bindingContext.getBinding("targetLocation").getComponents();
        for (Component component : components) {
            ((JComponent)component).setEnabled(canSelect);
        }
        this.repaint();
    }

    private JComponent getEditorComponent(OSFamily osFamily, String propertyName) {
        return this.getEditorComponent(osFamily, propertyName, null, false);
    }

    private JComponent getEditorComponent(OSFamily osFamily, String propertyName, boolean isFolder) {
        return this.getEditorComponent(osFamily, propertyName, null, isFolder);
    }

    private JComponent getEditorComponent(OSFamily osFamily, String propertyName, String controlName) {
        return this.getEditorComponent(osFamily, propertyName, controlName, false);
    }

    private JComponent getEditorComponent(OSFamily osFamily, String propertyName, Object[] items) {
        if (osFamily == OSFamily.all) {
            osFamily = OSFamily.windows;
        }
        PropertyContainer propertyContainer = this.propertyContainers.get(osFamily);
        BindingContext bindingContext = this.bindingContexts.get(osFamily);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor(propertyName);
        if (items != null) {
            propertyDescriptor.setValueSet(new ValueSet(items));
        }
        PropertyEditor propertyEditor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        return propertyEditor.createEditorComponent(propertyDescriptor, bindingContext);
    }

    private JComponent getEditorComponent(OSFamily osFamily, String propertyName, String controlName, boolean isFolder) {
        if (osFamily == OSFamily.all) {
            osFamily = OSFamily.windows;
        }
        PropertyContainer propertyContainer = this.propertyContainers.get(osFamily);
        BindingContext bindingContext = this.bindingContexts.get(osFamily);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor(propertyName);
        if (isFolder) {
            propertyDescriptor.setAttribute("directory", (Object)true);
        }
        PropertyEditor propertyEditor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = propertyEditor.createEditorComponent(propertyDescriptor, bindingContext);
        if (controlName != null) {
            editorComponent.setName(controlName);
        }
        return editorComponent;
    }

    private Map<OSFamily, Bundle> copy(Map<OSFamily, Bundle> sources) throws Exception {
        if (sources == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        HashMap<OSFamily, Bundle> bundles = new HashMap<OSFamily, Bundle>();
        for (Map.Entry<OSFamily, Bundle> entry : sources.entrySet()) {
            Bundle source = entry.getValue();
            Bundle target = new Bundle(source);
            bundles.put(entry.getKey(), target);
        }
        return bundles;
    }
}

