/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.converters.StringConverter;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.event.FocusEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertyAttributeException;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapper;

public class PropertyMemberUIWrapperFactory {
    public static PropertyMemberUIWrapper buildEmptyPropertyWrapper() {
        return new PropertyMemberUIWrapper(null, null, null, null, -1, null){

            @Override
            public String getErrorValueMessage(Object value) {
                return null;
            }

            @Override
            protected void setMemberValue(Object value) throws PropertyAttributeException {
            }

            @Override
            public String getMemberValue() {
                return null;
            }

            @Override
            protected JComponent buildUIComponent() {
                return new JLabel();
            }

            @Override
            protected String getValueFromUIComponent() throws PropertyAttributeException {
                return null;
            }
        };
    }

    public static PropertyMemberUIWrapper buildPropertyWrapper(String attributeName, ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        switch (attributeName) {
            case "name": {
                return PropertyMemberUIWrapperFactory.buildNamePropertyWrapper(attributeName, property, opDescriptor, context, 100, callback);
            }
            case "dataType": {
                return PropertyMemberUIWrapperFactory.buildTypePropertyWrapper(attributeName, property, opDescriptor, context, 150, callback);
            }
            case "defaultValue": {
                return PropertyMemberUIWrapperFactory.buildValuePropertyEditorWrapper(attributeName, property, opDescriptor, context, 250, callback);
            }
        }
        Method getter = null;
        try {
            getter = property.getClass().getSuperclass().getDeclaredMethod("is" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Object value = null;
        try {
            value = property.getAttribute(attributeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (getter != null || value != null && value.getClass().getSuperclass().equals(Boolean.class)) {
            return PropertyMemberUIWrapperFactory.buildBooleanPropertyWrapper(attributeName, property, opDescriptor, context, 30, callback);
        }
        try {
            getter = property.getClass().getSuperclass().getDeclaredMethod("get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (getter != null && getter.getReturnType().equals(String.class)) {
            return PropertyMemberUIWrapperFactory.buildStringPropertyWrapper(attributeName, property, opDescriptor, context, 100, callback);
        }
        if (attributeName.equals("valueRange") || attributeName.equals("pattern") || attributeName.equals("valueSet")) {
            return PropertyMemberUIWrapperFactory.buildStringPropertyWrapper(attributeName, property, opDescriptor, context, 150, callback);
        }
        return PropertyMemberUIWrapperFactory.buildEmptyWrapper(attributeName, property, opDescriptor, context, 100, callback);
    }

    private static Object parseAttributeValue(String attributeName, String value, ToolParameterDescriptor property) throws PropertyAttributeException {
        if (value == null || value.length() == 0) {
            return null;
        }
        Method getter = null;
        try {
            getter = property.getClass().getSuperclass().getDeclaredMethod("get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1), new Class[0]);
            if (getter != null && getter.getReturnType().equals(String.class)) {
                return value;
            }
            if (getter != null && getter.getReturnType().equals(String[].class)) {
                Object[] items = ValueSet.parseValueSet((String)value, String.class).getItems();
                String[] result = new String[items.length];
                for (int i = 0; i < items.length; ++i) {
                    result[i] = items[i].toString();
                }
                return result;
            }
            if (getter != null && getter.getReturnType().equals(ValueRange.class)) {
                return ValueRange.parseValueRange((String)value);
            }
            if (getter != null && getter.getReturnType().equals(Pattern.class)) {
                return Pattern.compile(value);
            }
        }
        catch (Exception ex) {
            throw new PropertyAttributeException("Error on parsing the value " + value + " in order to set the value for attribute " + attributeName);
        }
        return value;
    }

    private static PropertyMemberUIWrapper buildStringPropertyWrapper(String attributeName, final ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, int width, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        return new PropertyMemberUIWrapper(attributeName, property, opDescriptor, context, width, callback){

            @Override
            public String getErrorValueMessage(Object value) {
                return null;
            }

            @Override
            protected void setMemberValue(Object value) throws PropertyAttributeException {
                property.setAttribute(this.attributeName, value);
            }

            @Override
            public String getMemberValue() throws PropertyAttributeException {
                Object obj = property.getAttribute(this.attributeName);
                if (obj == null) {
                    return "";
                }
                if (obj instanceof String[]) {
                    return StringUtils.join((Object[])((String[])obj), (String)",");
                }
                return obj.toString();
            }

            @Override
            protected JComponent buildUIComponent() throws Exception {
                JTextField field = new JTextField(this.getMemberValue());
                return field;
            }

            @Override
            protected Object getValueFromUIComponent() throws PropertyAttributeException {
                return PropertyMemberUIWrapperFactory.parseAttributeValue(this.attributeName, ((JTextField)this.UIComponent).getText(), property);
            }
        };
    }

    private static PropertyMemberUIWrapper buildBooleanPropertyWrapper(String attributeName, final ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, int width, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        return new PropertyMemberUIWrapper(attributeName, property, opDescriptor, context, width, callback){

            @Override
            protected void setMemberValue(Object value) throws PropertyAttributeException {
                property.setAttribute(this.attributeName, value);
            }

            @Override
            public Boolean getMemberValue() throws PropertyAttributeException {
                Object obj = property.getAttribute(this.attributeName);
                return obj != null && (Boolean)obj != false;
            }

            @Override
            protected JComponent buildUIComponent() throws PropertyAttributeException {
                JCheckBox button = new JCheckBox();
                button.setSelected(this.getMemberValue());
                return button;
            }

            @Override
            protected Boolean getValueFromUIComponent() throws PropertyAttributeException {
                return ((JCheckBox)this.UIComponent).isSelected();
            }
        };
    }

    private static PropertyMemberUIWrapper buildNamePropertyWrapper(String attributeName, final ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, int width, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        return new PropertyMemberUIWrapper(attributeName, property, opDescriptor, context, width, callback){

            @Override
            public String getErrorValueMessage(Object value) {
                if (value == null || !(value instanceof String) || ((String)value).length() == 0) {
                    return "Name of the property cannot be empty and must be a string!";
                }
                if (property.getName().equals(value)) {
                    return null;
                }
                for (ParameterDescriptor prop : this.opDescriptor.getParameterDescriptors()) {
                    if (prop == property || !prop.getName().equals(value)) continue;
                    return "The operator must not have more then one parameter with the same name!";
                }
                return null;
            }

            @Override
            protected void setMemberValue(Object value) throws PropertyAttributeException {
                property.setName(value != null ? value.toString() : "null");
            }

            @Override
            public String getMemberValue() {
                return property.getName();
            }

            @Override
            protected JComponent buildUIComponent() {
                return new JTextField(this.getMemberValue());
            }

            @Override
            protected String getValueFromUIComponent() throws PropertyAttributeException {
                return ((JTextField)this.UIComponent).getText();
            }
        };
    }

    private static PropertyMemberUIWrapper buildTypePropertyWrapper(String attributeName, final ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, int width, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        return new PropertyMemberUIWrapper(attributeName, property, opDescriptor, context, width, callback){

            @Override
            public String getErrorValueMessage(Object value) {
                if (value == null) {
                    return "Type of the property cannot be empty!";
                }
                return null;
            }

            @Override
            protected void setMemberValue(Object value) throws PropertyAttributeException {
                property.setDataType(value != null ? (Class)value : String.class);
            }

            @Override
            public Class<?> getMemberValue() {
                return property.getDataType();
            }

            @Override
            protected JComponent buildUIComponent() {
                return new JTextField(((Class)this.getMemberValue()).getCanonicalName());
            }

            @Override
            public boolean propertyUIComponentsNeedsRevalidation() {
                return true;
            }

            @Override
            protected Class<?> getValueFromUIComponent() throws PropertyAttributeException {
                try {
                    return Class.forName(((JTextField)this.UIComponent).getText());
                }
                catch (ClassNotFoundException ex) {
                    throw new PropertyAttributeException("Type of the property not found in the libraries");
                }
            }
        };
    }

    private static PropertyMemberUIWrapper buildValuePropertyEditorWrapper(String attributeName, final ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, final BindingContext context, int width, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        return new PropertyMemberUIWrapper(attributeName, property, opDescriptor, context, width, callback){

            @Override
            public String getErrorValueMessage(Object value) {
                return null;
            }

            @Override
            public void setMemberValue(Object value) throws PropertyAttributeException {
            }

            @Override
            public JComponent reloadUIComponent(Class<?> newParamType) throws Exception {
                PropertyDescriptor descriptor;
                property.setDataType(newParamType);
                Property oldProp = context.getPropertySet().getProperty(property.getName());
                Object dirAttr = null;
                if (oldProp != null) {
                    descriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)property, (Map)new ParameterDescriptorFactory().getSourceProductMap());
                    dirAttr = descriptor.getAttribute("directory");
                    context.getPropertySet().removeProperty(oldProp);
                }
                try {
                    descriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)property, (Map)new ParameterDescriptorFactory().getSourceProductMap());
                }
                catch (Exception ex) {
                    property.setDefaultValue(null);
                    descriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)property, (Map)new ParameterDescriptorFactory().getSourceProductMap());
                }
                descriptor.setDefaultConverter();
                try {
                    descriptor.setDefaultValue((Object)property.getDefaultValue());
                }
                catch (Exception ex) {
                    Logger.getLogger(PropertyMemberUIWrapper.class.getName()).warning(ex.getMessage());
                }
                try {
                    descriptor.setValueSet(ValueSet.parseValueSet((String[])property.getValueSet(), (Converter)new StringConverter()));
                }
                catch (Exception ex) {
                    Logger.getLogger(PropertyMemberUIWrapper.class.getName()).warning(ex.getMessage());
                }
                DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
                if (dirAttr != null) {
                    descriptor.setAttribute("directory", dirAttr);
                }
                propertySetDescriptor.addPropertyDescriptor(descriptor);
                PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
                context.getPropertySet().addProperties(container.getProperties());
                return super.reloadUIComponent(newParamType);
            }

            @Override
            public Object getMemberValue() {
                return property.getDefaultValue();
            }

            @Override
            protected JComponent buildUIComponent() {
                PropertyDescriptor propertydescriptor = context.getPropertySet().getDescriptor(property.getName());
                PropertyEditor propertyEditor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertydescriptor);
                return propertyEditor.createEditorComponent(propertydescriptor, context);
            }

            @Override
            protected Object getValueFromUIComponent() throws PropertyAttributeException {
                return null;
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    public static PropertyMemberUIWrapper buildEmptyWrapper(String attributeName, ToolParameterDescriptor property, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, int width, PropertyMemberUIWrapper.CallBackAfterEdit callback) {
        return new PropertyMemberUIWrapper(attributeName, property, opDescriptor, context, width, callback){

            @Override
            public String getErrorValueMessage(Object value) {
                return null;
            }

            @Override
            protected void setMemberValue(Object value) throws PropertyAttributeException {
            }

            @Override
            public Object getMemberValue() {
                return null;
            }

            @Override
            protected JComponent buildUIComponent() {
                return new JLabel("");
            }

            @Override
            protected Object getValueFromUIComponent() {
                return null;
            }
        };
    }
}

