/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.esa.snap.core.gpf.descriptor.SystemDependentVariable;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.dialogs.ToolAdapterEditorDialog;
import org.esa.snap.ui.tooladapter.model.VariableChangedListener;

public class SystemDependentVariableEditorDialog
extends ModalDialog {
    private SystemDependentVariable oldVariable;
    private SystemDependentVariable newVariable;
    private List<VariableChangedListener> listeners = new ArrayList<VariableChangedListener>();
    private Logger logger;

    public SystemDependentVariableEditorDialog(Window parent, SystemDependentVariable variable, String helpID) {
        super(parent, String.format("Edit %s", variable.getKey()), 33, helpID);
        this.oldVariable = variable;
        this.newVariable = (SystemDependentVariable)this.oldVariable.createCopy();
        this.newVariable.setTransient(true);
        this.logger = Logger.getLogger(ToolAdapterEditorDialog.class.getName());
        this.setContent(this.createPanel());
        EscapeAction.register(this.getJDialog());
    }

    protected void onOK() {
        super.onOK();
        this.oldVariable.setWindows(this.newVariable.getWindows());
        this.oldVariable.setLinux(this.newVariable.getLinux());
        this.oldVariable.setMacosx(this.newVariable.getMacosx());
        for (VariableChangedListener l : this.listeners) {
            l.variableChanged(null);
        }
    }

    private JPanel createPanel() {
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{100, 390};
        JPanel mainPanel = new JPanel(layout);
        this.addTextEditor(mainPanel, "Windows value:", this.newVariable.getWindows(), "windows", 0);
        this.addTextEditor(mainPanel, "Linux value:", this.newVariable.getLinux(), "linux", 1);
        this.addTextEditor(mainPanel, "MacOSX value:", this.newVariable.getMacosx(), "macosx", 2);
        return mainPanel;
    }

    private void addTextEditor(JPanel parent, String label, String value, String fieldName, int line) {
        parent.add((Component)new JLabel(label), this.getConstraints(line, 0, 1));
        JTextField textField = new JTextField(value);
        textField.getDocument().addDocumentListener(new TextChangeListener(textField, this.newVariable, fieldName));
        parent.add((Component)textField, this.getConstraints(line, 1, 1));
    }

    private GridBagConstraints getConstraints(int row, int col, int noCells) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = col;
        c.gridy = row;
        if (noCells != -1) {
            c.gridwidth = noCells;
        }
        c.insets = new Insets(2, 10, 2, 10);
        return c;
    }

    public void addListener(VariableChangedListener l) {
        this.listeners.add(l);
    }

    public void removeListener(VariableChangedListener l) {
        this.listeners.remove(l);
    }

    private class TextChangeListener
    implements DocumentListener {
        private JTextField parent;
        private SystemDependentVariable instance;
        private Method fieldSetter;

        TextChangeListener(JTextField parentControl, SystemDependentVariable instance, String fieldName) {
            this.parent = parentControl;
            this.instance = instance;
            try {
                this.fieldSetter = instance.getClass().getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), String.class);
            }
            catch (NoSuchMethodException e) {
                SystemDependentVariableEditorDialog.this.logger.severe(e.getMessage());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateProperty();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateProperty();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateProperty();
        }

        private void updateProperty() {
            EventQueue.invokeLater(() -> {
                try {
                    this.fieldSetter.invoke((Object)this.instance, this.parent.getText());
                }
                catch (Exception e1) {
                    SystemDependentVariableEditorDialog.this.logger.severe(e1.getMessage());
                }
            });
        }
    }
}

