/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.Property;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.template.TemplateFile;
import org.esa.snap.core.gpf.operators.tooladapter.DefaultOutputConsumer;
import org.esa.snap.core.gpf.operators.tooladapter.ProcessOutputConsumer;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.dialogs.AbstractAdapterEditor;
import org.esa.snap.ui.tooladapter.dialogs.Bundle;
import org.esa.snap.ui.tooladapter.dialogs.ConsolePane;
import org.esa.snap.ui.tooladapter.dialogs.ToolExecutionForm;
import org.esa.snap.ui.tooladapter.model.OperationType;
import org.esa.snap.utils.PrivilegedAccessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.util.Cancellable;

public class ToolAdapterExecutionDialog
extends SingleTargetProductDialog {
    private static final String SOURCE_PRODUCT_FIELD = "sourceProduct";
    private ToolAdapterOperatorDescriptor operatorDescriptor;
    private OperatorParameterSupport parameterSupport;
    private ToolExecutionForm form;
    private Product result;
    private OperatorTask operatorTask;
    private Logger logger = Logger.getLogger(ToolAdapterExecutionDialog.class.getName());
    private List<String> warnings;
    private static final String helpID = "sta_execution";
    private List<ToolParameterDescriptor> artificiallyAddedParams;

    public ToolAdapterExecutionDialog(ToolAdapterOperatorDescriptor descriptor, AppContext appContext, String title) {
        super(appContext, title, helpID);
        this.initialize(descriptor);
        this.warnings = new ArrayList<String>();
    }

    private void updatePrimitiveZeroValuesHashMap() {
        try {
            HashMap primitiveZeroValuesMap = (HashMap)PrivilegedAccessor.getStaticValue(Property.class, "PRIMITIVE_ZERO_VALUES");
            primitiveZeroValuesMap.put(Boolean.class, false);
            primitiveZeroValuesMap.put(Character.class, Character.valueOf('\u0000'));
            primitiveZeroValuesMap.put(Byte.class, (byte)0);
            primitiveZeroValuesMap.put(Short.class, (short)0);
            primitiveZeroValuesMap.put(Integer.class, 0);
            primitiveZeroValuesMap.put(Long.class, 0L);
            primitiveZeroValuesMap.put(Float.class, Float.valueOf(0.0f));
            primitiveZeroValuesMap.put(Double.class, 0.0);
        }
        catch (IllegalAccessException | NoSuchFieldException iaExc) {
            this.logger.severe(iaExc.getMessage());
        }
    }

    private void initialize(ToolAdapterOperatorDescriptor descriptor) {
        this.operatorDescriptor = descriptor;
        this.artificiallyAddedParams = new ArrayList<ToolParameterDescriptor>();
        Arrays.stream(this.operatorDescriptor.getToolParameterDescriptors().toArray()).filter(p -> ((ToolParameterDescriptor)p).isTemplateParameter()).forEach(p -> this.artificiallyAddedParams.addAll(((TemplateParameterDescriptor)p).getParameterDescriptors()));
        this.operatorDescriptor.getToolParameterDescriptors().addAll(this.artificiallyAddedParams);
        this.parameterSupport = new OperatorParameterSupport((OperatorDescriptor)this.operatorDescriptor);
        Arrays.stream(this.operatorDescriptor.getToolParameterDescriptors().toArray()).filter(p -> "FolderParameter".equals(((ToolParameterDescriptor)p).getParameterType())).forEach(p -> this.parameterSupport.getPropertySet().getProperty(((ToolParameterDescriptor)p).getName()).getDescriptor().setAttribute("directory", (Object)true));
        this.form = new ToolExecutionForm(this.appContext, this.operatorDescriptor, this.parameterSupport.getPropertySet(), this.getTargetProductSelector());
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), (OperatorDescriptor)this.operatorDescriptor, this.parameterSupport, this.appContext, helpID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
        EscapeAction.register(this.getJDialog());
        this.updatePrimitiveZeroValuesHashMap();
        this.getJDialog().addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ToolAdapterExecutionDialog.this.form.refreshDimension();
            }
        });
        this.getJDialog().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ToolAdapterExecutionDialog.this.form.refreshDimension();
            }
        });
        this.getJDialog().setMinimumSize(new Dimension(250, 250));
    }

    protected void onApply() {
        Dialogs.Answer decision;
        String templateContents;
        Product[] sourceProducts = this.form.getSourceProducts();
        List descriptors = Arrays.stream(this.operatorDescriptor.getParameterDescriptors()).filter(p -> "targetProductFile".equals(p.getName())).collect(Collectors.toList());
        try {
            TemplateFile template = this.operatorDescriptor.getTemplate();
            templateContents = template.getContents();
        }
        catch (Exception ex) {
            this.showErrorDialog(String.format("Cannot read operator template [%s]", ex.getMessage()));
            return;
        }
        if (Arrays.stream(sourceProducts).anyMatch(p -> p == null) && (decision = Dialogs.requestDecision((String)"No Product Selected", (String)Bundle.NoSourceProductWarning_Text(), (boolean)false, (String)"sta.warn.no.product")).equals((Object)Dialogs.Answer.NO)) {
            return;
        }
        if (descriptors.size() == 1 && this.form.getPropertyValue("targetProductFile") == null && templateContents.contains("$targetProductFile")) {
            Dialogs.showWarning((String)Bundle.RequiredTargetProductMissingWarning_Text());
        } else if (!this.canApply()) {
            this.displayWarnings();
            AbstractAdapterEditor dialog = AbstractAdapterEditor.createEditorDialog(this.appContext, this.getJDialog(), this.operatorDescriptor, OperationType.EDIT);
            int code = dialog.show();
            if (code == 1) {
                this.onOperatorDescriptorChanged(dialog.getUpdatedOperatorDescriptor());
            }
            dialog.close();
        } else if (this.validateUserInput()) {
            HashMap<String, Product> sourceProductMap = new HashMap<String, Product>();
            if (sourceProducts.length > 0) {
                sourceProductMap.put(SOURCE_PRODUCT_FIELD, sourceProducts[0]);
            }
            Operator op = GPF.getDefaultInstance().createOperator(this.operatorDescriptor.getAlias(), this.parameterSupport.getParameterMap(), sourceProductMap, null);
            for (Property property : this.parameterSupport.getPropertySet().getProperties()) {
                op.setParameter(property.getName(), property.getValue());
            }
            op.setSourceProducts(sourceProducts);
            this.operatorTask = new OperatorTask(op, this::operatorCompleted);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.getTitle());
            String progressPattern = this.operatorDescriptor.getProgressPattern();
            ProgressWrapper progressWrapper = new ProgressWrapper(progressHandle, progressPattern == null || progressPattern.isEmpty());
            ConsoleConsumer consumer = new ConsoleConsumer(this.operatorDescriptor.getProgressPattern(), this.operatorDescriptor.getErrorPattern(), this.operatorDescriptor.getStepPattern(), progressWrapper, this.form.console);
            this.form.console.clear();
            progressWrapper.setConsumer(consumer);
            ((ToolAdapterOp)op).setProgressMonitor((ProgressMonitor)progressWrapper);
            ((ToolAdapterOp)op).setConsumer((ProcessOutputConsumer)consumer);
            ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)this.operatorTask, (String)this.getTitle(), (ProgressHandle)progressHandle, (boolean)true, (int)1, (int)1);
        } else if (this.warnings.size() > 0) {
            this.displayWarnings();
        }
    }

    public int show() {
        this.form.prepareShow();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareHide();
        super.hide();
        this.operatorDescriptor.getToolParameterDescriptors().removeAll(this.artificiallyAddedParams);
    }

    protected Product createTargetProduct() throws Exception {
        return this.result;
    }

    protected boolean canApply() {
        this.warnings.clear();
        try {
            ParameterDescriptor[] parameterDescriptors;
            Path workLocation;
            Path toolLocation = this.operatorDescriptor.resolveVariables(this.operatorDescriptor.getMainToolFileLocation()).toPath();
            if (!Files.exists(toolLocation, new LinkOption[0]) || !Files.isExecutable(toolLocation)) {
                this.warnings.add(this.logAndReturn(String.format("Path does not exist: '%s'", toolLocation), new Object[0]));
            }
            if (!Files.exists(workLocation = this.operatorDescriptor.resolveVariables(this.operatorDescriptor.getWorkingDir()).toPath(), new LinkOption[0])) {
                this.warnings.add(this.logAndReturn("Working path does not exist: '%s'", workLocation));
            }
            if ((parameterDescriptors = this.operatorDescriptor.getParameterDescriptors()) != null && parameterDescriptors.length > 0) {
                for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
                    Class dataType = parameterDescriptor.getDataType();
                    String paramName = parameterDescriptor.getName();
                    if (!this.parameterSupport.getParameterMap().containsKey(paramName)) continue;
                    Object value = this.parameterSupport.getParameterMap().get(paramName);
                    String currentValue = value != null ? value.toString() : null;
                    try {
                        if (!File.class.isAssignableFrom(dataType) || !parameterDescriptor.isNotNull() && !parameterDescriptor.isNotEmpty() || currentValue != null && !currentValue.isEmpty() && Files.exists(Paths.get(currentValue, new String[0]), new LinkOption[0])) continue;
                        this.warnings.add(this.logAndReturn("Path does not exist: '%s'", currentValue == null ? "null" : currentValue));
                    }
                    catch (Exception ex) {
                        this.warnings.add(this.logAndReturn("Cannot access path %s [%s]", currentValue, ex.getMessage()));
                    }
                }
            }
            for (SystemVariable variable : this.operatorDescriptor.getVariables()) {
                String value = variable.getValue();
                if (value != null && !value.isEmpty()) continue;
                this.warnings.add(this.logAndReturn("Variable %s is not set", variable.getKey()));
            }
        }
        catch (Exception e) {
            this.warnings.add(this.logAndReturn(e.getMessage(), new Object[0]));
        }
        return this.warnings.size() == 0;
    }

    protected void onCancel() {
        if (this.operatorTask != null) {
            this.operatorTask.cancel();
        }
        super.onCancel();
    }

    protected void onClose() {
        super.onClose();
    }

    private void onOperatorDescriptorChanged(ToolAdapterOperatorDescriptor newOperatorDescriptor) {
        this.initialize(newOperatorDescriptor);
        this.show();
    }

    private boolean validateUserInput() {
        Product[] sourceProducts;
        boolean isValid = true;
        if (!this.operatorDescriptor.isHandlingOutputName()) {
            File productDir = null;
            Object value = this.form.getPropertyValue("targetProductFile");
            if (value != null && value instanceof File) {
                productDir = ((File)value).getParentFile();
                this.appContext.getPreferences().setPropertyString("last_product_save_dir", ((File)value).getAbsolutePath());
            }
            boolean bl = isValid = productDir != null && productDir.exists();
            if (!isValid) {
                this.warnings.add("Target product folder is not accessible or does not exist");
            }
        }
        List mandatoryParams = this.operatorDescriptor.getToolParameterDescriptors().stream().filter(d -> d.isNotEmpty() || d.isNotNull()).collect(Collectors.toList());
        Map parameterMap = this.parameterSupport.getParameterMap();
        for (ToolParameterDescriptor mandatoryParam : mandatoryParams) {
            String name = mandatoryParam.getName();
            if (parameterMap.containsKey(name) && parameterMap.get(name) != null && !parameterMap.get(name).toString().isEmpty()) continue;
            isValid = false;
            this.warnings.add(String.format("No value was assigned for the mandatory parameter [%s]", name));
        }
        if (this.operatorDescriptor.getSourceProductCount() > 0 && !(isValid &= (sourceProducts = this.form.getSourceProducts()) != null && sourceProducts.length > 0 && Arrays.stream(sourceProducts).filter(sp -> sp == null).count() == 0L)) {
            this.warnings.add("No source product was selected");
        }
        return isValid;
    }

    private String logAndReturn(String templateMessage, Object ... params) {
        String message = String.format(templateMessage, params);
        this.logger.warning(message);
        return message;
    }

    private void displayWarnings() {
        StringBuilder warnMessage = new StringBuilder();
        warnMessage.append("Before executing the tool, please correct the errors below:").append("\n").append("\n");
        for (String msg : this.warnings) {
            warnMessage.append("\t").append(msg).append("\n");
        }
        Dialogs.showWarning((String)warnMessage.toString());
    }

    private void operatorCompleted(Product result) {
        this.result = result;
        super.onApply();
    }

    private void tearDown(Throwable throwable, Product result) {
        Dialogs.Answer answer;
        if (this.operatorTask != null) {
            this.operatorTask.cancel();
        }
        if (throwable != null && result != null && (answer = Dialogs.requestDecision((String)Bundle.ExecutionFailed_Text(), (String)String.format(Bundle.ExecutionFailed_Message(), throwable.getMessage()), (boolean)false, null)) == Dialogs.Answer.YES) {
            this.operatorCompleted(result);
        }
        this.displayErrorMessage();
    }

    private void displayErrorMessage() {
        List<String> errors;
        if (this.operatorTask != null && (errors = this.operatorTask.getErrors()) != null && errors.size() > 0) {
            Dialogs.showWarning((String)"\nIt seems there was en error on execution or the defined tool output error pattern was found.\nPlease consult the SNAP log file");
        }
    }

    private class ProgressWrapper
    implements ProgressMonitor {
        private ProgressHandle progressHandle;
        private boolean isIndeterminate;
        private ConsoleConsumer console;

        ProgressWrapper(ProgressHandle handle, boolean indeterminate) {
            this.progressHandle = handle;
            this.isIndeterminate = indeterminate;
        }

        void setConsumer(ConsoleConsumer consumer) {
            this.console = consumer;
        }

        public void beginTask(String taskName, int totalWork) {
            this.progressHandle.setDisplayName(taskName);
            this.progressHandle.start(totalWork, -1L);
            if (this.isIndeterminate) {
                this.progressHandle.switchToIndeterminate();
            }
            if (this.console != null) {
                this.console.setVisible(true);
            }
        }

        public void done() {
            this.progressHandle.finish();
        }

        public void internalWorked(double work) {
            this.progressHandle.progress((int)work);
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean canceled) {
            this.progressHandle.suspend("Cancelled");
        }

        public void setTaskName(String taskName) {
            this.progressHandle.setDisplayName(taskName);
        }

        public void setSubTaskName(String subTaskName) {
            this.progressHandle.progress(subTaskName);
        }

        public void worked(int work) {
            this.internalWorked(work);
        }
    }

    private class ConsoleConsumer
    extends DefaultOutputConsumer {
        private ConsolePane consolePane;

        ConsoleConsumer(String progressPattern, String errorPattern, String stepPattern, ProgressMonitor pm, ConsolePane consolePane) {
            super(progressPattern, errorPattern, stepPattern, pm);
            this.consolePane = consolePane;
        }

        public void consumeOutput(String line) {
            super.consumeOutput(line);
            if (this.consolePane != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.consume(line);
                } else {
                    SwingUtilities.invokeLater(() -> this.consume(line));
                }
            }
        }

        void setVisible(boolean value) {
            if (this.consolePane != null) {
                this.consolePane.setVisible(value);
            }
        }

        private void consume(String line) {
            if (this.error == null || !this.error.matcher(line).matches()) {
                this.consolePane.appendInfo(line);
            } else {
                this.consolePane.appendError(line);
            }
        }
    }

    private class OperatorTask
    implements Runnable,
    Cancellable {
        private Operator operator;
        private Consumer<Product> callbackMethod;
        private boolean hasCompleted;

        OperatorTask(Operator op, Consumer<Product> callback) {
            this.operator = op;
            this.callbackMethod = callback;
        }

        public boolean cancel() {
            if (!this.hasCompleted) {
                if (this.operator instanceof ToolAdapterOp) {
                    ((ToolAdapterOp)this.operator).stop();
                }
                this.hasCompleted = true;
            }
            return true;
        }

        @Override
        public void run() {
            try {
                this.callbackMethod.accept(this.operator.getTargetProduct());
            }
            catch (Throwable t) {
                if (this.operator instanceof ToolAdapterOp) {
                    ToolAdapterExecutionDialog.this.tearDown(t, ((ToolAdapterOp)this.operator).getResult());
                } else {
                    ToolAdapterExecutionDialog.this.tearDown(t, null);
                }
            }
            finally {
                this.hasCompleted = true;
            }
        }

        List<String> getErrors() {
            List errors = null;
            if (this.operator != null && this.operator instanceof ToolAdapterOp) {
                errors = ((ToolAdapterOp)this.operator).getErrors();
            }
            return errors;
        }

        public List<String> getOutput() {
            List allMessages = null;
            if (this.operator != null && this.operator instanceof ToolAdapterOp) {
                allMessages = ((ToolAdapterOp)this.operator).getExecutionOutput();
            }
            return allMessages;
        }
    }
}

