/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.binding.PropertyPane;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.ui.DefaultIOParametersPanel;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.tooladapter.dialogs.ConsolePane;
import org.esa.snap.utils.SpringUtilities;
import org.openide.util.NbPreferences;

class ToolExecutionForm
extends JTabbedPane {
    private AppContext appContext;
    private ToolAdapterOperatorDescriptor operatorDescriptor;
    private PropertySet propertySet;
    private TargetProductSelector targetProductSelector;
    private DefaultIOParametersPanel ioParamPanel;
    private String fileExtension;
    private JCheckBox checkDisplayOutput;
    ConsolePane console;
    private final String TIF_EXTENSION = ".tif";
    JSplitPane bottomPane;

    public ToolExecutionForm(AppContext appContext, ToolAdapterOperatorDescriptor descriptor, PropertySet propertySet, TargetProductSelector targetProductSelector) {
        this.appContext = appContext;
        this.operatorDescriptor = descriptor;
        this.propertySet = propertySet;
        this.targetProductSelector = targetProductSelector;
        Property sourceProperty = this.propertySet.getProperty("sourceProductFile");
        if (sourceProperty != null) {
            this.propertySet.removeProperty(sourceProperty);
        }
        if ((sourceProperty = this.propertySet.getProperty("sourceProduct")) != null) {
            this.propertySet.removeProperty(sourceProperty);
        }
        if (this.operatorDescriptor.isHandlingOutputName() && (sourceProperty = this.propertySet.getProperty("targetProductFile")) != null) {
            this.propertySet.removeProperty(sourceProperty);
        }
        TargetProductSelectorModel targetProductSelectorModel = targetProductSelector.getModel();
        targetProductSelectorModel.setProductDir(this.operatorDescriptor.resolveVariables(this.operatorDescriptor.getWorkingDir()));
        if (!this.operatorDescriptor.isHandlingOutputName() || this.operatorDescriptor.getSourceProductCount() > 0) {
            this.ioParamPanel = this.createIOParamTab();
            this.addTab("I/O Parameters", (Component)this.ioParamPanel);
        }
        JPanel processingParamPanel = new JPanel(new SpringLayout());
        this.checkDisplayOutput = new JCheckBox("Display execution output");
        this.checkDisplayOutput.setSelected(Boolean.parseBoolean(NbPreferences.forModule(Dialogs.class).get("sta.display.output", "false")));
        processingParamPanel.add(this.checkDisplayOutput);
        this.bottomPane = new JSplitPane(0);
        this.bottomPane.setTopComponent(this.createProcessingParamTab());
        this.console = new ConsolePane();
        if (this.checkDisplayOutput.isSelected()) {
            this.bottomPane.setBottomComponent(this.console);
            this.bottomPane.setDividerLocation(0.6);
        }
        processingParamPanel.add(this.bottomPane);
        this.checkDisplayOutput.addActionListener(e -> {
            if (!this.checkDisplayOutput.isSelected()) {
                this.bottomPane.remove(this.console);
            } else {
                this.bottomPane.setBottomComponent(this.console);
            }
            this.refreshDimension();
        });
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension((int)(screen.getWidth() / 3.0), (int)(screen.getHeight() / 2.5)));
        this.setMinimumSize(new Dimension(200, 200));
        SpringUtilities.makeCompactGrid(processingParamPanel, 2, 1, 2, 2, 2, 2);
        this.addTab("Processing Parameters", processingParamPanel);
        this.updateTargetProductFields();
    }

    public void refreshDimension() {
        this.bottomPane.setDividerLocation(0.6);
        this.bottomPane.revalidate();
        this.bottomPane.repaint();
    }

    public void prepareShow() {
        if (this.ioParamPanel != null) {
            this.ioParamPanel.initSourceProductSelectors();
        }
    }

    public void prepareHide() {
        if (this.ioParamPanel != null) {
            this.ioParamPanel.releaseSourceProductSelectors();
        }
    }

    public Product[] getSourceProducts() {
        ArrayList sourceProducts = new ArrayList();
        if (this.ioParamPanel != null) {
            ArrayList sourceProductSelectorList = this.ioParamPanel.getSourceProductSelectorList();
            sourceProducts.addAll(sourceProductSelectorList.stream().map(SourceProductSelector::getSelectedProduct).collect(Collectors.toList()));
        }
        return sourceProducts.toArray(new Product[sourceProducts.size()]);
    }

    public Object getPropertyValue(String propertyName) {
        Object result = null;
        if (this.propertySet.isPropertyDefined(propertyName)) {
            result = this.propertySet.getProperty(propertyName).getValue();
        }
        return result;
    }

    public File getTargetProductFile() {
        return this.targetProductSelector.getModel().getProductFile();
    }

    public boolean shouldDisplayOutput() {
        return this.checkDisplayOutput.isSelected();
    }

    private DefaultIOParametersPanel createIOParamTab() {
        DefaultIOParametersPanel ioPanel = new DefaultIOParametersPanel(this.appContext, (OperatorDescriptor)this.operatorDescriptor, this.targetProductSelector, !this.operatorDescriptor.isHandlingOutputName());
        ArrayList sourceProductSelectorList = ioPanel.getSourceProductSelectorList();
        if (!sourceProductSelectorList.isEmpty()) {
            SourceProductSelector sourceProductSelector = (SourceProductSelector)sourceProductSelectorList.get(0);
            sourceProductSelector.addSelectionChangeListener((SelectionChangeListener)new SourceProductChangeListener());
        }
        return ioPanel;
    }

    private JScrollPane createProcessingParamTab() {
        Arrays.stream(this.operatorDescriptor.getToolParameterDescriptors().toArray()).filter(p -> !((ToolParameterDescriptor)p).isTemplateParameter()).forEach(p -> {
            ToolParameterDescriptor param = (ToolParameterDescriptor)p;
            String label = param.getAlias();
            String propName = param.getName();
            if (label != null && !label.isEmpty() && this.propertySet.isPropertyDefined(propName)) {
                Property property = this.propertySet.getProperty(propName);
                property.getDescriptor().setDisplayName(label);
            }
        });
        Arrays.stream(this.operatorDescriptor.getToolParameterDescriptors().toArray()).filter(p -> ((ToolParameterDescriptor)p).isTemplateParameter()).forEach(p -> {
            TemplateParameterDescriptor param = (TemplateParameterDescriptor)p;
            this.propertySet.getProperty(param.getName()).getDescriptor().setAttribute("visible", (Object)false);
            Arrays.stream(param.getParameterDescriptors().toArray()).forEach(pp -> {
                ToolParameterDescriptor paramm = (ToolParameterDescriptor)pp;
                String label = paramm.getAlias();
                String propName = paramm.getName();
                if (label != null && !label.isEmpty() && this.propertySet.isPropertyDefined(propName)) {
                    Property property = this.propertySet.getProperty(propName);
                    property.getDescriptor().setDisplayName(label);
                }
            });
        });
        PropertyPane parametersPane = new PropertyPane(this.propertySet);
        JPanel parametersPanel = parametersPane.createPanel();
        parametersPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(evt.getNewValue() instanceof JTextField)) {
                    return;
                }
                JTextField field = (JTextField)evt.getNewValue();
                String text = field.getText();
                if (text != null && text.isEmpty()) {
                    field.setCaretPosition(text.length());
                }
            }
        });
        parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return new JScrollPane(parametersPanel);
    }

    private void updateTargetProductFields() {
        TargetProductSelectorModel model = this.targetProductSelector.getModel();
        Property property = this.propertySet.getProperty("targetProductFile");
        model.setSaveToFileSelected(false);
        if (!this.operatorDescriptor.isHandlingOutputName()) {
            Object value = property.getValue();
            if (value != null) {
                File file = this.operatorDescriptor.resolveVariables(new File(property.getValueAsText()));
                if (!file.isAbsolute()) {
                    file = new File(this.operatorDescriptor.getWorkingDir(), file.getAbsolutePath());
                }
                String productName = FileUtils.getFilenameWithoutExtension((File)file);
                if (this.fileExtension == null) {
                    this.fileExtension = FileUtils.getExtension((File)file);
                }
                model.setProductName(productName);
            }
        } else {
            try {
                model.setProductName("Output Product");
                if (property != null) {
                    property.setValue(null);
                }
                this.targetProductSelector.setEnabled(false);
                this.targetProductSelector.getSaveToFileCheckBox().setEnabled(false);
            }
            catch (ValidationException e) {
                Logger.getLogger(ToolExecutionForm.class.getName()).severe(e.getMessage());
            }
        }
        this.targetProductSelector.getProductDirTextField().setEnabled(false);
    }

    private class SourceProductChangeListener
    extends AbstractSelectionChangeListener {
        private static final String TARGET_PRODUCT_NAME_SUFFIX = "_processed";

        private SourceProductChangeListener() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            if (!ToolExecutionForm.this.operatorDescriptor.isHandlingOutputName()) {
                Property targetProperty = ToolExecutionForm.this.propertySet.getProperty("targetProductFile");
                Object value = targetProperty.getValue();
                String productName = "";
                Product selectedProduct = (Product)event.getSelection().getSelectedValue();
                if (selectedProduct != null) {
                    productName = FileUtils.getFilenameWithoutExtension((String)selectedProduct.getName());
                }
                TargetProductSelectorModel targetProductSelectorModel = ToolExecutionForm.this.targetProductSelector.getModel();
                productName = productName + TARGET_PRODUCT_NAME_SUFFIX;
                targetProductSelectorModel.setProductName(productName);
                if (value != null) {
                    File parent;
                    File oldValue = ToolExecutionForm.this.operatorDescriptor.resolveVariables(value instanceof File ? (File)value : new File((String)value));
                    if (ToolExecutionForm.this.fileExtension == null) {
                        ToolExecutionForm.this.fileExtension = ".tif";
                    }
                    File workingDir = ToolExecutionForm.this.operatorDescriptor.getWorkingDir();
                    File current = oldValue != null && (parent = oldValue.getParentFile()) != null ? new File(parent.getAbsolutePath(), productName + ToolExecutionForm.this.fileExtension) : new File(workingDir, productName + ToolExecutionForm.this.fileExtension);
                    ToolExecutionForm.this.propertySet.setValue("targetProductFile", (Object)current);
                } else {
                    File workingDir = ToolExecutionForm.this.operatorDescriptor.resolveVariables(ToolExecutionForm.this.operatorDescriptor.getWorkingDir());
                    try {
                        targetProperty.setValue((Object)new File(workingDir, productName + ".tif"));
                    }
                    catch (ValidationException validationException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

