/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.validators.NotEmptyValidator;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import org.esa.snap.core.gpf.descriptor.SystemDependentVariable;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.dialogs.AbstractAdapterEditor;
import org.esa.snap.ui.tooladapter.dialogs.Bundle;
import org.esa.snap.ui.tooladapter.model.OperationType;
import org.esa.snap.ui.tooladapter.validators.RegexFieldValidator;
import org.esa.snap.utils.SpringUtilities;

public class ToolAdapterEditorDialog
extends AbstractAdapterEditor {
    public ToolAdapterEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, OperationType operation) {
        super(appContext, parent, operatorDescriptor, operation);
    }

    public ToolAdapterEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, int newNameIndex, OperationType operation) {
        super(appContext, parent, operatorDescriptor, newNameIndex, operation);
    }

    @Override
    protected JSplitPane createMainPanel() {
        JSplitPane mainPanel = new JSplitPane(0);
        mainPanel.setOneTouchExpandable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double widthRatio = 0.5;
        this.formWidth = Math.max((int)((double)Math.min(screenSize.width, MAX_4K_WIDTH) * widthRatio), 720);
        double heightRatio = 0.6;
        int formHeight = Math.max((int)((double)Math.min(screenSize.height, MAX_4K_HEIGHT) * heightRatio), 580);
        this.getJDialog().setMinimumSize(new Dimension(this.formWidth + 16, formHeight + 72));
        JSplitPane topPanel = new JSplitPane(1);
        topPanel.setOneTouchExpandable(false);
        JPanel descriptorPanel = this.createDescriptorAndVariablesAndPreprocessingPanel();
        Dimension topPanelDimension = new Dimension((int)((double)(this.formWidth - 6) * 0.5), (int)((double)(formHeight - 6) * 0.75));
        descriptorPanel.setMinimumSize(topPanelDimension);
        descriptorPanel.setPreferredSize(topPanelDimension);
        topPanel.setLeftComponent(descriptorPanel);
        JPanel configurationPanel = this.createToolInfoPanel();
        configurationPanel.setMinimumSize(topPanelDimension);
        configurationPanel.setPreferredSize(topPanelDimension);
        topPanel.setRightComponent(configurationPanel);
        topPanel.setDividerLocation(0.5);
        JPanel bottomPannel = this.createParametersPanel();
        Dimension bottomPanelDimension = new Dimension(this.formWidth - 4, (int)((double)(formHeight - 6) * 0.25));
        bottomPannel.setMinimumSize(bottomPanelDimension);
        bottomPannel.setPreferredSize(bottomPanelDimension);
        mainPanel.setTopComponent(topPanel);
        mainPanel.setBottomComponent(bottomPannel);
        mainPanel.setDividerLocation(0.75);
        mainPanel.setPreferredSize(new Dimension(this.formWidth, formHeight));
        mainPanel.revalidate();
        return mainPanel;
    }

    @Override
    protected JPanel createDescriptorPanel() {
        JPanel descriptorPanel = new JPanel(new SpringLayout());
        TextFieldEditor textEditor = new TextFieldEditor();
        this.addValidatedTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Alias_Text(), "alias", "[^\\\\\\?%\\*:\\|\"<>\\./]*");
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_UniqueName_Text(), "name", true);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Label_Text(), "label", true);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Version_Text(), "version", true);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Copyright_Text(), "copyright", false);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Authors_Text(), "authors", false);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Description_Text(), "description", false);
        List<String> menus = this.getAvailableMenuOptions(null);
        this.addComboField(descriptorPanel, Bundle.CTL_Label_MenuLocation_Text(), "menuLocation", menus, true, true);
        TitledBorder title = BorderFactory.createTitledBorder(Bundle.CTL_Panel_OperatorDescriptor_Text());
        descriptorPanel.setBorder(title);
        SpringUtilities.makeCompactGrid(descriptorPanel, 8, 2, 2, 2, 2, 2);
        return descriptorPanel;
    }

    @Override
    protected JPanel createVariablesPanel() {
        JPanel variablesBorderPanel = new JPanel();
        BoxLayout layout = new BoxLayout(variablesBorderPanel, 3);
        variablesBorderPanel.setLayout(layout);
        variablesBorderPanel.setBorder(BorderFactory.createTitledBorder(Bundle.CTL_Panel_SysVar_Border_TitleText()));
        AbstractButton addVariableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addVariableButton.setText(Bundle.CTL_Button_Add_Variable_Text());
        addVariableButton.setAlignmentX(0.0f);
        addVariableButton.setMaximumSize(new Dimension(150, this.controlHeight));
        AbstractButton addDependentVariableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addDependentVariableButton.setText(Bundle.CTL_Button_Add_PDVariable_Text());
        addDependentVariableButton.setAlignmentX(0.0f);
        addDependentVariableButton.setMaximumSize(new Dimension(250, this.controlHeight));
        JPanel buttonsPannel = new JPanel(new SpringLayout());
        buttonsPannel.add(addVariableButton);
        buttonsPannel.add(addDependentVariableButton);
        SpringUtilities.makeCompactGrid(buttonsPannel, 1, 2, 0, 0, 0, 0);
        buttonsPannel.setAlignmentX(0.0f);
        variablesBorderPanel.add(buttonsPannel);
        this.varTable.setAutoResizeMode(3);
        this.varTable.setRowHeight(20);
        JScrollPane scrollPane = new JScrollPane(this.varTable);
        scrollPane.setAlignmentX(0.0f);
        variablesBorderPanel.add(scrollPane);
        variablesBorderPanel.setAlignmentX(0.0f);
        Dimension variablesPanelDimension = new Dimension((this.formWidth - 6) / 2 - 4, 130);
        variablesBorderPanel.setMinimumSize(variablesPanelDimension);
        variablesBorderPanel.setMaximumSize(variablesPanelDimension);
        variablesBorderPanel.setPreferredSize(variablesPanelDimension);
        addVariableButton.addActionListener(e -> {
            this.newOperatorDescriptor.getVariables().add(new SystemVariable("key", ""));
            this.varTable.revalidate();
        });
        addDependentVariableButton.addActionListener(e -> {
            this.newOperatorDescriptor.getVariables().add(new SystemDependentVariable("key", ""));
            this.varTable.revalidate();
        });
        return variablesBorderPanel;
    }

    @Override
    protected JPanel createPreProcessingPanel() {
        JPanel preProcessingPanel = new JPanel(new SpringLayout());
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor("preprocessorExternalTool");
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        preProcessingPanel.add(this.createCheckboxComponent("preprocessTool", editorComponent, this.newOperatorDescriptor.getPreprocessTool()));
        preProcessingPanel.add(new JLabel(Bundle.CTL_Label_PreprocessingTool_Text()));
        preProcessingPanel.add(editorComponent);
        propertyDescriptor = this.propertyContainer.getDescriptor("processingWriter");
        editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        JComponent writeComponent = this.createCheckboxComponent("writeForProcessing", editorComponent, this.newOperatorDescriptor.shouldWriteBeforeProcessing());
        preProcessingPanel.add(writeComponent);
        preProcessingPanel.add(new JLabel(Bundle.CTL_Label_WriteBefore_Text()));
        preProcessingPanel.add(editorComponent);
        TitledBorder title = BorderFactory.createTitledBorder(Bundle.CTL_Panel_PreProcessing_Border_TitleText());
        preProcessingPanel.setBorder(title);
        SpringUtilities.makeCompactGrid(preProcessingPanel, 2, 3, 2, 2, 2, 2);
        return preProcessingPanel;
    }

    @Override
    protected JPanel createToolInfoPanel() {
        JPanel container = new JPanel(new SpringLayout());
        JPanel configPanel = new JPanel(new SpringLayout());
        configPanel.setBorder(BorderFactory.createTitledBorder(Bundle.CTL_Panel_ConfigParams_Text()));
        JPanel panelToolFiles = new JPanel(new SpringLayout());
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor("mainToolFileLocation");
        propertyDescriptor.setValidator((Validator)new NotEmptyValidator());
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        panelToolFiles.add(new JLabel(Bundle.CTL_Label_ToolLocation_Text()));
        panelToolFiles.add(editorComponent);
        propertyDescriptor = this.propertyContainer.getDescriptor("workingDir");
        propertyDescriptor.setAttribute("directory", (Object)true);
        propertyDescriptor.setValidator((property, value) -> {
            if (value == null || value.toString().trim().isEmpty()) {
                throw new ValidationException(MessageFormat.format("Value for ''{0}'' must not be empty.", property.getDescriptor().getDisplayName()));
            }
        });
        editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        panelToolFiles.add(new JLabel(Bundle.CTL_Label_WorkDir_Text()));
        panelToolFiles.add(editorComponent);
        SpringUtilities.makeCompactGrid(panelToolFiles, 2, 2, 2, 2, 2, 2);
        configPanel.add(panelToolFiles);
        JPanel checkPanel = new JPanel(new SpringLayout());
        propertyDescriptor = this.propertyContainer.getDescriptor("isHandlingOutputName");
        editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        checkPanel.add(editorComponent);
        checkPanel.add(new JLabel("Tool produces the name of the output product"));
        SpringUtilities.makeCompactGrid(checkPanel, 1, 2, 2, 2, 2, 2);
        configPanel.add(checkPanel);
        JLabel label = new JLabel(Bundle.CTL_Label_CmdLineTemplate_Text());
        configPanel.add(label);
        JScrollPane scrollPane = new JScrollPane(this.createTemplateEditorField());
        configPanel.add(scrollPane);
        SpringUtilities.makeCompactGrid(configPanel, 4, 1, 2, 2, 2, 2);
        container.add(configPanel);
        container.add(this.createPatternsPanel());
        SpringUtilities.makeCompactGrid(container, 2, 1, 2, 2, 2, 2);
        return container;
    }

    @Override
    protected JPanel createPatternsPanel() {
        JPanel patternsPanel = new JPanel(new SpringLayout());
        patternsPanel.setBorder(BorderFactory.createTitledBorder(Bundle.CTL_Panel_OutputPattern_Border_TitleText()));
        TextFieldEditor textEditor = new TextFieldEditor();
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_ProgressPattern(), "progressPattern", false);
        this.propertyContainer.getDescriptor("progressPattern").setValidator((Validator)new RegexFieldValidator());
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_ErrorPattern(), "errorPattern", false);
        this.propertyContainer.getDescriptor("errorPattern").setValidator((Validator)new RegexFieldValidator());
        SpringUtilities.makeCompactGrid(patternsPanel, 2, 2, 2, 2, 2, 2);
        return patternsPanel;
    }

    @Override
    protected JPanel createParametersPanel() {
        JPanel paramsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(paramsPanel, 3);
        paramsPanel.setLayout(layout);
        AbstractButton addParamBut = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addParamBut.setAlignmentX(0.0f);
        addParamBut.setAlignmentY(0.0f);
        paramsPanel.add(addParamBut);
        int tableWidth = this.formWidth - 4;
        int[] widths = new int[]{27, 120, (int)((double)tableWidth * 0.25), (int)((double)tableWidth * 0.1), 100, (int)((double)tableWidth * 0.32), 30};
        for (int i = 0; i < widths.length; ++i) {
            this.paramsTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        JScrollPane tableScrollPane = new JScrollPane(this.paramsTable);
        tableScrollPane.setAlignmentX(0.0f);
        paramsPanel.add(tableScrollPane);
        addParamBut.addActionListener(e -> this.paramsTable.addParameterToTable((ToolParameterDescriptor)new TemplateParameterDescriptor("parameterName", String.class)));
        TitledBorder title = BorderFactory.createTitledBorder(Bundle.CTL_Panel_OpParams_Border_TitleText());
        paramsPanel.setBorder(title);
        return paramsPanel;
    }

    private JPanel createDescriptorAndVariablesAndPreprocessingPanel() {
        JPanel descriptorAndVariablesPanel = new JPanel(new SpringLayout());
        descriptorAndVariablesPanel.add(this.createDescriptorPanel());
        descriptorAndVariablesPanel.add(this.createVariablesPanel());
        descriptorAndVariablesPanel.add(this.createPreProcessingPanel());
        SpringUtilities.makeCompactGrid(descriptorAndVariablesPanel, 3, 1, 2, 2, 2, 2);
        return descriptorAndVariablesPanel;
    }
}

