/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;

@OperatorMetadata(alias="StoredGraph", description="Encapsulates an stored graph into an operator.", internal=true, autoWriteDisabled=true)
public class StoredGraphOp
extends Operator {
    @Parameter(label="Graph xml file", description="The file from which the graph is read.", notNull=true, notEmpty=true)
    private File file;
    GraphProcessor processor = null;
    GraphContext graphContext = null;

    public void initialize() throws OperatorException {
        this.setDummyTargetProduct();
        if (this.file == null) {
            throw new OperatorException("'file' parameter must be set");
        }
        try {
            FileReader reader = new FileReader(this.file);
            Graph graph = GraphIO.read((Reader)reader);
            this.processor = new GraphProcessor();
            this.graphContext = new GraphContext(graph);
        }
        catch (GraphException e) {
            throw new OperatorException((Throwable)new OperatorException("Invalid graph xml file. Try to edit it using the Graph Builder."));
        }
        catch (FileNotFoundException e) {
            throw new OperatorException("'file' not found");
        }
    }

    public void doExecute(ProgressMonitor pm) {
        this.processor.executeGraph(this.graphContext, pm);
    }

    public void dispose() {
        this.graphContext.dispose();
        super.dispose();
    }

    private void setDummyTargetProduct() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        this.setTargetProduct(product);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(StoredGraphOp.class);
        }
    }
}

