/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.IOException;
import junit.framework.TestCase;
import org.esa.snap.smart.configurator.JavaSystemInfos;
import org.esa.snap.smart.configurator.SystemInfos;

public class JavaSystemInfosTest
extends TestCase {
    private static SystemInfos systemInfos = JavaSystemInfos.getInstance((int)1, (int)2);

    public void testGetCPUs() {
        int nbCPUs = systemInfos.getNbCPUs();
        JavaSystemInfosTest.assertTrue((nbCPUs > 0 ? 1 : 0) != 0);
    }

    public void testMemory() {
        long ram = systemInfos.getRAM();
        JavaSystemInfosTest.assertTrue((ram > 0L ? 1 : 0) != 0);
    }

    public void testDisks() {
        String[] disks = systemInfos.getDisksNames();
        JavaSystemInfosTest.assertTrue((disks != null && disks.length > 0 ? 1 : 0) != 0);
    }

    public void testDiskSpeed() {
        String[] disksNames;
        for (String diskName : disksNames = systemInfos.getDisksNames()) {
            try {
                double readSpeed = systemInfos.getDiskReadSpeed(diskName);
                double writeSpeed = systemInfos.getDiskWriteSpeed(diskName);
                if ($assertionsDisabled || 0.0 != readSpeed && 0.0 != writeSpeed) continue;
                throw new AssertionError();
            }
            catch (IOException ex) {
                System.out.println("Can't read or write on " + diskName);
            }
        }
    }
}

