/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.esa.snap.core.util.SystemUtils;

public class DiskBenchmarker {
    public static final int DEFAULT_FILE_SIZE = 5;
    public static final int DEFAULT_NB_SAMPLES = 4;
    private String dirName;
    private int fileSize;
    private int nbSamples;
    private double readSpeed = 0.0;
    private double writeSpeed = 0.0;
    private static final double MILLISEC_IN_SEC = 1000.0;

    public DiskBenchmarker(String dirName) {
        this(dirName, 5, 4);
    }

    public DiskBenchmarker(String dirName, int fileSize, int nbSamples) {
        this.fileSize = fileSize;
        this.nbSamples = nbSamples;
        this.dirName = dirName;
    }

    public double getReadSpeed() throws IOException {
        if (0.0 == this.readSpeed) {
            this.performBenchMark();
        }
        return this.readSpeed;
    }

    public double getWriteSpeed() throws IOException {
        if (0.0 == this.writeSpeed) {
            this.performBenchMark();
        }
        return this.writeSpeed;
    }

    public void performBenchMark() throws IOException {
        String uniqueName = UUID.randomUUID().toString();
        try {
            this.writeSpeed = DiskBenchmarker.computeWriteSpeed(uniqueName, this.dirName, this.fileSize, this.nbSamples);
            this.readSpeed = DiskBenchmarker.computeReadSpeed(uniqueName, this.dirName, this.fileSize, this.nbSamples);
        }
        catch (IOException ex) {
            SystemUtils.LOG.warning("Could not read or write on target " + this.dirName);
            this.writeSpeed = -1.0;
            this.readSpeed = -1.0;
        }
        finally {
            DiskBenchmarker.cleanup(uniqueName, this.dirName, this.nbSamples);
        }
    }

    private static double computeWriteSpeed(String uniqueName, String dirName, int fileSize, int nbSamples) throws IOException {
        byte[] dataToWrite = new byte[fileSize * 1024 * 1024];
        new Random().nextBytes(dataToWrite);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < nbSamples; ++i) {
            String fileName = dirName + File.separator + uniqueName + i;
            FileOutputStream outputStream = new FileOutputStream(fileName);
            outputStream.write(dataToWrite);
            outputStream.close();
        }
        long endTime = System.currentTimeMillis();
        long writeTimeMili = endTime - startTime;
        double writeTimeSec = (double)writeTimeMili / 1000.0;
        long totalSize = fileSize * nbSamples;
        return (double)totalSize / writeTimeSec;
    }

    private static double computeReadSpeed(String uniqueName, String dirName, int fileSize, int nbSamples) throws IOException {
        long startTime = System.currentTimeMillis();
        int numberOfBytesToRead = fileSize * 1024 * 1024;
        byte[] dataToRead = new byte[numberOfBytesToRead];
        for (int i = 0; i < nbSamples; ++i) {
            String fileName = dirName + File.separator + uniqueName + i;
            FileInputStream inputStream = new FileInputStream(fileName);
            int readResult = inputStream.read(dataToRead);
            if (readResult != numberOfBytesToRead) {
                SystemUtils.LOG.warning("Did not all of " + fileName);
            }
            inputStream.close();
        }
        long endTime = System.currentTimeMillis();
        long readTimeMilliSec = endTime - startTime;
        double readTimeSec = (double)readTimeMilliSec / 1000.0;
        long totalSize = fileSize * nbSamples;
        return (double)totalSize / readTimeSec;
    }

    private static void cleanup(String uniqueName, String dirName, int nbSamples) throws IOException {
        for (int i = 0; i < nbSamples; ++i) {
            String fileName = dirName + File.separator + uniqueName + i;
            File file = new File(fileName);
            if (file.delete()) continue;
            SystemUtils.LOG.warning("Could not delete temporary benchmark file " + fileName);
        }
    }
}

