/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import org.esa.snap.runtime.EnginePreferences;
import org.junit.Assert;
import org.junit.Test;

public class EnginePreferencesTest {
    @Test
    public void testGetPutRemove() throws Exception {
        EnginePreferences test = new EnginePreferences("test");
        String KEY = "test.key";
        Assert.assertEquals(null, (Object)test.get(KEY, null));
        Assert.assertEquals((Object)"A", (Object)test.get(KEY, "A"));
        Assert.assertEquals(null, (Object)test.getProperties().getProperty(KEY));
        test.put(KEY, "B");
        Assert.assertEquals((Object)"B", (Object)test.get(KEY, null));
        Assert.assertEquals((Object)"B", (Object)test.get(KEY, "A"));
        Assert.assertEquals((Object)"B", (Object)test.getProperties().getProperty(KEY));
        test.remove(KEY);
        Assert.assertEquals(null, (Object)test.get(KEY, null));
        Assert.assertEquals((Object)"A", (Object)test.get(KEY, "A"));
        Assert.assertEquals(null, (Object)test.getProperties().getProperty(KEY));
    }

    @Test
    public void testRecognizedSystemProperties() throws Exception {
        EnginePreferences test = new EnginePreferences("test2");
        String KEY = "test2.key";
        try {
            Assert.assertNull((Object)System.getProperty(KEY));
            test.put(KEY, "B");
            Assert.assertEquals(null, (Object)System.getProperty(KEY));
            Assert.assertEquals((Object)"B", (Object)test.get(KEY, null));
            Assert.assertEquals((Object)"B", (Object)test.get(KEY, "A"));
            Assert.assertEquals((Object)"B", (Object)test.getProperties().getProperty(KEY));
            System.setProperty(KEY, "C");
            Assert.assertEquals((Object)"C", (Object)System.getProperty(KEY));
            Assert.assertEquals((Object)"C", (Object)test.get(KEY, null));
            Assert.assertEquals((Object)"C", (Object)test.get(KEY, "A"));
            Assert.assertEquals((Object)"B", (Object)test.getProperties().getProperty(KEY));
            test.put(KEY, "D");
            Assert.assertEquals((Object)"D", (Object)System.getProperty(KEY));
            Assert.assertEquals((Object)"D", (Object)test.get(KEY, null));
            Assert.assertEquals((Object)"D", (Object)test.get(KEY, "A"));
            Assert.assertEquals((Object)"D", (Object)test.getProperties().getProperty(KEY));
        }
        finally {
            System.clearProperty(KEY);
        }
    }

    @Test
    public void testIgnoredSystemProperties() throws Exception {
        EnginePreferences test = new EnginePreferences("test3");
        String KEY = "org.esa.snap.test3.key";
        try {
            Assert.assertNull((Object)System.getProperty(KEY));
            Assert.assertEquals(null, (Object)System.getProperty(KEY));
            Assert.assertEquals(null, (Object)test.get(KEY, null));
            Assert.assertEquals((Object)"A", (Object)test.get(KEY, "A"));
            Assert.assertEquals(null, (Object)test.getProperties().getProperty(KEY));
            System.setProperty(KEY, "E");
            Assert.assertEquals((Object)"E", (Object)System.getProperty(KEY));
            Assert.assertEquals(null, (Object)test.get(KEY, null));
            Assert.assertEquals((Object)"A", (Object)test.get(KEY, "A"));
            Assert.assertEquals(null, (Object)test.getProperties().getProperty(KEY));
        }
        finally {
            System.clearProperty(KEY);
        }
    }
}

