/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.esa.snap.runtime.Config;
import org.esa.snap.runtime.EngineConfigTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTest {
    @Before
    public void setUp() throws Exception {
        Config.instance((String)"bibo").clear();
        System.getProperties().stringPropertyNames().stream().filter(name -> name.startsWith("bibo.")).forEach(System::clearProperty);
    }

    @Test
    public void testLoadStandard() throws Exception {
        Assert.assertFalse((boolean)Config.instance((String)"bibo").loaded());
        Config.instance((String)"bibo").load();
        Assert.assertTrue((boolean)Config.instance((String)"bibo").loaded());
    }

    @Test
    public void testLoadCustom() throws Exception {
        Path configFile = Paths.get(EngineConfigTest.class.getResource("bibo-extra.properties").toURI());
        Assert.assertFalse((boolean)Config.instance((String)"bibo").loaded());
        Config.instance((String)"bibo").load(configFile);
        Assert.assertFalse((boolean)Config.instance((String)"bibo").loaded());
        Assert.assertEquals((long)34L, (long)Config.instance((String)"bibo").preferences().getInt("bibo.a", 0));
        Assert.assertEquals((double)0.41, (double)Config.instance((String)"bibo").preferences().getDouble("bibo.b", 0.0), (double)1.0E-10);
        Assert.assertEquals((Object)true, (Object)Config.instance((String)"bibo").preferences().getBoolean("bibo.c", false));
        Assert.assertEquals((Object)"ABC", (Object)Config.instance((String)"bibo").preferences().get("bibo.d", null));
    }
}

