/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.rtp;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.rtp.BandDescriptor;
import org.esa.snap.dataio.rtp.ProductDescriptor;
import org.esa.snap.dataio.rtp.RawTiledPyramidsProductFileFilter;
import org.esa.snap.dataio.rtp.RawTiledPyramidsProductReader;
import org.esa.snap.dataio.rtp.RawTiledPyramidsProductWriter;

public class RawTiledPyramidsProductCodecSpi
implements ProductReaderPlugIn,
ProductWriterPlugIn {
    public static final String HEADER_NAME = "product.xml";
    public static final String FORMAT_NAME = "RAW-TILED-PYRAMIDS";
    public static final String FORMAT_DESCRIPTION = "Raw, tiled pyramids product (experimental)";
    static final String[] NO_FILE_EXTENSIONS = new String[0];

    public DecodeQualification getDecodeQualification(Object input) {
        File headerFile = RawTiledPyramidsProductCodecSpi.getHeaderFile(input);
        return headerFile.isFile() ? DecodeQualification.INTENDED : DecodeQualification.UNABLE;
    }

    public EncodeQualification getEncodeQualification(Product product) {
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return new EncodeQualification(EncodeQualification.Preservation.PARTIAL, "All metadata will be lost!");
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public Class[] getOutputTypes() {
        return this.getInputTypes();
    }

    public ProductReader createReaderInstance() {
        return new RawTiledPyramidsProductReader(this);
    }

    public ProductWriter createWriterInstance() {
        return new RawTiledPyramidsProductWriter(this);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return NO_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return FORMAT_DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return new RawTiledPyramidsProductFileFilter();
    }

    static boolean isProductDir(File dir) {
        return new File(dir, HEADER_NAME).isFile();
    }

    static File getHeaderFile(Object input) {
        File file = new File(input.toString());
        if (HEADER_NAME.equals(file.getName())) {
            return file;
        }
        return new File(file, HEADER_NAME);
    }

    static XStream createXStream() {
        XStream xStream = new XStream();
        xStream.setClassLoader(RawTiledPyramidsProductCodecSpi.class.getClassLoader());
        xStream.processAnnotations(new Class[]{ProductDescriptor.class, BandDescriptor.class});
        return xStream;
    }
}

