/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util.internal;

import java.awt.GraphicsEnvironment;
import org.esa.snap.rcp.util.ContextGlobalExtender;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.util.internal.DefaultSelectionSupport;
import org.esa.snap.ui.product.ProductSceneView;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.openide.util.Utilities;

public class DefaultSelectionSupportTest {
    @Test
    public void testSingleSelection() throws Exception {
        Assume.assumeFalse((boolean)GraphicsEnvironment.isHeadless());
        ContextGlobalExtender globalExtender = (ContextGlobalExtender)Utilities.actionsGlobalContext().lookup(ContextGlobalExtender.class);
        DefaultSelectionSupport selectionChangeSupport = new DefaultSelectionSupport(ProductSceneView.class);
        MySelectionChangeHandler changeListener = new MySelectionChangeHandler();
        selectionChangeSupport.addHandler((SelectionSupport.Handler)changeListener);
        ProductSceneView sceneView1 = (ProductSceneView)Mockito.mock(ProductSceneView.class);
        globalExtender.put((Object)"view", (Object)sceneView1);
        Assert.assertEquals((long)1L, (long)changeListener.count);
        globalExtender.remove((Object)"view");
        Assert.assertEquals((long)0L, (long)changeListener.count);
    }

    @Test
    public void testMultiSelection() throws Exception {
        Assume.assumeFalse((boolean)GraphicsEnvironment.isHeadless());
        ContextGlobalExtender globalExtender = (ContextGlobalExtender)Utilities.actionsGlobalContext().lookup(ContextGlobalExtender.class);
        DefaultSelectionSupport selectionChangeSupport = new DefaultSelectionSupport(ProductSceneView.class);
        MySelectionChangeHandler changeListener = new MySelectionChangeHandler();
        selectionChangeSupport.addHandler((SelectionSupport.Handler)changeListener);
        ProductSceneView sceneView1 = (ProductSceneView)Mockito.mock(ProductSceneView.class);
        ProductSceneView sceneView2 = (ProductSceneView)Mockito.mock(ProductSceneView.class);
        ProductSceneView sceneView3 = (ProductSceneView)Mockito.mock(ProductSceneView.class);
        globalExtender.put((Object)"view1", (Object)sceneView1);
        Assert.assertEquals((long)1L, (long)changeListener.count);
        globalExtender.put((Object)"view2", (Object)sceneView2);
        Assert.assertEquals((long)2L, (long)changeListener.count);
        globalExtender.put((Object)"view3", (Object)sceneView3);
        Assert.assertEquals((long)3L, (long)changeListener.count);
        globalExtender.remove((Object)"view2");
        Assert.assertEquals((long)2L, (long)changeListener.count);
    }

    private static class MySelectionChangeHandler
    implements SelectionSupport.Handler<ProductSceneView> {
        volatile int count = 0;

        private MySelectionChangeHandler() {
        }

        public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
            if (oldValue != null) {
                --this.count;
            }
            if (newValue != null) {
                ++this.count;
            }
        }
    }
}

