/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.rcp.util.DateTimePickerCellEditor;
import org.junit.Assert;
import org.junit.Test;

public class DateTimePickerCellEditorTest {
    private static final DateFormat DATE_FORMAT = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final DateFormat TIME_FORMAT = ProductData.UTC.createDateFormat((String)"HH:mm:ss");

    @Test
    public void testDateFormatTimeZone() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        DateTimePickerCellEditor editor = new DateTimePickerCellEditor(DATE_FORMAT, TIME_FORMAT);
        DateFormat[] formats = editor.getFormats();
        Assert.assertEquals((long)1L, (long)formats.length);
        Assert.assertSame((Object)DATE_FORMAT, (Object)formats[0]);
        Assert.assertEquals((Object)DATE_FORMAT, (Object)formats[0]);
        Assert.assertEquals((Object)TimeZone.getTimeZone("UTC"), (Object)formats[0].getTimeZone());
        Assert.assertSame((Object)TIME_FORMAT, (Object)editor.getTimeFormat());
        Assert.assertEquals((Object)TimeZone.getTimeZone("UTC"), (Object)editor.getTimeFormat().getTimeZone());
    }
}

