/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.TestCase;
import org.esa.snap.rcp.statistics.XYImagePlot;

public class XYImagePlotTest
extends TestCase {
    public void testDefaultValues() {
        XYImagePlot imagePlot = new XYImagePlot();
        XYImagePlotTest.assertNull((Object)imagePlot.getImage());
        XYImagePlotTest.assertNull((Object)imagePlot.getImageDataBounds());
        XYImagePlotTest.assertNull((Object)imagePlot.getDataset());
        XYImagePlotTest.assertNotNull((Object)imagePlot.getDomainAxis());
        XYImagePlotTest.assertNotNull((Object)imagePlot.getRangeAxis());
        XYImagePlotTest.assertTrue((boolean)imagePlot.isDomainGridlinesVisible());
        XYImagePlotTest.assertTrue((boolean)imagePlot.isRangeGridlinesVisible());
    }

    public void testImage() {
        XYImagePlot imagePlot = new XYImagePlot();
        BufferedImage image = new BufferedImage(16, 9, 2);
        imagePlot.setImage(image);
        XYImagePlotTest.assertSame((Object)image, (Object)imagePlot.getImage());
        XYImagePlotTest.assertEquals((Object)new Rectangle(0, 0, 16, 9), (Object)imagePlot.getImageDataBounds());
        BufferedImage otherImage = new BufferedImage(4, 3, 2);
        imagePlot.setImage(otherImage);
        XYImagePlotTest.assertSame((Object)otherImage, (Object)imagePlot.getImage());
        XYImagePlotTest.assertEquals((Object)new Rectangle(0, 0, 16, 9), (Object)imagePlot.getImageDataBounds());
    }

    public void testImageDataBounds() {
        XYImagePlot imagePlot = new XYImagePlot();
        XYImagePlotTest.assertNull((Object)imagePlot.getDataset());
        Rectangle bounds = new Rectangle(0, 2, 20, 40);
        imagePlot.setImageDataBounds((Rectangle2D)bounds);
        XYImagePlotTest.assertNotSame((Object)bounds, (Object)imagePlot.getImageDataBounds());
        XYImagePlotTest.assertEquals((Object)bounds, (Object)imagePlot.getImageDataBounds());
        XYImagePlotTest.assertEquals((double)0.0, (double)imagePlot.getDomainAxis().getLowerBound(), (double)1.0E-10);
        XYImagePlotTest.assertEquals((double)20.0, (double)imagePlot.getDomainAxis().getUpperBound(), (double)1.0E-10);
        XYImagePlotTest.assertEquals((double)2.0, (double)imagePlot.getRangeAxis().getLowerBound(), (double)1.0E-10);
        XYImagePlotTest.assertEquals((double)42.0, (double)imagePlot.getRangeAxis().getUpperBound(), (double)1.0E-10);
        XYImagePlotTest.assertNotNull((Object)imagePlot.getDataset());
    }

    public void testImageSourceArea() {
        XYImagePlot imagePlot = new XYImagePlot();
        BufferedImage image = new BufferedImage(200, 100, 2);
        imagePlot.setImage(image);
        imagePlot.setImageDataBounds((Rectangle2D)new Rectangle2D.Double(-1.0, 0.0, 2.0, 1.0));
        imagePlot.getDomainAxis().setRange(-0.5, 0.5);
        imagePlot.getRangeAxis().setRange(0.25, 0.75);
        Rectangle area = imagePlot.getImageSourceArea();
        XYImagePlotTest.assertEquals((int)50, (int)area.x);
        XYImagePlotTest.assertEquals((int)25, (int)area.y);
        XYImagePlotTest.assertEquals((int)100, (int)area.width);
        XYImagePlotTest.assertEquals((int)50, (int)area.height);
        imagePlot.getDomainAxis().setRange(0.0, 0.1);
        imagePlot.getRangeAxis().setRange(0.5, 0.6);
        area = imagePlot.getImageSourceArea();
        XYImagePlotTest.assertEquals((int)100, (int)area.x);
        XYImagePlotTest.assertEquals((int)40, (int)area.y);
        XYImagePlotTest.assertEquals((int)10, (int)area.width);
        XYImagePlotTest.assertEquals((int)10, (int)area.height);
        imagePlot.getDomainAxis().setRange(0.5, 1.0);
        imagePlot.getRangeAxis().setRange(0.7, 1.0);
        area = imagePlot.getImageSourceArea();
        XYImagePlotTest.assertEquals((int)150, (int)area.x);
        XYImagePlotTest.assertEquals((int)0, (int)area.y);
        XYImagePlotTest.assertEquals((int)50, (int)area.width);
        XYImagePlotTest.assertEquals((int)30, (int)area.height);
    }
}

