/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.rcp.statistics.StatisticsUtils;
import org.junit.Assert;
import org.junit.Test;

public class StatisticsUtilsTest {
    @Test
    public void testCreateTransectProfileText_Byte() throws IOException {
        Product product = new Product("X", "Y", 2, 1);
        Band node = product.addBand("name", 10);
        node.setSynthetic(true);
        node.setNoDataValue(0.0);
        node.setNoDataValueUsed(true);
        byte[] data = new byte[product.getSceneRasterWidth() * product.getSceneRasterHeight()];
        Arrays.fill(data, (byte)1);
        data[0] = 0;
        node.setData(ProductData.createInstance((byte[])data));
        Line2D.Float shape = new Line2D.Float(0.5f, 0.5f, 1.5f, 0.5f);
        TransectProfileData profileData = node.createTransectProfileData((Shape)shape);
        String profileDataString = StatisticsUtils.TransectProfile.createTransectProfileText((RasterDataNode)node, (TransectProfileData)profileData);
        Assert.assertTrue((boolean)profileDataString.contains("NaN"));
        Assert.assertFalse((boolean)profileDataString.toLowerCase().contains("no data"));
    }

    @Test
    public void testCreateTransectProfileText_Float() throws IOException {
        Product product = new Product("X", "Y", 2, 1);
        Band node = product.addBand("name", 30);
        node.setSynthetic(true);
        float[] data = new float[product.getSceneRasterWidth() * product.getSceneRasterHeight()];
        Arrays.fill(data, 1.0f);
        data[0] = Float.NaN;
        node.setData(ProductData.createInstance((float[])data));
        Line2D.Float shape = new Line2D.Float(0.5f, 0.5f, 1.5f, 0.5f);
        TransectProfileData profileData = node.createTransectProfileData((Shape)shape);
        String profileDataString = StatisticsUtils.TransectProfile.createTransectProfileText((RasterDataNode)node, (TransectProfileData)profileData);
        Assert.assertTrue((boolean)profileDataString.contains("NaN"));
        Assert.assertFalse((boolean)profileDataString.toLowerCase().contains("no data"));
    }
}

