/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Shape;
import java.awt.geom.Path2D;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TransectProfileData;
import org.esa.snap.core.datamodel.TransectProfileDataBuilder;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.statistics.ProfileDataTableModel;
import org.esa.snap.rcp.statistics.ProfilePlotPanel;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;

public class ProfileDataTableModelTest {
    private Product product;
    private Band band;
    private Path2D path;
    private ProfilePlotPanel.DataSourceConfig dataSourceConfig;

    @Before
    public void setUp() throws Exception {
        this.path = new Path2D.Double();
        this.path.moveTo(0.0, 0.0);
        this.path.lineTo(3.0, 0.0);
        this.path.lineTo(0.0, 3.0);
        this.path.lineTo(3.0, 3.0);
        this.product = new Product("p", "t", 4, 4);
        this.band = this.product.addBand("b", "4 * (Y-0.5) + (X-0.5) + 0.1");
        this.dataSourceConfig = new ProfilePlotPanel.DataSourceConfig();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("ft");
        ftb.add("lat", Double.class);
        ftb.add("lon", Double.class);
        ftb.add("data", Double.class);
        SimpleFeatureType ft = ftb.buildFeatureType();
        DefaultFeatureCollection fc = new DefaultFeatureCollection("id", ft);
        fc.add((SimpleFeature)new SimpleFeatureImpl(new Object[]{0, 0, 0.3}, ft, (FeatureId)new FeatureIdImpl("id1"), false));
        fc.add((SimpleFeature)new SimpleFeatureImpl(new Object[]{0, 0, 0.5}, ft, (FeatureId)new FeatureIdImpl("id2"), false));
        fc.add((SimpleFeature)new SimpleFeatureImpl(new Object[]{0, 0, 0.7}, ft, (FeatureId)new FeatureIdImpl("id3"), false));
        fc.add((SimpleFeature)new SimpleFeatureImpl(new Object[]{0, 0, 0.1}, ft, (FeatureId)new FeatureIdImpl("id4"), false));
        this.dataSourceConfig.pointDataSource = new VectorDataNode("vd", (FeatureCollection)fc);
        this.dataSourceConfig.dataField = ft.getDescriptor("data");
        this.dataSourceConfig.boxSize = 1;
        this.dataSourceConfig.computeInBetweenPoints = true;
    }

    @Test
    public void testModelWithCorrData() throws Exception {
        TransectProfileData profileData = new TransectProfileDataBuilder().raster((RasterDataNode)this.band).path((Shape)this.path).boxSize(this.dataSourceConfig.boxSize).build();
        ProfileDataTableModel tableModel = new ProfileDataTableModel(this.band.getName(), profileData, this.dataSourceConfig);
        Assert.assertEquals((long)10L, (long)tableModel.getColumnCount());
        Assert.assertEquals((Object)"pixel_no", (Object)tableModel.getColumnName(0));
        Assert.assertEquals((Object)"pixel_x", (Object)tableModel.getColumnName(1));
        Assert.assertEquals((Object)"pixel_y", (Object)tableModel.getColumnName(2));
        Assert.assertEquals((Object)"latitude", (Object)tableModel.getColumnName(3));
        Assert.assertEquals((Object)"longitude", (Object)tableModel.getColumnName(4));
        Assert.assertEquals((Object)"b_mean", (Object)tableModel.getColumnName(5));
        Assert.assertEquals((Object)"b_sigma", (Object)tableModel.getColumnName(6));
        Assert.assertEquals((Object)"data_ref", (Object)tableModel.getColumnName(7));
        Assert.assertEquals((Object)"lat_ref", (Object)tableModel.getColumnName(8));
        Assert.assertEquals((Object)"lon_ref", (Object)tableModel.getColumnName(9));
        Assert.assertEquals((long)10L, (long)tableModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)tableModel.getValueAt(0, 0));
        Assert.assertEquals((Object)0.0, (Object)tableModel.getValueAt(0, 1));
        Assert.assertEquals((Object)0.0, (Object)tableModel.getValueAt(0, 2));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(0, 3));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(0, 4));
        Assert.assertEquals((Object)Float.valueOf(0.1f), (Object)tableModel.getValueAt(0, 5));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)tableModel.getValueAt(0, 6));
        Assert.assertEquals((Object)0.3, (Object)tableModel.getValueAt(0, 7));
        Assert.assertEquals((Object)0, (Object)tableModel.getValueAt(0, 8));
        Assert.assertEquals((Object)0, (Object)tableModel.getValueAt(0, 9));
        Assert.assertEquals((Object)2, (Object)tableModel.getValueAt(1, 0));
        Assert.assertEquals((Object)1.0, (Object)tableModel.getValueAt(1, 1));
        Assert.assertEquals((Object)0.0, (Object)tableModel.getValueAt(1, 2));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 3));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 4));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)tableModel.getValueAt(1, 5));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)tableModel.getValueAt(1, 6));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 7));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 8));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 9));
        Assert.assertEquals((Object)10, (Object)tableModel.getValueAt(9, 0));
        Assert.assertEquals((Object)3.0, (Object)tableModel.getValueAt(9, 1));
        Assert.assertEquals((Object)3.0, (Object)tableModel.getValueAt(9, 2));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(9, 3));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(9, 4));
        Assert.assertEquals((Object)Float.valueOf(15.1f), (Object)tableModel.getValueAt(9, 5));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)tableModel.getValueAt(9, 6));
        Assert.assertEquals((Object)0.1, (Object)tableModel.getValueAt(9, 7));
        Assert.assertEquals((Object)0, (Object)tableModel.getValueAt(9, 8));
        Assert.assertEquals((Object)0, (Object)tableModel.getValueAt(9, 9));
    }

    @Test
    public void testModelWithoutCorrData() throws Exception {
        this.dataSourceConfig.dataField = null;
        this.dataSourceConfig.boxSize = 1;
        TransectProfileData profileData = new TransectProfileDataBuilder().raster((RasterDataNode)this.band).path((Shape)this.path).boxSize(this.dataSourceConfig.boxSize).build();
        ProfileDataTableModel tableModel = new ProfileDataTableModel(this.band.getName(), profileData, this.dataSourceConfig);
        Assert.assertEquals((long)8L, (long)tableModel.getColumnCount());
        Assert.assertEquals((Object)"pixel_no", (Object)tableModel.getColumnName(0));
        Assert.assertEquals((Object)"pixel_x", (Object)tableModel.getColumnName(1));
        Assert.assertEquals((Object)"pixel_y", (Object)tableModel.getColumnName(2));
        Assert.assertEquals((Object)"latitude", (Object)tableModel.getColumnName(3));
        Assert.assertEquals((Object)"longitude", (Object)tableModel.getColumnName(4));
        Assert.assertEquals((Object)"b_mean", (Object)tableModel.getColumnName(5));
        Assert.assertEquals((Object)"b_sigma", (Object)tableModel.getColumnName(6));
        Assert.assertEquals((Object)"", (Object)tableModel.getColumnName(7));
        Assert.assertEquals((long)10L, (long)tableModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)tableModel.getValueAt(0, 0));
        Assert.assertEquals((Object)0.0, (Object)tableModel.getValueAt(0, 1));
        Assert.assertEquals((Object)0.0, (Object)tableModel.getValueAt(0, 2));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(0, 3));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(0, 4));
        Assert.assertEquals((Object)Float.valueOf(0.1f), (Object)tableModel.getValueAt(0, 5));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)tableModel.getValueAt(0, 6));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(0, 7));
        Assert.assertEquals((Object)2, (Object)tableModel.getValueAt(1, 0));
        Assert.assertEquals((Object)1.0, (Object)tableModel.getValueAt(1, 1));
        Assert.assertEquals((Object)0.0, (Object)tableModel.getValueAt(1, 2));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 3));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 4));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)tableModel.getValueAt(1, 5));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)tableModel.getValueAt(1, 6));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(1, 7));
        Assert.assertEquals((Object)10, (Object)tableModel.getValueAt(9, 0));
        Assert.assertEquals((Object)3.0, (Object)tableModel.getValueAt(9, 1));
        Assert.assertEquals((Object)3.0, (Object)tableModel.getValueAt(9, 2));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(9, 3));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(9, 4));
        Assert.assertEquals((Object)Float.valueOf(15.1f), (Object)tableModel.getValueAt(9, 5));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)tableModel.getValueAt(9, 6));
        Assert.assertEquals(null, (Object)tableModel.getValueAt(9, 7));
    }

    @Test
    public void testModelCsv() throws Exception {
        TransectProfileData profileData = new TransectProfileDataBuilder().raster((RasterDataNode)this.band).path((Shape)this.path).boxSize(this.dataSourceConfig.boxSize).build();
        ProfileDataTableModel tableModel = new ProfileDataTableModel(this.band.getName(), profileData, this.dataSourceConfig);
        String csv = tableModel.toCsv();
        Assert.assertEquals((Object)"pixel_no\tpixel_x\tpixel_y\tlatitude\tlongitude\tb_mean\tb_sigma\tdata_ref\tlat_ref\tlon_ref\n1\t0.0\t0.0\t\t\t0.1\t0.0\t0.3\t0\t0\n2\t1.0\t0.0\t\t\t1.1\t0.0\t\t\t\n3\t2.0\t0.0\t\t\t2.1\t0.0\t\t\t\n4\t3.0\t0.0\t\t\t3.1\t0.0\t0.5\t0\t0\n5\t2.0\t1.0\t\t\t6.1\t0.0\t\t\t\n6\t1.0\t2.0\t\t\t9.1\t0.0\t\t\t\n7\t0.0\t3.0\t\t\t12.1\t0.0\t0.7\t0\t0\n8\t1.0\t3.0\t\t\t13.1\t0.0\t\t\t\n9\t2.0\t3.0\t\t\t14.1\t0.0\t\t\t\n10\t3.0\t3.0\t\t\t15.1\t0.0\t0.1\t0\t0\n", (Object)csv);
    }

    @Test
    public void testModelCsvNoInBetweenPoints() throws Exception {
        this.dataSourceConfig.computeInBetweenPoints = false;
        TransectProfileData profileData = new TransectProfileDataBuilder().raster((RasterDataNode)this.band).path((Shape)this.path).boxSize(this.dataSourceConfig.boxSize).build();
        ProfileDataTableModel tableModel = new ProfileDataTableModel(this.band.getName(), profileData, this.dataSourceConfig);
        String csv = tableModel.toCsv();
        Assert.assertEquals((Object)"pixel_no\tpixel_x\tpixel_y\tlatitude\tlongitude\tb_mean\tb_sigma\tdata_ref\tlat_ref\tlon_ref\n1\t0.0\t0.0\t\t\t0.1\t0.0\t0.3\t0\t0\n4\t3.0\t0.0\t\t\t3.1\t0.0\t0.5\t0\t0\n7\t0.0\t3.0\t\t\t12.1\t0.0\t0.7\t0\t0\n10\t3.0\t3.0\t\t\t15.1\t0.0\t0.1\t0\t0\n", (Object)csv);
    }
}

