/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.util.List;
import org.esa.snap.rcp.statistics.CustomLogarithmicAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.ui.RectangleEdge;
import org.junit.Assert;
import org.junit.Test;

public class CustomLogarithmicAxisTest {
    @Test
    public void testRefreshTicks() throws Exception {
        CustomLogarithmicAxis testAxis = new CustomLogarithmicAxis("testAxis");
        testAxis.setRange(0.3, 300.0);
        List ticks = testAxis.refreshTicks(RectangleEdge.TOP, 1);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)28L, (long)ticks.size());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(0)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(1)).getText());
        Assert.assertEquals((Object)"1", (Object)((NumberTick)ticks.get(7)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(9)).getText());
        Assert.assertEquals((Object)"10", (Object)((NumberTick)ticks.get(16)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(18)).getText());
        Assert.assertEquals((Object)"100", (Object)((NumberTick)ticks.get(25)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(26)).getText());
        testAxis.setRange(0.3, 30.0);
        ticks = testAxis.refreshTicks(RectangleEdge.TOP, 1);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)19L, (long)ticks.size());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(0)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(1)).getText());
        Assert.assertEquals((Object)"1", (Object)((NumberTick)ticks.get(7)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(9)).getText());
        Assert.assertEquals((Object)"10", (Object)((NumberTick)ticks.get(16)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(18)).getText());
        testAxis.setRange(0.3, 3.0);
        ticks = testAxis.refreshTicks(RectangleEdge.TOP, 1);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)10L, (long)ticks.size());
        Assert.assertEquals((double)0.3, (double)((NumberTick)ticks.get(0)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.4, (double)((NumberTick)ticks.get(1)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.5, (double)((NumberTick)ticks.get(2)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.6, (double)((NumberTick)ticks.get(3)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.7, (double)((NumberTick)ticks.get(4)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.8, (double)((NumberTick)ticks.get(5)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.9, (double)((NumberTick)ticks.get(6)).getValue(), (double)1.0E-6);
        Assert.assertEquals((Object)"1", (Object)((NumberTick)ticks.get(7)).getText());
        Assert.assertEquals((Object)"2", (Object)((NumberTick)ticks.get(8)).getText());
        Assert.assertEquals((Object)"3", (Object)((NumberTick)ticks.get(9)).getText());
        testAxis.setRange(0.3, 0.8);
        ticks = testAxis.refreshTicks(RectangleEdge.TOP, 1);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)6L, (long)ticks.size());
        Assert.assertEquals((double)0.3, (double)((NumberTick)ticks.get(0)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.4, (double)((NumberTick)ticks.get(1)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.5, (double)((NumberTick)ticks.get(2)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.6, (double)((NumberTick)ticks.get(3)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.7, (double)((NumberTick)ticks.get(4)).getValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.8, (double)((NumberTick)ticks.get(5)).getValue(), (double)1.0E-6);
    }

    @Test
    public void testRefreshTicksForNegativeAxisRange() throws Exception {
        CustomLogarithmicAxis testAxis = new CustomLogarithmicAxis("testAxis");
        testAxis.setRange(-300.0, -3.0);
        List ticks = testAxis.refreshTicks(RectangleEdge.TOP, 1);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)19L, (long)ticks.size());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(0)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(1)).getText());
        Assert.assertEquals((Object)"-10", (Object)((NumberTick)ticks.get(7)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(9)).getText());
        Assert.assertEquals((Object)"-100", (Object)((NumberTick)ticks.get(16)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(18)).getText());
    }

    @Test
    public void testRefreshTicksForInvalidAxisRange() throws Exception {
        CustomLogarithmicAxis testAxis = new CustomLogarithmicAxis("testAxis");
        try {
            testAxis.setRange(30.0, 3.0);
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"Range(double, double): require lower (30.0) <= upper (3.0).", (Object)expected.getMessage());
        }
        testAxis.setRange(-30.0, 30.0);
        List ticks = testAxis.refreshTicks(RectangleEdge.TOP, 1);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)0L, (long)ticks.size());
    }

    @Test
    public void testRefreshTicksVerticalAxisOrientation() throws Exception {
        CustomLogarithmicAxis testAxis = new CustomLogarithmicAxis("testAxis");
        testAxis.setRange(-300.0, -3.0);
        List ticks = testAxis.refreshTicks(RectangleEdge.LEFT, 0);
        Assert.assertNotNull((Object)ticks);
        Assert.assertEquals((long)19L, (long)ticks.size());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(0)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(1)).getText());
        Assert.assertEquals((Object)"-10", (Object)((NumberTick)ticks.get(7)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(9)).getText());
        Assert.assertEquals((Object)"-100", (Object)((NumberTick)ticks.get(16)).getText());
        Assert.assertEquals((Object)"", (Object)((NumberTick)ticks.get(18)).getText());
    }
}

