/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.swing.binding.BindingContext;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import javax.management.Descriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.statistics.CorrelativeFieldSelector;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class CorrelativeFieldSelectorTest {
    @Test
    public void testExpectedProperties() throws Exception {
        BindingContext bindingContext = new BindingContext();
        try {
            new CorrelativeFieldSelector(bindingContext);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bindingContext.getPropertySet().addProperties(new Property[]{Property.create((String)"pointDataSource", ProductNode.class)});
        try {
            new CorrelativeFieldSelector(bindingContext);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bindingContext.getPropertySet().addProperties(new Property[]{Property.create((String)"pointDataSource", VectorDataNode.class)});
        try {
            new CorrelativeFieldSelector(bindingContext);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bindingContext.getPropertySet().addProperties(new Property[]{Property.create((String)"dataField", Descriptor.class)});
        try {
            new CorrelativeFieldSelector(bindingContext);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bindingContext.getPropertySet().addProperties(new Property[]{Property.create((String)"dataField", AttributeDescriptor.class)});
        new CorrelativeFieldSelector(bindingContext);
    }

    @Test
    public void testUpdatePointDataSource() throws Exception {
        BindingContext bindingContext = new BindingContext();
        bindingContext.getPropertySet().addProperties(new Property[]{Property.create((String)"pointDataSource", VectorDataNode.class)});
        bindingContext.getPropertySet().addProperties(new Property[]{Property.create((String)"dataField", AttributeDescriptor.class)});
        CorrelativeFieldSelector correlativeFieldSelector = new CorrelativeFieldSelector(bindingContext);
        Product product = new Product("name", "type", 10, 10);
        product.getVectorDataGroup().add((ProductNode)new VectorDataNode("a", this.createFeatureType(Geometry.class)));
        product.getVectorDataGroup().add((ProductNode)new VectorDataNode("b", this.createFeatureType(Point.class)));
        Assert.assertEquals((long)0L, (long)correlativeFieldSelector.pointDataSourceList.getItemCount());
        Assert.assertEquals((long)0L, (long)correlativeFieldSelector.dataFieldList.getItemCount());
        correlativeFieldSelector.updatePointDataSource(product);
        Assert.assertEquals((long)3L, (long)correlativeFieldSelector.pointDataSourceList.getItemCount());
        Assert.assertEquals((long)0L, (long)correlativeFieldSelector.dataFieldList.getItemCount());
        correlativeFieldSelector.pointDataSourceProperty.setValue((Object)product.getVectorDataGroup().get("b"));
        Assert.assertEquals((long)3L, (long)correlativeFieldSelector.dataFieldList.getItemCount());
    }

    private SimpleFeatureType createFeatureType(Class binding) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("featureType");
        builder.add("chl", Float.class);
        builder.add("sst", Double.class);
        builder.add("time", ProductData.UTC.class);
        builder.add("point", binding);
        builder.setDefaultGeometry("point");
        return builder.buildFeatureType();
    }
}

