/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.esa.snap.rcp.statistics.AxisRangeControl;
import org.esa.snap.rcp.statistics.TitledSeparator;
import org.junit.Assert;
import org.junit.Test;

public class AxisRangeControlTest {
    @Test
    public void testBindingContextInPlace() throws Exception {
        AxisRangeControl axisRangeControl = new AxisRangeControl("X-Axis");
        axisRangeControl.getPanel();
        Assert.assertNotNull((Object)axisRangeControl.getBindingContext());
        Assert.assertNotNull((Object)axisRangeControl.getBindingContext().getBinding("autoMinMax"));
        Assert.assertNotNull((Object)axisRangeControl.getBindingContext().getBinding("min"));
        Assert.assertNotNull((Object)axisRangeControl.getBindingContext().getBinding("max"));
    }

    @Test
    public void testInitialValues() throws Exception {
        AxisRangeControl axisRangeControl = new AxisRangeControl("");
        axisRangeControl.getPanel();
        Assert.assertEquals((Object)true, (Object)axisRangeControl.getBindingContext().getBinding("autoMinMax").getPropertyValue());
        Assert.assertEquals((Object)0.0, (Object)axisRangeControl.getMin());
        Assert.assertEquals((Object)100.0, (Object)axisRangeControl.getMax());
    }

    @Test
    public void testMinMaxSetterAndGetter() {
        AxisRangeControl axisRangeControl = new AxisRangeControl("");
        axisRangeControl.adjustComponents(3.4, 13.8, 2);
        Assert.assertEquals((Object)3.4, (Object)axisRangeControl.getMin());
        Assert.assertEquals((Object)13.8, (Object)axisRangeControl.getMax());
    }

    @Test
    public void testVerySmallValues() {
        AxisRangeControl axisRangeControl = new AxisRangeControl("");
        axisRangeControl.getPanel();
        int numDecimalPlaces = 2;
        axisRangeControl.adjustComponents(-5.0E-9, 5.0E-9, numDecimalPlaces);
        Assert.assertEquals((double)0.0, (double)axisRangeControl.getMin(), (double)1.0E-7);
        Assert.assertEquals((double)Math.pow(10.0, -numDecimalPlaces), (double)axisRangeControl.getMax(), (double)1.0E-7);
    }

    @Test
    public void testAdjustcomponents_valueChanges() {
        AxisRangeControl axisRangeControl = new AxisRangeControl("");
        axisRangeControl.getPanel();
        int numDecimalPlaces = 2;
        axisRangeControl.adjustComponents(1.0, 2.0, numDecimalPlaces);
        Assert.assertEquals((double)1.0, (double)axisRangeControl.getMin(), (double)1.0E-7);
        Assert.assertEquals((double)2.0, (double)axisRangeControl.getMax(), (double)1.0E-7);
        axisRangeControl.adjustComponents(1.99999999999, 2.5, numDecimalPlaces);
        Assert.assertEquals((double)2.0, (double)axisRangeControl.getMin(), (double)1.0E-7);
        Assert.assertEquals((double)2.5, (double)axisRangeControl.getMax(), (double)1.0E-7);
        axisRangeControl.adjustComponents(1.0, 2.0000000000001, numDecimalPlaces);
        Assert.assertEquals((double)1.0, (double)axisRangeControl.getMin(), (double)1.0E-7);
        Assert.assertEquals((double)2.0, (double)axisRangeControl.getMax(), (double)1.0E-7);
    }

    @Test
    public void testSetTitle() {
        String axisName = "Titel";
        AxisRangeControl control = new AxisRangeControl("Titel");
        JPanel rangeControlPanel = control.getPanel();
        Component component = rangeControlPanel.getComponent(0);
        Assert.assertTrue((boolean)(component instanceof TitledSeparator));
        TitledSeparator titledSeparator = (TitledSeparator)component;
        JLabel titleLabel = titledSeparator.getLabelComponent();
        Assert.assertEquals((Object)"Titel", (Object)titleLabel.getText());
        control.setTitleSuffix("radiance_3");
        Assert.assertEquals((Object)"Titel (radiance_3)", (Object)titleLabel.getText());
        control.setTitleSuffix("");
        Assert.assertEquals((Object)"Titel", (Object)titleLabel.getText());
        control.setTitleSuffix("radiance_5");
        Assert.assertEquals((Object)"Titel (radiance_5)", (Object)titleLabel.getText());
        control.setTitleSuffix(null);
        Assert.assertEquals((Object)"Titel", (Object)titleLabel.getText());
    }

    public static void main(String[] args) throws ClassNotFoundException, UnsupportedLookAndFeelException, IllegalAccessException, InstantiationException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JPanel axesPanel = new JPanel(new GridLayout(-1, 1));
        axesPanel.add(new AxisRangeControl("X-Axis").getPanel());
        axesPanel.add(new AxisRangeControl("Y-Axis").getPanel());
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(axesPanel);
        frame.pack();
        frame.setVisible(true);
    }
}

