/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.spectrum;

import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.rcp.spectrum.SpectrumTopComponent;
import org.esa.snap.ui.product.spectrum.DisplayableSpectrum;
import org.esa.snap.ui.product.spectrum.SpectrumBand;
import org.junit.Assert;
import org.junit.Test;

public class SpectrumTopComponentTest {
    @Test
    public void testCreateSpectraFromUngroupedBands_noUnits() throws Exception {
        Band band_1 = new Band("cfsvbzt", 10, 1, 1);
        Band band_2 = new Band("cgvg", 10, 1, 1);
        Band band_3 = new Band("hbhn", 10, 1, 1);
        Band band_4 = new Band("nhbjz", 10, 1, 1);
        Band band_5 = new Band("tjbu", 10, 1, 1);
        SpectrumBand[] spectrumBands = new SpectrumBand[]{new SpectrumBand(band_1, false), new SpectrumBand(band_2, false), new SpectrumBand(band_3, false), new SpectrumBand(band_4, false), new SpectrumBand(band_5, false)};
        DisplayableSpectrum[] spectraFromUngroupedBands = SpectrumTopComponent.createSpectraFromUngroupedBands((SpectrumBand[])spectrumBands, (int)1, (int)0);
        TestCase.assertNotNull((Object)spectraFromUngroupedBands);
        TestCase.assertEquals((int)1, (int)spectraFromUngroupedBands.length);
        Band[] spectralBands = spectraFromUngroupedBands[0].getSpectralBands();
        TestCase.assertEquals((String)"Bands", (String)spectraFromUngroupedBands[0].getName());
        TestCase.assertEquals((int)5, (int)spectralBands.length);
        Assert.assertSame((Object)band_1, (Object)spectralBands[0]);
        Assert.assertSame((Object)band_2, (Object)spectralBands[1]);
        Assert.assertSame((Object)band_3, (Object)spectralBands[2]);
        Assert.assertSame((Object)band_4, (Object)spectralBands[3]);
        Assert.assertSame((Object)band_5, (Object)spectralBands[4]);
    }

    @Test
    public void testCreateSpectraFromUngroupedBands() throws Exception {
        Band band_1 = new Band("cfsvbzt", 10, 1, 1);
        band_1.setUnit("dvgf");
        Band band_2 = new Band("cgvg", 10, 1, 1);
        band_2.setUnit("bzhui");
        Band band_3 = new Band("hbhn", 10, 1, 1);
        band_3.setUnit("drstf");
        Band band_4 = new Band("nhbjz", 10, 1, 1);
        band_4.setUnit("dvgf");
        Band band_5 = new Band("tjbu", 10, 1, 1);
        Band band_6 = new Band("fgzvf", 10, 1, 1);
        band_6.setUnit("drstf");
        SpectrumBand[] spectrumBands = new SpectrumBand[]{new SpectrumBand(band_1, false), new SpectrumBand(band_2, false), new SpectrumBand(band_3, false), new SpectrumBand(band_4, false), new SpectrumBand(band_5, false), new SpectrumBand(band_6, false)};
        DisplayableSpectrum[] spectraFromUngroupedBands = SpectrumTopComponent.createSpectraFromUngroupedBands((SpectrumBand[])spectrumBands, (int)1, (int)0);
        TestCase.assertNotNull((Object)spectraFromUngroupedBands);
        TestCase.assertEquals((int)4, (int)spectraFromUngroupedBands.length);
        TestCase.assertEquals((String)"Bands measured in dvgf", (String)spectraFromUngroupedBands[0].getName());
        TestCase.assertEquals((int)2, (int)spectraFromUngroupedBands[0].getSpectralBands().length);
        Assert.assertSame((Object)band_1, (Object)spectraFromUngroupedBands[0].getSpectralBands()[0]);
        Assert.assertSame((Object)band_4, (Object)spectraFromUngroupedBands[0].getSpectralBands()[1]);
        TestCase.assertEquals((String)"Bands measured in bzhui", (String)spectraFromUngroupedBands[1].getName());
        TestCase.assertEquals((int)1, (int)spectraFromUngroupedBands[1].getSpectralBands().length);
        Assert.assertSame((Object)band_2, (Object)spectraFromUngroupedBands[1].getSpectralBands()[0]);
        TestCase.assertEquals((String)"Bands measured in drstf", (String)spectraFromUngroupedBands[2].getName());
        TestCase.assertEquals((int)2, (int)spectraFromUngroupedBands[2].getSpectralBands().length);
        Assert.assertSame((Object)band_3, (Object)spectraFromUngroupedBands[2].getSpectralBands()[0]);
        Assert.assertSame((Object)band_6, (Object)spectraFromUngroupedBands[2].getSpectralBands()[1]);
        TestCase.assertEquals((String)"Other", (String)spectraFromUngroupedBands[3].getName());
        TestCase.assertEquals((int)1, (int)spectraFromUngroupedBands[3].getSpectralBands().length);
        Assert.assertSame((Object)band_5, (Object)spectraFromUngroupedBands[3].getSpectralBands()[0]);
    }
}

