/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.scripting;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.rcp.scripting.TransientAction;
import org.junit.Assert;
import org.junit.Test;

public class TransientActionTest {
    @Test
    public void testConstructor() throws Exception {
        AbstractAction delegate = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        String path = "Test/X.instance";
        TransientAction transientAction = new TransientAction((Action)delegate, path);
        Assert.assertSame((Object)delegate, (Object)transientAction.getDelegate());
        Assert.assertEquals((Object)path, (Object)transientAction.getPath());
        try {
            new TransientAction(null, path);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new TransientAction((Action)delegate, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new TransientAction((Action)delegate, "Test/u");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new TransientAction((Action)delegate, "u.instance");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyDelegatesAllCalls() throws Exception {
        final String[] actionCommand = new String[1];
        AbstractAction delegate = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                actionCommand[0] = e.getActionCommand();
            }
        };
        delegate.setEnabled(false);
        TransientAction transientAction = new TransientAction((Action)delegate, "Test/MyAction.instance");
        Assert.assertEquals((Object)false, (Object)delegate.isEnabled());
        Assert.assertEquals((Object)false, (Object)transientAction.isEnabled());
        transientAction.setEnabled(true);
        Assert.assertEquals((Object)true, (Object)delegate.isEnabled());
        Assert.assertEquals((Object)true, (Object)transientAction.isEnabled());
        Assert.assertEquals(null, (Object)delegate.getValue("XXX"));
        Assert.assertEquals(null, (Object)transientAction.getValue("XXX"));
        transientAction.putValue("XXX", (Object)3456);
        Assert.assertEquals((Object)3456, (Object)delegate.getValue("XXX"));
        Assert.assertEquals((Object)3456, (Object)transientAction.getValue("XXX"));
        String[] name = new String[1];
        transientAction.addPropertyChangeListener(evt -> {
            name[0] = evt.getPropertyName();
        });
        Assert.assertEquals(null, (Object)name[0]);
        transientAction.putValue("XXX", (Object)9954);
        Assert.assertEquals((Object)"XXX", (Object)name[0]);
        delegate.putValue("YYY", 9954);
        Assert.assertEquals((Object)"YYY", (Object)name[0]);
        Assert.assertEquals(null, (Object)actionCommand[0]);
        delegate.actionPerformed(new ActionEvent(this, 0, "cmd1"));
        Assert.assertEquals((Object)"cmd1", (Object)actionCommand[0]);
        transientAction.actionPerformed(new ActionEvent(this, 1, "cmd2"));
        Assert.assertEquals((Object)"cmd2", (Object)actionCommand[0]);
    }
}

