/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class PinPositionTest {
    private Placemark placemark;

    @Before
    public void setup() throws TransformException, FactoryException {
        AffineTransform i2m = new AffineTransform();
        i2m.scale(2.0, 2.0);
        CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, new Rectangle(0, 0, 10, 10), i2m);
        Product product = new Product("P", "T", 10, 10);
        product.setSceneGeoCoding((GeoCoding)geoCoding);
        this.placemark = Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)"P1", (String)"L", (String)"", (PixelPos)new PixelPos(1.0, 1.0), null, (GeoCoding)product.getSceneGeoCoding());
        product.getPinGroup().add(this.placemark);
    }

    @Test
    public void initialState() {
        double x = this.placemark.getPixelPos().getX();
        double y = this.placemark.getPixelPos().getY();
        Assert.assertEquals((double)1.0, (double)x, (double)0.0);
        Assert.assertEquals((double)1.0, (double)y, (double)0.0);
        Point point = (Point)this.placemark.getFeature().getDefaultGeometry();
        Assert.assertEquals((double)2.0, (double)point.getX(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)point.getY(), (double)0.0);
        double lon = this.placemark.getGeoPos().getLon();
        double lat = this.placemark.getGeoPos().getLat();
        Assert.assertEquals((double)2.0, (double)lon, (double)0.0);
        Assert.assertEquals((double)2.0, (double)lat, (double)0.0);
    }

    @Test
    public void movePinByGeometry() {
        this.placemark.getFeature().setDefaultGeometry((Object)this.newPoint(4.0, 2.0));
        ((VectorDataNode)this.placemark.getProduct().getVectorDataGroup().get("pins")).fireFeaturesChanged(new SimpleFeature[]{this.placemark.getFeature()});
        Point point = (Point)this.placemark.getFeature().getDefaultGeometry();
        Assert.assertEquals((double)4.0, (double)point.getX(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)point.getY(), (double)0.0);
        double x = this.placemark.getPixelPos().getX();
        double y = this.placemark.getPixelPos().getY();
        Assert.assertEquals((double)2.0, (double)x, (double)0.0);
        Assert.assertEquals((double)1.0, (double)y, (double)0.0);
        double lon = this.placemark.getGeoPos().getLon();
        double lat = this.placemark.getGeoPos().getLat();
        Assert.assertEquals((double)4.0, (double)lon, (double)0.0);
        Assert.assertEquals((double)2.0, (double)lat, (double)0.0);
    }

    @Test
    public void movePinByPixelPosition() {
        this.placemark.setPixelPos(new PixelPos(2.0, 1.0));
        double x = this.placemark.getPixelPos().getX();
        double y = this.placemark.getPixelPos().getY();
        Assert.assertEquals((double)2.0, (double)x, (double)0.0);
        Assert.assertEquals((double)1.0, (double)y, (double)0.0);
        Point point = (Point)this.placemark.getFeature().getDefaultGeometry();
        Assert.assertEquals((double)4.0, (double)point.getX(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)point.getY(), (double)0.0);
        double lon = this.placemark.getGeoPos().getLon();
        double lat = this.placemark.getGeoPos().getLat();
        Assert.assertEquals((double)4.0, (double)lon, (double)0.0);
        Assert.assertEquals((double)2.0, (double)lat, (double)0.0);
    }

    private Point newPoint(double x, double y) {
        return new GeometryFactory().createPoint(new Coordinate(x, y));
    }
}

