/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.mask.MaskManagerForm;
import org.esa.snap.rcp.mask.MaskViewerForm;
import org.junit.Ignore;

@Ignore
public class MaskFormTest
extends TestCase {
    private Product product;
    private MaskManagerForm maskManagerForm;
    private MaskViewerForm maskViewerForm;

    public void setUp() {
        this.product = MaskFormTest.createTestProduct();
        this.maskManagerForm = new MaskManagerForm(null, null);
        this.maskManagerForm.reconfigureMaskTable(this.product, null);
        this.maskViewerForm = new MaskViewerForm(null);
        this.maskViewerForm.reconfigureMaskTable(this.product, null);
    }

    public void testMaskManagerForm() {
        MaskFormTest.assertEquals((int)10, (int)this.product.getMaskGroup().getNodeCount());
        MaskFormTest.assertSame((Object)this.product, (Object)this.maskManagerForm.getProduct());
        MaskFormTest.assertNotNull((Object)this.maskManagerForm.getHelpButton());
        MaskFormTest.assertEquals((String)"helpButton", (String)this.maskManagerForm.getHelpButton().getName());
        MaskFormTest.assertNotNull((Object)this.maskManagerForm.createContentPanel());
        MaskFormTest.assertEquals((int)10, (int)this.maskManagerForm.getRowCount());
        TableModel tableModel = this.maskManagerForm.getMaskTable().getModel();
        MaskFormTest.assertEquals((int)10, (int)this.maskManagerForm.getRowCount());
        MaskFormTest.assertEquals((Object)"M_1", (Object)tableModel.getValueAt(0, 0));
        MaskFormTest.assertEquals((Object)"M_2", (Object)tableModel.getValueAt(1, 0));
        MaskFormTest.assertEquals((Object)"M_3", (Object)tableModel.getValueAt(2, 0));
        MaskFormTest.assertEquals((Object)"M_4", (Object)tableModel.getValueAt(3, 0));
        MaskFormTest.assertEquals((Object)"M_5", (Object)tableModel.getValueAt(4, 0));
        MaskFormTest.assertEquals((Object)"M_6", (Object)tableModel.getValueAt(5, 0));
        MaskFormTest.assertEquals((Object)"M_7", (Object)tableModel.getValueAt(6, 0));
        MaskFormTest.assertEquals((Object)"M_8", (Object)tableModel.getValueAt(7, 0));
        MaskFormTest.assertEquals((Object)"M_9", (Object)tableModel.getValueAt(8, 0));
        MaskFormTest.assertEquals((Object)"M_10", (Object)tableModel.getValueAt(9, 0));
    }

    public void testMaskViewerForm() {
        MaskFormTest.assertSame((Object)this.product, (Object)this.maskViewerForm.getProduct());
        MaskFormTest.assertNull((Object)this.maskViewerForm.getHelpButton());
        MaskFormTest.assertNotNull((Object)this.maskViewerForm.createContentPanel());
        MaskFormTest.assertEquals((int)10, (int)this.maskViewerForm.getRowCount());
    }

    static Product createTestProduct() {
        Color[] colors = new Color[]{Color.WHITE, Color.BLACK, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.PINK, Color.YELLOW, Color.ORANGE, Color.RED};
        Product product = new Product("P", "T", 256, 256);
        Band a = product.addBand("A", 20);
        Band b = product.addBand("B", 20);
        Band c = product.addBand("C", 20);
        a.setScalingFactor(0.00392156862745098);
        b.setScalingFactor(0.00392156862745098);
        c.setScalingFactor(0.00392156862745098);
        a.setSourceImage((RenderedImage)new BufferedImage(256, 256, 10));
        b.setSourceImage((RenderedImage)new BufferedImage(256, 256, 10));
        c.setSourceImage((RenderedImage)new BufferedImage(256, 256, 10));
        for (int i = 0; i < colors.length; ++i) {
            String expression = "B > " + (double)i / ((double)colors.length - 1.0);
            String name = "M_" + (product.getMaskGroup().getNodeCount() + 1);
            Mask mask = Mask.BandMathsType.create((String)name, (String)expression, (int)product.getSceneRasterWidth(), (int)product.getSceneRasterHeight(), (String)expression, (Color)colors[i], (double)(1.0 - 1.0 / (double)(1 + i % 4)));
            product.getMaskGroup().add((ProductNode)mask);
        }
        return product;
    }
}

