/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.glayer.LayerTypeRegistry;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsLayerType;
import org.esa.snap.rcp.session.dom.SessionDomConverter;
import org.geotools.data.ows.CRSEnvelope;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WmsLayerConfigurationPersistencyTest {
    private ProductManager productManager;
    private Band band;

    @Before
    public void setup() {
        Product product = new Product("P", "T", 10, 10);
        product.setFileLocation(new File(String.format("out/%s.dim", product.getName())));
        this.band = new VirtualBand("V", 12, 10, 10, "42");
        product.addBand(this.band);
        this.productManager = new ProductManager();
        this.productManager.addProduct(product);
    }

    @Test
    public void testPersistency() throws ValidationException, ConversionException, MalformedURLException {
        WmsLayerType wmsLayerType = (WmsLayerType)LayerTypeRegistry.getLayerType(WmsLayerType.class);
        PropertySet configuration = wmsLayerType.createLayerConfig(null);
        configuration.setValue("styleName", (Object)"FancyStyle");
        configuration.setValue("serverUrl", (Object)new URL("http://www.mapserver.org"));
        configuration.setValue("crsEnvelope", (Object)new CRSEnvelope("EPSG:4324", -10.0, 20.0, 15.0, 50.0));
        configuration.setValue("imageSize", (Object)new Dimension(200, 300));
        configuration.setValue("layerIndex", (Object)12);
        configuration.setValue("raster", (Object)this.band);
        DefaultDomElement originalDomElement = new DefaultDomElement("configuration");
        SessionDomConverter domConverter = new SessionDomConverter(this.productManager);
        domConverter.convertValueToDom((Object)configuration, (DomElement)originalDomElement);
        System.out.println(originalDomElement.toXml());
        PropertyContainer restoredConfiguration = (PropertyContainer)domConverter.convertDomToValue((DomElement)originalDomElement, (Object)wmsLayerType.createLayerConfig(null));
        WmsLayerConfigurationPersistencyTest.compareConfigurations(configuration, (PropertySet)restoredConfiguration);
    }

    private static void compareConfigurations(PropertySet originalConfiguration, PropertySet restoredConfiguration) {
        for (Property originalModel : originalConfiguration.getProperties()) {
            PropertyDescriptor originalDescriptor = originalModel.getDescriptor();
            Property restoredModel = restoredConfiguration.getProperty(originalDescriptor.getName());
            PropertyDescriptor restoredDescriptor = restoredModel.getDescriptor();
            Assert.assertNotNull((Object)restoredModel);
            junit.framework.Assert.assertSame((Object)originalDescriptor.getName(), (Object)restoredDescriptor.getName());
            junit.framework.Assert.assertSame((Object)originalDescriptor.getType(), (Object)restoredDescriptor.getType());
            if (originalDescriptor.isTransient()) {
                junit.framework.Assert.assertEquals((boolean)originalDescriptor.isTransient(), (boolean)restoredDescriptor.isTransient());
                continue;
            }
            Object originalValue = originalModel.getValue();
            Object restoredValue = restoredModel.getValue();
            junit.framework.Assert.assertSame(originalValue.getClass(), restoredValue.getClass());
            if (!originalValue.getClass().isArray()) continue;
            int originalLength = Array.getLength(originalValue);
            int restoredLength = Array.getLength(restoredValue);
            junit.framework.Assert.assertEquals((int)originalLength, (int)restoredLength);
            for (int i = 0; i < restoredLength; ++i) {
                junit.framework.Assert.assertEquals((Object)Array.get(originalValue, i), (Object)Array.get(restoredValue, i));
            }
        }
    }
}

