/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.swing.demo.FigureEditorApp;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.esa.snap.ui.product.SimpleFeatureFigureFactory;
import org.esa.snap.ui.product.SimpleFeaturePointFigure;
import org.esa.snap.ui.product.SimpleFeatureShapeFigure;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureFigureEditorApp
extends FigureEditorApp {
    private final SimpleFeatureType featureType = this.createSimpleFeatureType("X", Geometry.class, null);
    private final SceneTransformProvider sceneTransformProvider = new SceneTransformProvider(){

        public MathTransform2D getModelToSceneTransform() {
            return MathTransform2D.IDENTITY;
        }

        public MathTransform2D getSceneToModelTransform() {
            return MathTransform2D.IDENTITY;
        }
    };

    private SimpleFeatureType createSimpleFeatureType(String typeName, Class<?> geometryType, SimpleFeatureType defaults) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        if (defaults != null) {
            // empty if block
        }
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        sftb.setCRS((CoordinateReferenceSystem)crs);
        sftb.setName(typeName);
        sftb.add("geom", geometryType);
        sftb.add("style", String.class);
        sftb.setDefaultGeometry("geom");
        return sftb.buildFeatureType();
    }

    public static void main(String[] args) {
        FeatureFigureEditorApp.run((FigureEditorApp)new FeatureFigureEditorApp());
    }

    protected FigureFactory getFigureFactory() {
        return new SimpleFeatureFigureFactory(this.featureType, this.sceneTransformProvider);
    }

    protected void loadFigureCollection(File file, FigureCollection figureCollection) throws IOException {
        FeatureSource<SimpleFeatureType, SimpleFeature> featureFeatureSource = FeatureFigureEditorApp.getFeatureSource(file);
        FeatureCollection featureTypeSimpleFeatureFeatureCollection = featureFeatureSource.getFeatures();
        for (SimpleFeature simpleFeature : featureTypeSimpleFeatureFeatureCollection) {
            DefaultFigureStyle figureStyle = FeatureFigureEditorApp.createDefaultFigureStyle();
            Object o = simpleFeature.getDefaultGeometry();
            if (o instanceof Point) {
                figureCollection.addFigure((Figure)new SimpleFeaturePointFigure(simpleFeature, this.sceneTransformProvider, (FigureStyle)figureStyle));
                continue;
            }
            figureCollection.addFigure((Figure)new SimpleFeatureShapeFigure(simpleFeature, this.sceneTransformProvider, (FigureStyle)figureStyle));
        }
    }

    protected void storeFigureCollection(FigureCollection figureCollection, File file) throws IOException {
        Figure[] figures = figureCollection.getFigures();
        HashMap featureListMap = new HashMap();
        for (Figure figure : figures) {
            SimpleFeatureFigure simpleFeatureFigure = (SimpleFeatureFigure)figure;
            SimpleFeature simpleFeature = simpleFeatureFigure.getSimpleFeature();
            Class<?> geometryType = simpleFeature.getDefaultGeometry().getClass();
            ArrayList<SimpleFeature> featureList = (ArrayList<SimpleFeature>)featureListMap.get(geometryType);
            if (featureList == null) {
                featureList = new ArrayList<SimpleFeature>();
                featureListMap.put(geometryType, featureList);
            }
            featureList.add(simpleFeature);
        }
        Set entries = featureListMap.entrySet();
        for (Map.Entry entry : entries) {
            Class geomType = (Class)entry.getKey();
            List list = (List)entry.getValue();
        }
    }

    public static FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(File file) throws IOException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
        map.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
        DataStore shapefileStore = DataStoreFinder.getDataStore(map);
        String typeName = shapefileStore.getTypeNames()[0];
        SimpleFeatureSource featureSource = shapefileStore.getFeatureSource(typeName);
        return featureSource;
    }

    public static DefaultFigureStyle createDefaultFigureStyle() {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle();
        figureStyle.setStrokeColor(Color.BLACK);
        figureStyle.setStrokeWidth(1.0);
        figureStyle.setFillColor(Color.WHITE);
        return figureStyle;
    }

    static class XYZ {
        Class<?> geometryType;
        SimpleFeatureType defaults;
        ArrayList<SimpleFeature> features = new ArrayList();

        XYZ() {
        }
    }
}

