/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.actions.file.CloseProductAction;
import org.junit.Assert;
import org.junit.Test;

public class CloseProductActionTest {
    @Test
    public void testFindFirstSourceProduct() throws Exception {
        Product toBeClosedProduct = new Product("ToBeClosed", "Type", 100, 100);
        Product dependentProduct = this.createDependentProduct(toBeClosedProduct);
        HashSet<Product> stillOpen = new HashSet<Product>(Collections.singletonList(dependentProduct));
        Product firstSourceProduct = CloseProductAction.findFirstSourceProduct((Product)toBeClosedProduct, stillOpen);
        Assert.assertEquals((Object)dependentProduct, (Object)firstSourceProduct);
    }

    @Test
    public void testFindFirstSourceProduct_IgnoreIndependent() throws Exception {
        Product toBeClosedProduct = new Product("ToBeClosed", "Type", 100, 100);
        Product dependingProduct = new Product("dependingProduct", "Type", 100, 100);
        Product dependentProduct = this.createDependentProduct(dependingProduct);
        HashSet<Product> stillOpen = new HashSet<Product>(Collections.singletonList(dependentProduct));
        stillOpen.add(dependingProduct);
        Product firstSourceProduct = CloseProductAction.findFirstSourceProduct((Product)toBeClosedProduct, stillOpen);
        Assert.assertNull((Object)firstSourceProduct);
    }

    private Product createDependentProduct(Product toBeClosedProduct) throws IOException {
        ProductSubsetDef subset = new ProductSubsetDef("subset");
        subset.setSubSampling(2, 2);
        return toBeClosedProduct.createSubset(subset, "dependent", "none");
    }
}

