/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.ui.io.TableModelCsvEncoder;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.windows.TopComponent;

public class TableViewPagePanel
extends PagePanel {
    private JTable table;
    private final Icon iconForSwitchToChartButton;

    public TableViewPagePanel(TopComponent topComponent, String helpId, String titlePrefix, Icon iconForSwitchToChartButton) {
        super(topComponent, helpId, titlePrefix);
        this.iconForSwitchToChartButton = iconForSwitchToChartButton;
    }

    @Override
    protected void initComponents() {
        AbstractButton switchToChartButton = ToolButtonFactory.createButton((Icon)this.iconForSwitchToChartButton, (boolean)false);
        switchToChartButton.setToolTipText("Switch to Chart View");
        switchToChartButton.setName("switchToChartButton");
        switchToChartButton.setEnabled(this.hasAlternativeView());
        switchToChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPagePanel.this.showAlternativeView();
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)switchToChartButton, "North");
        buttonPanel.add((Component)this.getHelpButton(), "South");
        this.add((Component)buttonPanel, "East");
        this.table = new JTable();
        this.table.removeEditor();
        this.table.setGridColor(Color.LIGHT_GRAY.brighter());
        this.table.addMouseListener(new PagePanel.PopupHandler());
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    protected void updateComponents() {
    }

    @Override
    protected String getDataAsText() {
        StringWriter writer = new StringWriter();
        try {
            new TableModelCsvEncoder(this.table.getModel()).encodeCsv((Writer)writer);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    protected void showAlternativeView() {
        super.showAlternativeView();
        PagePanel alternativeView = this.getAlternativeView();
        alternativeView.handleLayerContentChanged();
        RasterDataNode raster = alternativeView.getRaster();
        alternativeView.setRaster(null);
        alternativeView.setRaster(raster);
        alternativeView.handleNodeSelectionChanged();
    }

    void setModel(TableModel tableModel) {
        this.table.setModel(tableModel);
        if (this.table.getColumnCount() > 0) {
            JTableHeader tableHeader = this.table.getTableHeader();
            int margin = tableHeader.getColumnModel().getColumnMargin();
            TableCellRenderer renderer = tableHeader.getDefaultRenderer();
            Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                TableColumn tableColumn = columns.nextElement();
                int width = this.getColumnMinWith(tableColumn, renderer, margin);
                tableColumn.setMinWidth(width);
            }
        }
    }

    private int getColumnMinWith(TableColumn column, TableCellRenderer renderer, int margin) {
        Object headerValue = column.getHeaderValue();
        JLabel label = (JLabel)renderer.getTableCellRendererComponent(this.table, headerValue, false, false, 0, 0);
        return label.getPreferredSize().width + margin;
    }
}

