/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.util.List;
import javax.swing.JScrollPane;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.AbstractBand;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.rcp.statistics.TablePagePanel;
import org.openide.windows.TopComponent;

class InformationPanel
extends TablePagePanel {
    private static final String DEFAULT_INFORMATION_TEXT = "No information available.";
    private static final String TITLE_PREFIX = "Information";
    private static final String NO_PRODUCT_READER_MESSAGE = "No product reader set";
    private static final int index_of_name_column = 0;
    private static final int index_of_value_and_unit_column = 1;
    private InformationTableModel tableModel;
    private int widthOfNameColumn = -1;
    private int widthOfValueAndUnitColumn = -1;

    InformationPanel(TopComponent parentComponent, String helpId) {
        super(parentComponent, helpId, TITLE_PREFIX, DEFAULT_INFORMATION_TEXT);
    }

    @Override
    protected void initComponents() {
        this.tableModel = new InformationTableModel();
        this.getTable().setModel(this.tableModel);
        this.getTable().setTableHeader(null);
        this.getTable().addMouseListener(new PagePanel.PopupHandler(this));
        this.getTable().setShowGrid(false);
        this.getTable().setRowSelectionAllowed(false);
        this.getTable().setColumnSelectionAllowed(false);
        this.getTable().setAutoResizeMode(0);
        this.add(new JScrollPane(this.getTable()));
    }

    @Override
    protected String getDataAsText() {
        StringBuilder builder = new StringBuilder();
        List rows = this.tableModel.rows;
        for (int i = 0; i < rows.size(); ++i) {
            InformationTableRow row = (InformationTableRow)rows.get(i);
            builder.append(row.label).append("\t").append(row.value).append(StringUtils.isNotNullAndNotEmpty((String)row.unit) ? "\t" + row.unit : "");
            if (i >= rows.size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    protected void updateComponents() {
        this.tableModel.clear();
        this.widthOfNameColumn = -1;
        this.widthOfValueAndUnitColumn = -1;
        if (this.getRaster() instanceof AbstractBand) {
            Band band = (Band)this.getRaster();
            this.addEntry("Name:", band.getName(), "");
            this.addEntry("Type:", "Band", "");
            this.addEntry("Description:", band.getDescription(), "");
            this.addEntry("Geophysical unit:", band.getUnit(), "");
            this.addEntry("Geophysical data type:", ProductData.getTypeString((int)band.getGeophysicalDataType()), "");
            this.addEntry("Raw data type:", ProductData.getTypeString((int)band.getDataType()), "");
            this.addEntry("Raster width:", String.valueOf(band.getRasterWidth()), "pixels");
            this.addEntry("Raster height:", String.valueOf(band.getRasterHeight()), "pixels");
            this.addEntry("Scaling factor:", String.valueOf(band.getScalingFactor()), "");
            this.addEntry("Scaling offset:", String.valueOf(band.getScalingOffset()), "");
            this.addEntry("Is log 10 scaled:", String.valueOf(band.isLog10Scaled()), "");
            this.addEntry("Is no-data value used:", String.valueOf(band.isNoDataValueUsed()), "");
            this.addEntry("No-data value:", String.valueOf(band.getNoDataValue()), "");
            this.addEntry("Geophysical no-data value:", String.valueOf(band.getGeophysicalNoDataValue()), "");
            this.addEntry("Valid pixel expression:", String.valueOf(band.getValidPixelExpression()), "");
            this.addEntry("Spectral band index:", String.valueOf(band.getSpectralBandIndex() + 1), "");
            this.addEntry("Wavelength:", String.valueOf(band.getSpectralWavelength()), "nm");
            this.addEntry("Bandwidth:", String.valueOf(band.getSpectralBandwidth()), "nm");
            this.addEntry("Solar flux:", String.valueOf(band.getSolarFlux()), "mW/(m^2*nm)");
        } else if (this.getRaster() instanceof TiePointGrid) {
            TiePointGrid grid = (TiePointGrid)this.getRaster();
            this.addEntry("Name:", grid.getName(), "");
            this.addEntry("Type:", "Tie Point Grid", "");
            this.addEntry("Description:", grid.getDescription(), "");
            this.addEntry("Geophysical unit:", grid.getUnit(), "");
            this.addEntry("Geophysical data type:", ProductData.getTypeString((int)grid.getGeophysicalDataType()), "");
            this.addEntry("Grid width:", String.valueOf(grid.getGridWidth()), "tie points");
            this.addEntry("Grid height:", String.valueOf(grid.getGridHeight()), "tie points");
            this.addEntry("Offset X:", String.valueOf(grid.getOffsetX()), "pixels");
            this.addEntry("Offset Y:", String.valueOf(grid.getOffsetY()), "pixels");
            this.addEntry("Sub-sampling X:", String.valueOf(grid.getSubSamplingX()), "pixels");
            this.addEntry("Sub-sampling Y:", String.valueOf(grid.getSubSamplingY()), "pixels");
            this.addEntry("Raster width:", String.valueOf(grid.getRasterWidth()), "pixels");
            this.addEntry("Raster height:", String.valueOf(grid.getRasterHeight()), "pixels");
        }
        Product product = this.getProduct();
        if (product == null) {
            this.showNoInformationAvailableMessage();
            return;
        }
        if (this.tableModel.getRowCount() > 0) {
            this.addEntry("", "", "");
        }
        this.addEntry("Product name:", product.getName(), "");
        this.addEntry("Product type:", product.getProductType(), "");
        this.addEntry("Product description:", product.getDescription(), "");
        String productFormatName = InformationPanel.getProductFormatName(product);
        String productFormatNameString = productFormatName != null ? productFormatName : "unknown";
        this.addEntry("Product format:", productFormatNameString, "");
        this.addEntry("Product reader:", InformationPanel.getProductReaderDescription(product), "");
        this.addEntry("Product reader class:", InformationPanel.getProductReaderClass(product), "");
        this.addEntry("Product reader module:", InformationPanel.getProductReaderModule(product), "");
        this.addEntry("Product file location:", product.getFileLocation() != null ? product.getFileLocation().getPath() : "Not yet saved", "");
        this.addEntry("Product scene width:", String.valueOf(product.getSceneRasterWidth()), "pixels");
        this.addEntry("Product scene height:", String.valueOf(product.getSceneRasterHeight()), "pixels");
        String startTimeString = product.getStartTime() != null ? product.getStartTime().getElemString() : "Not available";
        this.addEntry("Product start time (UTC):", startTimeString, "");
        String stopTimeString = product.getEndTime() != null ? product.getEndTime().getElemString() : "Not available";
        this.addEntry("Product end time (UTC):", stopTimeString, "");
        this.ensureTableModel();
    }

    private void ensureTableModel() {
        if (this.getTable().getModel() != this.tableModel) {
            this.getTable().setModel(this.tableModel);
            this.getTable().setAutoResizeMode(0);
        }
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(this.widthOfNameColumn);
        this.getTable().getColumnModel().getColumn(0).setMinWidth(this.widthOfNameColumn);
        this.getTable().getColumnModel().getColumn(0).setMaxWidth(this.widthOfNameColumn);
        this.getTable().getColumnModel().getColumn(1).setPreferredWidth(this.widthOfValueAndUnitColumn);
        this.getTable().getColumnModel().getColumn(1).setMinWidth(this.widthOfValueAndUnitColumn);
        this.getTable().getColumnModel().getColumn(1).setMaxWidth(this.widthOfValueAndUnitColumn);
        this.setColumnRenderer(0, TablePagePanel.RendererFactory.createRenderer(1));
        this.setColumnRenderer(1, TablePagePanel.RendererFactory.createRenderer(3));
    }

    private void addEntry(String label, String value, String unit) {
        String formattedLabel = String.format("%1$-30s \t", label);
        this.widthOfNameColumn = Math.max(this.widthOfNameColumn, this.getFontMetrics(this.getFont()).stringWidth(formattedLabel) + 10);
        this.widthOfValueAndUnitColumn = Math.max(this.widthOfValueAndUnitColumn, this.getFontMetrics(this.getFont()).stringWidth(value + (StringUtils.isNotNullAndNotEmpty((String)unit) ? " " + unit : "")) + 10);
        InformationTableRow row = new InformationTableRow(formattedLabel, value, unit);
        this.tableModel.addRow(row);
    }

    private static String getProductReaderDescription(Product product) {
        String description;
        ProductReaderPlugIn readerPlugIn;
        ProductReader productReader = product.getProductReader();
        if (productReader != null && (readerPlugIn = productReader.getReaderPlugIn()) != null && (description = readerPlugIn.getDescription(null)) != null) {
            return description;
        }
        return NO_PRODUCT_READER_MESSAGE;
    }

    private static String getProductReaderClass(Product product) {
        ProductReaderPlugIn readerPlugIn;
        ProductReader productReader = product.getProductReader();
        if (productReader != null && (readerPlugIn = productReader.getReaderPlugIn()) != null) {
            return readerPlugIn.getClass().getName();
        }
        return NO_PRODUCT_READER_MESSAGE;
    }

    private static String getProductReaderModule(Product product) {
        ProductReader productReader = product.getProductReader();
        if (productReader != null) {
            return "unknown";
        }
        return NO_PRODUCT_READER_MESSAGE;
    }

    private static String getProductFormatName(Product product) {
        ProductReader productReader = product.getProductReader();
        if (productReader == null) {
            return null;
        }
        ProductReaderPlugIn readerPlugIn = productReader.getReaderPlugIn();
        if (readerPlugIn != null) {
            return InformationPanel.getProductFormatName(readerPlugIn);
        }
        return null;
    }

    private static String getProductFormatName(ProductReaderPlugIn readerPlugIn) {
        String[] formatNames = readerPlugIn.getFormatNames();
        if (formatNames != null && formatNames.length > 0) {
            return formatNames[0];
        }
        return null;
    }

    private static class InformationTableModel
    extends TablePagePanel.TablePagePanelModel {
        private InformationTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value and Unit";
                }
            }
            throw new IllegalStateException("Should never come here");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TablePagePanel.TableRow row = (TablePagePanel.TableRow)this.rows.get(rowIndex);
            if (!(row instanceof InformationTableRow)) {
                return row.toString();
            }
            InformationTableRow tableRow = (InformationTableRow)row;
            switch (columnIndex) {
                case 0: {
                    return tableRow.label;
                }
                case 1: {
                    return tableRow.value + (StringUtils.isNotNullAndNotEmpty((String)tableRow.unit) ? " " + tableRow.unit : "");
                }
            }
            throw new IllegalStateException("Invalid index: row=" + rowIndex + "; column=" + columnIndex);
        }
    }

    static class InformationTableRow
    implements TablePagePanel.TableRow {
        String label;
        String value;
        String unit;

        public InformationTableRow(String label, String value, String unit) {
            this.label = label;
            this.value = value;
            this.unit = unit;
        }
    }
}

