/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import javax.media.jai.Histogram;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.AxisRangeControl;
import org.esa.snap.rcp.statistics.ChartPagePanel;
import org.esa.snap.rcp.statistics.HistogramPanelModel;
import org.esa.snap.rcp.statistics.MaskSelectionToolSupport;
import org.esa.snap.rcp.statistics.PlotAreaSelectionTool;
import org.esa.snap.rcp.statistics.StatisticChartStyling;
import org.esa.snap.rcp.statistics.XYPlotToolTipGenerator;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XIntervalSeries;
import org.jfree.data.xy.XIntervalSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.openide.windows.TopComponent;

class HistogramPanel
extends ChartPagePanel {
    private static final String NO_DATA_MESSAGE = "No histogram computed yet.\nIf a band is selected, a histogram can be created by hitting the 'Refresh View' button.\nFor more information about this plot\nhit the help button at the bottom right.\nTIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private static final String CHART_TITLE = "Histogram";
    public static final String PROPERTY_NAME_NUM_BINS = "numBins";
    public static final String PROPERTY_NAME_LOGARITHMIC_HISTOGRAM = "histogramLogScaled";
    public static final String PROPERTY_NAME_LOG_SCALED = "xAxisLogScaled";
    private static final double HISTO_MIN_DEFAULT = 0.0;
    private static final double HISTO_MAX_DEFAULT = 100.0;
    private static final int NUM_BINS_DEFAULT = 512;
    private AxisRangeControl xAxisRangeControl;
    private XIntervalSeriesCollection dataset;
    private JFreeChart chart;
    private HistogramPlotConfig histogramPlotConfig;
    private BindingContext bindingContext;
    private boolean isInitialized;
    private boolean histogramComputing;
    private Enablement log10AxisEnablement;
    private Enablement log10HistEnablement;
    private HistogramPanelModel model;
    private ConfigChangeListener configChangeListener;

    HistogramPanel(TopComponent parentComponent, String helpID) {
        super(parentComponent, helpID, CHART_TITLE, true);
    }

    @Override
    protected void initComponents() {
        SnapApp.getDefault().getSelectionSupport(ProductNode.class).addHandler((oldValue, newValue) -> {
            if (newValue != null) {
                this.handleMasklessProduct(newValue.getProduct());
            }
        });
        SnapApp.getDefault().getProductManager().addListener(new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
            }

            public void productRemoved(ProductManager.Event event) {
                HistogramPanel.this.model.removeStxFromProduct(event.getProduct());
            }
        });
        this.model = new HistogramPanelModel();
        this.xAxisRangeControl = new AxisRangeControl("X-Axis");
        this.histogramPlotConfig = new HistogramPlotConfig();
        this.bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.histogramPlotConfig));
        this.configChangeListener = new ConfigChangeListener();
        this.bindingContext.addPropertyChangeListener((PropertyChangeListener)this.configChangeListener);
        this.createUI();
        this.updateComponents();
    }

    @Override
    protected void updateComponents() {
        if (!this.isInitialized || !this.isVisible()) {
            return;
        }
        super.updateComponents();
        this.chart.setTitle(this.getRaster() != null ? "Histogram for " + this.getRaster().getName() : CHART_TITLE);
        this.updateXAxis();
        if (this.xAxisRangeControl.isAutoMinMax()) {
            this.xAxisRangeControl.getBindingContext().getPropertySet().getDescriptor("min").setDefaultValue((Object)0.0);
            this.xAxisRangeControl.getBindingContext().getPropertySet().getDescriptor("max").setDefaultValue((Object)100.0);
        }
        this.dataset = null;
        this.handleStxChange();
        this.updateRefreshButton();
    }

    private void handleMasklessProduct(Product product) {
        if (product != null && product.getMaskGroup().getNodeCount() == 0) {
            try {
                this.bindingContext.getPropertySet().getProperty("useRoiMask").setValue((Object)Boolean.FALSE);
            }
            catch (ValidationException e) {
                throw new IllegalStateException("Cannot come here");
            }
        }
    }

    private void updateRefreshButton() {
        this.refreshButton.setEnabled(this.getRaster() != null && !this.model.hasStx(this.createHistogramConfig()));
    }

    @Override
    protected boolean mustHandleSelectionChange() {
        return this.isRasterChanged();
    }

    @Override
    protected void handleNodeSelectionChanged() {
        super.handleNodeSelectionChanged();
        this.handleMasklessProduct(this.getProduct());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistogramPanel.this.updateChartData(false);
            }
        });
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
        super.nodeDataChanged(event);
        if (!this.histogramPlotConfig.useRoiMask) {
            return;
        }
        Mask roiMask = this.histogramPlotConfig.roiMask;
        if (roiMask == null) {
            return;
        }
        ProductNode sourceNode = event.getSourceNode();
        if (!(sourceNode instanceof Mask)) {
            return;
        }
        String maskName = sourceNode.getName();
        if (roiMask.getName().equals(maskName)) {
            this.model.removeStx(this.createHistogramConfig());
            this.updateComponents();
        }
    }

    private void createUI() {
        this.dataset = new XIntervalSeriesCollection();
        this.chart = ChartFactory.createHistogram((String)CHART_TITLE, (String)"Values", (String)"Frequency in #pixels", (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot xyPlot = this.chart.getXYPlot();
        xyPlot.setDomainZeroBaselineStroke((Stroke)new BasicStroke(0.2f));
        XYBarRenderer renderer = (XYBarRenderer)xyPlot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setShadowVisible(false);
        renderer.setShadowYOffset(-4.0);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new XYPlotToolTipGenerator());
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setSeriesPaint(0, (Paint)new Color(0, 0, 200));
        this.createUI(this.createChartPanel(this.chart), this.createOptionsPanel(), this.bindingContext);
        this.isInitialized = true;
        Binding minBinding = this.xAxisRangeControl.getBindingContext().getBinding("min");
        double min = (Double)minBinding.getPropertyValue();
        Binding maxBinding = this.xAxisRangeControl.getBindingContext().getBinding("max");
        double max = (Double)maxBinding.getPropertyValue();
        if (!this.histogramComputing && min > max) {
            minBinding.setPropertyValue((Object)max);
            maxBinding.setPropertyValue((Object)min);
        }
        this.updateXAxis();
    }

    private JPanel createOptionsPanel() {
        JLabel numBinsLabel = new JLabel("#Bins:");
        JTextField numBinsField = new JTextField(Integer.toString(512));
        numBinsField.setPreferredSize(new Dimension(50, numBinsField.getPreferredSize().height));
        JCheckBox histoLogCheck = new JCheckBox("Log10 scaled bins");
        histoLogCheck.addActionListener(this.configChangeListener);
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_NUM_BINS).setDescription("Set the number of bins in the histogram");
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_NUM_BINS).setValueRange(new ValueRange(2.0, 2048.0));
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_NUM_BINS).setDefaultValue((Object)512);
        this.bindingContext.bind(PROPERTY_NAME_NUM_BINS, numBinsField);
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_LOGARITHMIC_HISTOGRAM).setDescription("Use log-10 scaled values for computation of histogram");
        this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_LOGARITHMIC_HISTOGRAM).setDefaultValue((Object)false);
        this.bindingContext.bind(PROPERTY_NAME_LOGARITHMIC_HISTOGRAM, histoLogCheck);
        this.log10HistEnablement = this.bindingContext.bindEnabledState(PROPERTY_NAME_LOGARITHMIC_HISTOGRAM, true, new Enablement.Condition(){

            public boolean evaluate(BindingContext bindingContext) {
                return HistogramPanel.this.getRaster() != null && HistogramPanel.this.getRaster().getStx().getMaximum() > 0.0;
            }
        });
        AxisControlChangeListener logChangeListener = new AxisControlChangeListener();
        this.xAxisRangeControl.getBindingContext().addPropertyChangeListener((PropertyChangeListener)logChangeListener);
        this.xAxisRangeControl.getBindingContext().getPropertySet().addProperty(this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_LOGARITHMIC_HISTOGRAM));
        this.xAxisRangeControl.getBindingContext().getPropertySet().addProperty(this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_LOG_SCALED));
        this.xAxisRangeControl.getBindingContext().getPropertySet().getDescriptor(PROPERTY_NAME_LOG_SCALED).setDescription("Toggle whether to use a logarithmic x-axis");
        this.log10AxisEnablement = this.xAxisRangeControl.getBindingContext().bindEnabledState(PROPERTY_NAME_LOG_SCALED, true, new Enablement.Condition(){

            public boolean evaluate(BindingContext bindingContext) {
                HistogramPanelModel.HistogramConfig currentConfig = HistogramPanel.this.createHistogramConfig();
                boolean hasStx = HistogramPanel.this.model.hasStx(currentConfig);
                return HistogramPanel.this.dataset != null && hasStx && !HistogramPanel.this.model.getStx(currentConfig).isLogHistogram();
            }
        });
        JPanel dataSourceOptionsPanel = GridBagUtils.createPanel();
        GridBagConstraints dataSourceOptionsConstraints = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)new JLabel(" "), (GridBagConstraints)dataSourceOptionsConstraints, (String)"gridwidth=2,gridy=0,gridx=0,weightx=0");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)numBinsLabel, (GridBagConstraints)dataSourceOptionsConstraints, (String)"insets.top=2,insets.left=4,gridwidth=1,gridy=1,gridx=0,weightx=1");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)numBinsField, (GridBagConstraints)dataSourceOptionsConstraints, (String)"insets.top=0,insets.left=0,insets.right=2,gridwidth=1,gridy=1,gridx=1");
        GridBagUtils.addToPanel((JPanel)dataSourceOptionsPanel, (Component)histoLogCheck, (GridBagConstraints)dataSourceOptionsConstraints, (String)"insets.right=0,gridwidth=2,gridy=2,gridx=0");
        this.xAxisRangeControl.getBindingContext().bind(PROPERTY_NAME_LOG_SCALED, new JCheckBox("Log10 scaled"));
        this.xAxisRangeControl.getBindingContext().addPropertyChangeListener(PROPERTY_NAME_LOG_SCALED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValueAxis oldAxis = HistogramPanel.this.chart.getXYPlot().getDomainAxis();
                ValueAxis newAxis = StatisticChartStyling.updateScalingOfAxis((Boolean)evt.getNewValue(), oldAxis, true);
                HistogramPanel.this.chart.getXYPlot().setDomainAxis(newAxis);
            }
        });
        JPanel displayOptionsPanel = GridBagUtils.createPanel();
        GridBagConstraints displayOptionsConstraints = GridBagUtils.createConstraints((String)"anchor=SOUTH,fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel((JPanel)displayOptionsPanel, (Component)this.xAxisRangeControl.getPanel(), (GridBagConstraints)displayOptionsConstraints, (String)"gridy=2");
        JPanel optionsPanel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=2,weightx=1");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)dataSourceOptionsPanel, (GridBagConstraints)gbc, (String)"gridy=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JPanel(), (GridBagConstraints)gbc, (String)"gridy=1,fill=VERTICAL,weighty=1");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)displayOptionsPanel, (GridBagConstraints)gbc, (String)"gridy=2,fill=HORIZONTAL,weighty=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JPanel(), (GridBagConstraints)gbc, (String)"gridy=3,fill=VERTICAL,weighty=1");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)this.xAxisRangeControl.getBindingContext().getBinding(PROPERTY_NAME_LOG_SCALED).getComponents()[0], (GridBagConstraints)gbc, (String)"gridy=4");
        return optionsPanel;
    }

    private HistogramPanelModel.HistogramConfig createHistogramConfig() {
        if (this.getRaster() == null || this.isRasterChanged()) {
            return null;
        }
        return new HistogramPanelModel.HistogramConfig(this.getRaster(), this.histogramPlotConfig.useRoiMask ? this.histogramPlotConfig.roiMask.getName() : null, this.histogramPlotConfig.numBins, this.histogramPlotConfig.histogramLogScaled);
    }

    private ChartPanel createChartPanel(JFreeChart chart) {
        XYPlot plot = chart.getXYPlot();
        plot.setForegroundAlpha(0.85f);
        plot.setNoDataMessage(NO_DATA_MESSAGE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        ChartPanel chartPanel = new ChartPanel(chart);
        MaskSelectionToolSupport maskSelectionToolSupport = new MaskSelectionToolSupport(this, chartPanel, "histogram_plot_area", "Mask generated from selected histogram plot area", Color.RED, PlotAreaSelectionTool.AreaType.X_RANGE){

            @Override
            protected String createMaskExpression(PlotAreaSelectionTool.AreaType areaType, Shape shape) {
                Rectangle2D bounds = shape.getBounds2D();
                return this.createMaskExpression(bounds.getMinX(), bounds.getMaxX());
            }

            protected String createMaskExpression(double x1, double x2) {
                String bandName = BandArithmetic.createExternalName((String)HistogramPanel.this.getRaster().getName());
                HistogramPanelModel.HistogramConfig currentConfig = HistogramPanel.this.createHistogramConfig();
                return String.format("%s >= %s && %s <= %s", bandName, HistogramPanel.this.model.hasStx(currentConfig) ? HistogramPanel.this.model.getStx(currentConfig).getHistogramScaling().scaleInverse(x1) : x1, bandName, HistogramPanel.this.model.hasStx(currentConfig) ? HistogramPanel.this.model.getStx(currentConfig).getHistogramScaling().scaleInverse(x2) : x2);
            }
        };
        chartPanel.getPopupMenu().addSeparator();
        chartPanel.getPopupMenu().add(maskSelectionToolSupport.createMaskSelectionModeMenuItem());
        chartPanel.getPopupMenu().add(maskSelectionToolSupport.createDeleteMaskMenuItem());
        chartPanel.getPopupMenu().addSeparator();
        chartPanel.getPopupMenu().add(this.createCopyDataToClipboardMenuItem());
        return chartPanel;
    }

    @Override
    public void updateChartData() {
        this.updateChartData(true);
    }

    private void updateChartData(boolean recompute) {
        Double max;
        Double min;
        boolean autoMinMaxEnabled = this.getAutoMinMaxEnabled();
        if (autoMinMaxEnabled) {
            min = null;
            max = null;
        } else {
            min = (Double)this.xAxisRangeControl.getBindingContext().getBinding("min").getPropertyValue();
            max = (Double)this.xAxisRangeControl.getBindingContext().getBinding("max").getPropertyValue();
        }
        new StxWorker(min, max, autoMinMaxEnabled, recompute).execute();
    }

    private void setStx(Stx stx) {
        if (stx != null) {
            HistogramPanelModel.HistogramConfig config = this.createHistogramConfig();
            if (config == null) {
                return;
            }
            if (!this.model.hasStx(config)) {
                this.model.setStx(config, stx);
            }
            this.dataset = new XIntervalSeriesCollection();
            int[] binCounts = stx.getHistogramBins();
            RasterDataNode raster = this.getRaster();
            XIntervalSeries series = new XIntervalSeries((Comparable)((Object)raster.getName()));
            Histogram histogram = stx.getHistogram();
            for (int i = 0; i < binCounts.length; ++i) {
                double xMin = histogram.getBinLowValue(0, i);
                double xMax = i < binCounts.length - 1 ? histogram.getBinLowValue(0, i + 1) : histogram.getHighValue(0);
                series.add(xMin, xMin, xMax, (double)binCounts[i]);
            }
            this.dataset.addSeries(series);
        }
        this.handleStxChange();
    }

    private void handleStxChange() {
        if (this.model.hasStx(this.createHistogramConfig())) {
            this.refreshButton.setEnabled(false);
        }
        this.log10HistEnablement.apply();
        this.updateLogXAxisCheckBox();
        this.chart.getXYPlot().setDataset((XYDataset)this.dataset);
        this.updateXAxis();
        this.chart.fireChartChanged();
    }

    private String getAxisLabel() {
        boolean logScaled = (Boolean)this.bindingContext.getBinding(PROPERTY_NAME_LOGARITHMIC_HISTOGRAM).getPropertyValue();
        return StatisticChartStyling.getAxisLabel(this.getRaster(), "X", logScaled);
    }

    private boolean getAutoMinMaxEnabled() {
        return this.xAxisRangeControl.isAutoMinMax();
    }

    @Override
    public String getDataAsText() {
        HistogramPanelModel.HistogramConfig config = this.createHistogramConfig();
        if (!this.model.hasStx(config)) {
            return null;
        }
        Stx stx = this.model.getStx(config);
        int[] binVals = stx.getHistogramBins();
        int numBins = binVals.length;
        double min = stx.getMinimum();
        double max = stx.getMaximum();
        StringBuilder sb = new StringBuilder(16000);
        sb.append("Product name:\t").append(this.getRaster().getProduct().getName()).append("\n");
        sb.append("Dataset name:\t").append(this.getRaster().getName()).append("\n");
        sb.append('\n');
        sb.append("Histogram minimum:\t").append(min).append("\t").append(this.getRaster().getUnit()).append("\n");
        sb.append("Histogram maximum:\t").append(max).append("\t").append(this.getRaster().getUnit()).append("\n");
        sb.append("Histogram bin size:\t").append(this.getRaster().isLog10Scaled() ? "NA\t" : (max - min) / (double)numBins + "\t" + this.getRaster().getUnit() + "\n");
        sb.append("Histogram #bins:\t").append(numBins).append("\n");
        sb.append('\n');
        sb.append("Bin center value");
        sb.append('\t');
        sb.append("Bin counts");
        sb.append('\n');
        for (int i = 0; i < numBins; ++i) {
            sb.append(min + ((double)i + 0.5) * (max - min) / (double)numBins);
            sb.append('\t');
            sb.append(binVals[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    private void updateLogXAxisCheckBox() {
        HistogramPanelModel.HistogramConfig config = this.createHistogramConfig();
        boolean enabled = this.dataset != null && this.model.hasStx(config) && this.model.getStx(config).getMinimum() > 0.0 && !this.model.getStx(config).isLogHistogram();
        Binding binding = this.xAxisRangeControl.getBindingContext().getBinding(PROPERTY_NAME_LOG_SCALED);
        if (!enabled) {
            binding.setPropertyValue((Object)false);
        }
        this.log10AxisEnablement.apply();
        binding.adjustComponents();
    }

    private void updateXAxis() {
        XYPlot plot = this.chart.getXYPlot();
        plot.getDomainAxis().setLabel(this.getAxisLabel());
    }

    private class ConfigChangeListener
    implements PropertyChangeListener,
    ActionListener {
        private ConfigChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.handleConfigChanged();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleConfigChanged();
        }

        private void handleConfigChanged() {
            HistogramPanel.this.updateChartData(false);
            HistogramPanel.this.updateRefreshButton();
        }
    }

    private class StxWorker
    extends ProgressMonitorSwingWorker<Stx, Object> {
        private final Double min;
        private final Double max;
        private final boolean autoMinMaxEnabled;
        private final boolean compute;

        public StxWorker(Double min, Double max, boolean autoMinMaxEnabled, boolean compute) {
            super((Component)HistogramPanel.this, "Computing Histogram");
            this.min = min;
            this.max = max;
            this.autoMinMaxEnabled = autoMinMaxEnabled;
            this.compute = compute;
        }

        protected Stx doInBackground(ProgressMonitor pm) throws Exception {
            Stx stx;
            HistogramPanelModel.HistogramConfig config = HistogramPanel.this.createHistogramConfig();
            if (HistogramPanel.this.model.hasStx(config)) {
                return HistogramPanel.this.model.getStx(config);
            }
            if (!this.compute) {
                return null;
            }
            if (HistogramPanel.this.histogramPlotConfig.useRoiMask || HistogramPanel.this.histogramPlotConfig.numBins != 512 || HistogramPanel.this.histogramPlotConfig.histogramLogScaled || this.min != null || this.max != null) {
                StxFactory factory = new StxFactory();
                if (HistogramPanel.this.histogramPlotConfig.useRoiMask) {
                    factory.withRoiMask(HistogramPanel.this.histogramPlotConfig.roiMask);
                }
                factory.withHistogramBinCount(Integer.valueOf(HistogramPanel.this.histogramPlotConfig.numBins));
                factory.withLogHistogram(HistogramPanel.this.histogramPlotConfig.histogramLogScaled);
                if (this.min != null) {
                    if (HistogramPanel.this.histogramPlotConfig.histogramLogScaled) {
                        factory.withMinimum((Number)Stx.LOG10_SCALING.scaleInverse(this.min.doubleValue()));
                    } else {
                        factory.withMinimum((Number)this.min);
                    }
                }
                if (this.max != null) {
                    if (HistogramPanel.this.histogramPlotConfig.histogramLogScaled) {
                        factory.withMaximum((Number)Stx.LOG10_SCALING.scaleInverse(this.max.doubleValue()));
                    } else {
                        factory.withMaximum((Number)this.max);
                    }
                }
                stx = factory.create(HistogramPanel.this.getRaster(), pm);
            } else {
                stx = HistogramPanel.this.getRaster().getStx(true, pm);
            }
            if (HistogramPanel.this.getRaster() != config.raster) {
                return null;
            }
            return stx;
        }

        public void done() {
            try {
                Stx stx = (Stx)this.get();
                if (stx == null) {
                    return;
                }
                if (stx.getSampleCount() > 0L) {
                    if (this.autoMinMaxEnabled) {
                        HistogramPanel.this.histogramComputing = true;
                        HistogramPanel.this.xAxisRangeControl.adjustComponents(stx.getHistogramScaling().scale(stx.getMinimum()), stx.getHistogramScaling().scale(stx.getMaximum()), 4);
                        HistogramPanel.this.histogramComputing = false;
                    }
                    HistogramPanel.this.setStx(stx);
                } else {
                    Dialogs.showError("Either the selected ROI is empty or no pixels have been found within the minimum and maximum values specified.\nNo valid histogram could be computed.\n");
                    HistogramPanel.this.handleStxChange();
                }
            }
            catch (ExecutionException e) {
                if (HistogramPanel.this.histogramPlotConfig.useRoiMask) {
                    Dialogs.showError("An internal error occurred.\nNo valid histogram could be computed.\nPossible reason: The selected ROI is empty.");
                } else {
                    Dialogs.showError("An internal error occurred.\nNo valid histogram could be computed. Reason:\n" + e.getMessage());
                }
                HistogramPanel.this.handleStxChange();
            }
            catch (InterruptedException e) {
                Dialogs.showError("The histogram computation has been interrupted.");
                HistogramPanel.this.handleStxChange();
            }
        }
    }

    private class AxisControlChangeListener
    implements PropertyChangeListener {
        boolean adjusting;

        private AxisControlChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.adjusting) {
                this.adjusting = true;
                if (evt.getPropertyName().equals(HistogramPanel.PROPERTY_NAME_LOGARITHMIC_HISTOGRAM)) {
                    if (evt.getNewValue().equals(Boolean.TRUE)) {
                        HistogramPanel.this.xAxisRangeControl.adjustComponents(Stx.LOG10_SCALING.scale(HistogramPanel.this.xAxisRangeControl.getMin().doubleValue()), Stx.LOG10_SCALING.scale(HistogramPanel.this.xAxisRangeControl.getMax().doubleValue()), 3);
                    } else {
                        HistogramPanel.this.xAxisRangeControl.adjustComponents(Stx.LOG10_SCALING.scaleInverse(HistogramPanel.this.xAxisRangeControl.getMin().doubleValue()), Stx.LOG10_SCALING.scaleInverse(HistogramPanel.this.xAxisRangeControl.getMax().doubleValue()), 3);
                    }
                }
                this.adjusting = false;
            }
        }
    }

    private static class HistogramPlotConfig {
        private boolean xAxisLogScaled;
        private boolean histogramLogScaled;
        private int numBins = 512;
        private boolean useRoiMask;
        private Mask roiMask;

        private HistogramPlotConfig() {
        }
    }
}

